/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.CniIncludePrinter;
import gnu.classpath.tools.javah.CniStubPrinter;
import gnu.classpath.tools.javah.JniIncludePrinter;
import gnu.classpath.tools.javah.JniStubPrinter;
import gnu.classpath.tools.javah.PathOptionGroup;
import gnu.classpath.tools.javah.Printer;
import gnu.classpath.tools.javah.Text;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.InnerClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    PathOptionGroup classpath = new PathOptionGroup();
    String outputDir;
    String outFileName;
    URLClassLoader loader;
    String allDirectory;
    boolean verbose;
    boolean stubs;
    boolean cni;
    boolean cniOrJniSeen;
    boolean force;
    HashMap<String, ClassWrapper> classMap = new HashMap();
    HashMap<String, ArrayList<Text>> textMap = new HashMap();
    Set<String> parsed = new HashSet<String>();

    void readCommandFile(String textFileName) throws OptionException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(textFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OptionException("file \"" + textFileName + "\" not found");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
        String currentClass = null;
        ArrayList<Text> currentValues = null;
        while (true) {
            int cmdValue;
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (line == null) break;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
            int index = line.indexOf(32);
            String cmd = line.substring(0, index);
            String value = line.substring(index + 1);
            if ("class".equals(cmd)) {
                if (currentClass != null) {
                    this.textMap.put(currentClass, currentValues);
                }
                currentClass = value;
                currentValues = new ArrayList<Text>();
                continue;
            }
            if (currentClass == null) {
                throw new OptionException("no class set");
            }
            if ("add".equals(cmd)) {
                cmdValue = 0;
            } else if ("append".equals(cmd)) {
                cmdValue = 1;
            } else if ("prepend".equals(cmd)) {
                cmdValue = 3;
            } else if ("friend".equals(cmd)) {
                cmdValue = 2;
            } else {
                throw new OptionException("unrecognized command: " + cmd);
            }
            currentValues.add(new Text(cmdValue, value));
        }
        if (currentClass != null) {
            this.textMap.put(currentClass, currentValues);
        }
    }

    void scanDirectory(File dir, final HashSet<Object> results) {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    Main.this.scanDirectory(pathname, results);
                    return false;
                }
                return pathname.getName().endsWith(".class");
            }
        });
        if (files != null) {
            results.addAll(Arrays.asList(files));
        }
    }

    protected String getName() {
        return "javah";
    }

    protected ClasspathToolParser getParser() {
        ClasspathToolParser result = new ClasspathToolParser(this.getName(), true);
        result.setHeader("usage: javah [OPTIONS] CLASS...");
        result.add(this.classpath);
        result.add(new Option('d', "Set output directory", "DIR"){

            public void parsed(String dir) throws OptionException {
                if (Main.this.outputDir != null) {
                    throw new OptionException("-d already seen");
                }
                if (Main.this.outFileName != null) {
                    throw new OptionException("only one of -d or -o may be used");
                }
                Main.this.outputDir = dir;
            }
        });
        result.add(new Option('o', "Set output file (only one of -d or -o may be used)", "FILE"){

            public void parsed(String fileName) throws OptionException {
                if (Main.this.outFileName != null) {
                    throw new OptionException("-o already seen");
                }
                if (Main.this.outputDir != null) {
                    throw new OptionException("only one of -d or -o may be used");
                }
                Main.this.outFileName = fileName;
            }
        });
        result.add(new Option("cmdfile", "Read command file", "FILE"){

            public void parsed(String file) throws OptionException {
                Main.this.readCommandFile(file);
            }
        });
        result.add(new Option("all", "Operate on all class files under directory", "DIR"){

            public void parsed(String arg) throws OptionException {
                if (Main.this.allDirectory != null) {
                    throw new OptionException("-all already specified");
                }
                Main.this.allDirectory = arg;
            }
        });
        result.add(new Option("stubs", "Emit stub implementation"){

            public void parsed(String arg0) throws OptionException {
                Main.this.stubs = true;
            }
        });
        result.add(new Option("jni", "Emit JNI stubs or header (default)"){

            public void parsed(String arg0) throws OptionException {
                if (Main.this.cniOrJniSeen && Main.this.cni) {
                    throw new OptionException("only one of -jni or -cni may be used");
                }
                Main.this.cniOrJniSeen = true;
                Main.this.cni = false;
            }
        });
        result.add(new Option("cni", "Emit CNI stubs or header (default JNI)"){

            public void parsed(String arg0) throws OptionException {
                if (Main.this.cniOrJniSeen && !Main.this.cni) {
                    throw new OptionException("only one of -jni or -cni may be used");
                }
                Main.this.cniOrJniSeen = true;
                Main.this.cni = true;
            }
        });
        result.add(new Option("verbose", 'v', "Set verbose mode"){

            public void parsed(String arg0) throws OptionException {
                Main.this.verbose = true;
            }
        });
        result.add(new Option("force", "Output files should always be written"){

            public void parsed(String arg0) throws OptionException {
                Main.this.force = true;
            }
        });
        return result;
    }

    private File makeOutputDirectory() throws IOException {
        File outputFile = this.outputDir == null ? new File(".") : new File(this.outputDir);
        return outputFile;
    }

    private File makeOutputFile() throws IOException {
        File result = new File(this.outFileName);
        if (result.exists()) {
            if (!result.isFile()) {
                throw new IOException("'" + this.outFileName + "' is not a file");
            }
            if (!this.force) {
                if (this.verbose) {
                    System.err.println("[" + this.outFileName + " already exists.  Use -force to overwrite]");
                }
                return null;
            }
            if (!result.delete()) {
                throw new IOException("Was unable to delete existing file: " + this.outFileName);
            }
        }
        return result;
    }

    private void writeHeaders(Map<File, ClassWrapper> klasses, Printer printer) throws IOException {
        for (Map.Entry<File, ClassWrapper> e : klasses.entrySet()) {
            File file = e.getKey();
            ClassWrapper klass = e.getValue();
            if (this.verbose) {
                System.err.println("[writing " + klass + " as " + file + "]");
            }
            printer.printClass(file, klass);
        }
    }

    private Map<File, ClassWrapper> parseClasses(Iterator<Object> inputs) throws IOException {
        HashMap<File, ClassWrapper> results = new HashMap<File, ClassWrapper>();
        while (inputs.hasNext()) {
            File filename;
            ClassWrapper klass;
            Object item = inputs.next();
            if (item instanceof File) {
                if (this.verbose) {
                    System.err.println("[reading file " + item + "]");
                }
                klass = this.getClass((File)item);
                filename = new File(klass.name);
            } else {
                String className = ((String)item).replace('.', '/');
                if (this.verbose) {
                    System.err.println("[reading class " + className + "]");
                }
                filename = new File(className);
                klass = this.getClass(className);
            }
            results.put(filename, klass);
            this.parsed.add(item.toString());
            if (item instanceof File) continue;
            Iterator innerClasses = klass.innerClasses.iterator();
            HashSet<String> innerNames = new HashSet<String>();
            while (innerClasses.hasNext()) {
                String innerName = ((InnerClassNode)innerClasses.next()).name;
                if (this.parsed.contains(innerName)) continue;
                innerNames.add(innerName);
            }
            results.putAll(this.parseClasses(innerNames.iterator()));
        }
        return results;
    }

    protected void postParse(String[] names) {
    }

    protected void run(String[] args) throws IOException {
        File outputFile;
        ClasspathToolParser p = this.getParser();
        String[] classNames = p.parse(args, true);
        this.postParse(classNames);
        this.loader = this.classpath.getLoader();
        boolean isDirectory = this.outFileName == null;
        File file = outputFile = isDirectory ? this.makeOutputDirectory() : this.makeOutputFile();
        if (outputFile == null) {
            return;
        }
        Printer printer = !this.cni ? (this.stubs ? new JniStubPrinter(this, outputFile, isDirectory, this.force) : new JniIncludePrinter(this, outputFile, isDirectory, this.force)) : (this.stubs ? new CniStubPrinter(this, outputFile, isDirectory, this.force) : new CniIncludePrinter(this, outputFile, isDirectory, this.force));
        HashSet<Object> klasses = new HashSet<Object>();
        if (this.allDirectory != null) {
            this.scanDirectory(new File(this.allDirectory), klasses);
        }
        int i = 0;
        while (i < classNames.length) {
            if (classNames[i].endsWith(".class")) {
                klasses.add(new File(classNames[i]));
            } else {
                klasses.add(classNames[i]);
            }
            ++i;
        }
        Map<File, ClassWrapper> results = this.parseClasses(klasses.iterator());
        this.writeHeaders(results, printer);
    }

    public ArrayList<Text> getClassTextList(String name) {
        return this.textMap.get(name);
    }

    private ClassWrapper readClass(InputStream is) throws IOException {
        ClassReader r = new ClassReader(is);
        ClassWrapper result = new ClassWrapper(this);
        r.accept(result, true);
        is.close();
        return result;
    }

    private ClassWrapper getClass(File fileName) throws IOException {
        FileInputStream is = new FileInputStream(fileName);
        ClassWrapper result = this.readClass(is);
        if (this.classMap.containsKey(result.name)) {
            throw new IllegalArgumentException("class " + result.name + " already loaded");
        }
        this.classMap.put(result.name, result);
        return result;
    }

    public ClassWrapper getClass(String name) throws IOException {
        if (!this.classMap.containsKey(name)) {
            String resource = String.valueOf(name.replace('.', '/')) + ".class";
            URL url = this.loader.findResource(resource);
            if (url == null) {
                throw new IOException("can't find class file " + resource + " in " + this.loader);
            }
            InputStream is = url.openStream();
            ClassWrapper result = this.readClass(is);
            this.classMap.put(name, result);
        }
        return this.classMap.get(name);
    }

    public static void main(String[] args) throws IOException {
        Main m = new Main();
        m.run(args);
    }
}

