/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging.filelogs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.FileLog;
import net.sourceforge.jnlp.util.logging.SingleStreamLogger;

public final class WriterBasedFileLog
implements SingleStreamLogger {
    private final BufferedWriter bw;

    public WriterBasedFileLog(String fileName, boolean append) {
        this(fileName, fileName, append);
    }

    public WriterBasedFileLog(String loggerName, String fileName, boolean append) {
        try {
            File futureFile = new File(fileName);
            if (!futureFile.exists()) {
                FileUtils.createRestrictedFile(futureFile, true);
            }
            this.bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName), append), "UTF-8"));
            this.log(FileLog.getHeadlineHeader().toString() + " writer-based impl.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void log(String s) {
        try {
            this.bw.write(s);
            if (!s.endsWith("\n")) {
                this.bw.newLine();
            }
            this.bw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.bw.flush();
        }
        finally {
            this.bw.close();
        }
    }
}

