/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public abstract class AbstractChangesetDownloadTask
extends AbstractDownloadTask<Set<Changeset>> {
    private RunnableDownloadTask downloadTaskRunnable;

    protected final void setDownloadTask(RunnableDownloadTask runnableDownloadTask) {
        this.downloadTaskRunnable = runnableDownloadTask;
    }

    @Override
    public final Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return this.download();
    }

    public final Future<?> download() {
        return this.downloadTaskRunnable != null ? Main.worker.submit(this.downloadTaskRunnable) : null;
    }

    @Override
    public final Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        return this.downloadTaskRunnable != null ? Main.worker.submit(this.downloadTaskRunnable) : null;
    }

    @Override
    public final void cancel() {
        if (this.downloadTaskRunnable != null) {
            this.downloadTaskRunnable.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL uRL) {
        return null;
    }

    abstract class RunnableDownloadTask
    extends PleaseWaitRunnable {
        protected final OsmServerChangesetReader reader;
        protected final Set<Changeset> downloadedChangesets;
        protected Exception lastException;

        RunnableDownloadTask(Component component, String string) {
            super(component, string, false);
            this.reader = new OsmServerChangesetReader();
            this.downloadedChangesets = new HashSet<Changeset>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            AbstractChangesetDownloadTask.this.setCanceled(true);
            RunnableDownloadTask runnableDownloadTask = this;
            synchronized (runnableDownloadTask) {
                if (this.reader != null) {
                    this.reader.cancel();
                }
            }
        }

        protected final void rememberLastException(Exception exception) {
            this.lastException = exception;
            AbstractChangesetDownloadTask.this.setFailed(true);
        }

        protected final void updateChangesets() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ChangesetCache.getInstance().update(RunnableDownloadTask.this.downloadedChangesets);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                    Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while updating changeset cache");
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof RuntimeException) {
                        BugReportExceptionHandler.handleException(throwable);
                    }
                    if (throwable instanceof Exception) {
                        ExceptionUtil.explainException(invocationTargetException);
                    }
                    BugReportExceptionHandler.handleException(throwable);
                }
            }
        }
    }
}

