/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.data.preferences.LongProperty;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;

public class TMSCachedTileLoaderJob
extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry>
implements TileJob,
ICachedLoaderListener {
    private static final Logger LOG = FeatureAdapter.getLogger(TMSCachedTileLoaderJob.class.getCanonicalName());
    private static final LongProperty MAXIMUM_EXPIRES = new LongProperty("imagery.generic.maximum_expires", 2592000000L);
    private static final LongProperty MINIMUM_EXPIRES = new LongProperty("imagery.generic.minimum_expires", 3600000L);
    private final Tile tile;
    private volatile URL url;
    private static final ConcurrentMap<String, Set<TileLoaderListener>> inProgress = new ConcurrentHashMap<String, Set<TileLoaderListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMSCachedTileLoaderJob(TileLoaderListener tileLoaderListener, Tile tile, ICacheAccess<String, BufferedImageCacheEntry> iCacheAccess, int n, int n2, Map<String, String> map, ThreadPoolExecutor threadPoolExecutor) {
        super(iCacheAccess, n, n2, map, threadPoolExecutor);
        this.tile = tile;
        if (tileLoaderListener != null) {
            String string = this.getCacheKey();
            ConcurrentMap<String, Set<TileLoaderListener>> concurrentMap = inProgress;
            synchronized (concurrentMap) {
                HashSet<TileLoaderListener> hashSet = (HashSet<TileLoaderListener>)inProgress.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<TileLoaderListener>();
                    inProgress.put(string, hashSet);
                }
                hashSet.add(tileLoaderListener);
            }
        }
    }

    @Override
    public Tile getTile() {
        return this.getCachedTile();
    }

    @Override
    public String getCacheKey() {
        if (this.tile != null) {
            TileSource tileSource = this.tile.getTileSource();
            String string = tileSource.getName();
            if (string == null) {
                string = "";
            }
            return string.replace(':', '_') + ':' + tileSource.getTileId(this.tile.getZoom(), this.tile.getXtile(), this.tile.getYtile());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getUrl() throws IOException {
        if (this.url == null) {
            TMSCachedTileLoaderJob tMSCachedTileLoaderJob = this;
            synchronized (tMSCachedTileLoaderJob) {
                if (this.url == null) {
                    this.url = new URL(this.tile.getUrl());
                }
            }
        }
        return this.url;
    }

    @Override
    public boolean isObjectLoadable() {
        if (this.cacheData != null) {
            byte[] byArray = ((BufferedImageCacheEntry)this.cacheData).getContent();
            try {
                return byArray != null || ((BufferedImageCacheEntry)this.cacheData).getImage() != null || this.isNoTileAtZoom();
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "JCS TMS - error loading from cache for tile {0}: {1}", new Object[]{this.tile.getKey(), iOException.getMessage()});
            }
        }
        return false;
    }

    @Override
    protected boolean isResponseLoadable(Map<String, List<String>> map, int n, byte[] byArray) {
        this.attributes.setMetadata(this.tile.getTileSource().getMetadata(map));
        if (this.tile.getTileSource().isNoTileAtZoom(map, n, byArray)) {
            this.attributes.setNoTileAtZoom(true);
            return false;
        }
        return super.isResponseLoadable(map, n, byArray);
    }

    @Override
    protected boolean cacheAsEmpty() {
        return this.isNoTileAtZoom() || super.cacheAsEmpty();
    }

    @Override
    public void submit(boolean bl) {
        this.tile.initLoading();
        try {
            super.submit(this, bl);
        }
        catch (IOException iOException) {
            Main.warn((Throwable)iOException, false);
            this.tile.finishLoading();
            this.tile.setError(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadingFinished(CacheEntry cacheEntry, CacheEntryAttributes cacheEntryAttributes, ICachedLoaderListener.LoadResult loadResult) {
        block17: {
            Set set;
            this.attributes = cacheEntryAttributes;
            ConcurrentMap<String, Set<TileLoaderListener>> concurrentMap = inProgress;
            synchronized (concurrentMap) {
                set = (Set)inProgress.remove(this.getCacheKey());
            }
            boolean bl = loadResult.equals((Object)ICachedLoaderListener.LoadResult.SUCCESS);
            try {
                this.tile.finishLoading();
                if (this.attributes != null) {
                    for (Map.Entry<String, String> object : this.attributes.getMetadata().entrySet()) {
                        this.tile.putValue(object.getKey(), object.getValue());
                    }
                }
                switch (loadResult) {
                    case SUCCESS: {
                        this.handleNoTileAtZoom();
                        int n = cacheEntryAttributes.getResponseCode();
                        if (!this.isNoTileAtZoom() && n >= 400) {
                            if (cacheEntryAttributes.getErrorMessage() == null) {
                                this.tile.setError(I18n.tr("HTTP error {0} when loading tiles", n));
                            } else {
                                this.tile.setError(I18n.tr("Error downloading tiles: {0}", cacheEntryAttributes.getErrorMessage()));
                            }
                            bl = false;
                        }
                        bl &= this.tryLoadTileImage(cacheEntry);
                        break;
                    }
                    case FAILURE: {
                        this.tile.setError("Problem loading tile");
                        this.tryLoadTileImage(cacheEntry);
                        break;
                    }
                    case CANCELED: {
                        this.tile.loadingCanceled();
                    }
                }
                if (set == null) break block17;
                for (TileLoaderListener tileLoaderListener : set) {
                    tileLoaderListener.tileLoadingFinished(this.tile, bl);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "JCS TMS - error loading object for tile {0}: {1}", new Object[]{this.tile.getKey(), iOException.getMessage()});
                this.tile.setError(iOException.toString());
                this.tile.setLoaded(false);
                if (set == null) break block17;
                for (TileLoaderListener tileLoaderListener : set) {
                    tileLoaderListener.tileLoadingFinished(this.tile, false);
                }
            }
        }
    }

    @Override
    protected String getServerKey() {
        TileSource tileSource = this.tile.getSource();
        if (tileSource instanceof AbstractTMSTileSource) {
            return ((AbstractTMSTileSource)tileSource).getBaseUrl();
        }
        return super.getServerKey();
    }

    @Override
    protected BufferedImageCacheEntry createCacheEntry(byte[] byArray) {
        return new BufferedImageCacheEntry(byArray);
    }

    @Override
    public void submit() {
        this.submit(false);
    }

    @Override
    protected CacheEntryAttributes parseHeaders(HttpClient.Response response) {
        CacheEntryAttributes cacheEntryAttributes = super.parseHeaders(response);
        if (cacheEntryAttributes.getExpirationTime() < this.now + MINIMUM_EXPIRES.get()) {
            cacheEntryAttributes.setExpirationTime(this.now + MINIMUM_EXPIRES.get());
        }
        if (cacheEntryAttributes.getExpirationTime() > this.now + MAXIMUM_EXPIRES.get()) {
            cacheEntryAttributes.setExpirationTime(this.now + MAXIMUM_EXPIRES.get());
        }
        return cacheEntryAttributes;
    }

    public Tile getCachedTile() {
        BufferedImageCacheEntry bufferedImageCacheEntry = (BufferedImageCacheEntry)this.get();
        if (this.isObjectLoadable() && this.isCacheElementValid()) {
            try {
                if (this.attributes != null) {
                    for (Map.Entry<String, String> entry : this.attributes.getMetadata().entrySet()) {
                        this.tile.putValue(entry.getKey(), entry.getValue());
                    }
                }
                if (bufferedImageCacheEntry != null) {
                    if (bufferedImageCacheEntry.getImage() != null) {
                        this.tile.setImage(bufferedImageCacheEntry.getImage());
                        this.tile.finishLoading();
                    } else {
                        this.tile.setError(I18n.tr("Could not load image from tile server", new Object[0]));
                    }
                }
                if (this.isNoTileAtZoom()) {
                    this.handleNoTileAtZoom();
                    this.tile.finishLoading();
                }
                if (this.attributes != null && this.attributes.getResponseCode() >= 400) {
                    if (this.attributes.getErrorMessage() == null) {
                        this.tile.setError(I18n.tr("HTTP error {0} when loading tiles", this.attributes.getResponseCode()));
                    } else {
                        this.tile.setError(I18n.tr("Error downloading tiles: {0}", this.attributes.getErrorMessage()));
                    }
                }
                return this.tile;
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "JCS TMS - error loading object for tile {0}: {1}", new Object[]{this.tile.getKey(), iOException.getMessage()});
                return null;
            }
        }
        return this.tile;
    }

    private boolean handleNoTileAtZoom() {
        if (this.isNoTileAtZoom()) {
            LOG.log(Level.FINE, "JCS TMS - Tile valid, but no file, as no tiles at this level {0}", this.tile);
            this.tile.setError("No tile at this zoom level");
            this.tile.putValue("tile-info", "no-tile");
            return true;
        }
        return false;
    }

    private boolean isNoTileAtZoom() {
        if (this.attributes == null) {
            LOG.warning("Cache attributes are null");
        }
        return this.attributes != null && this.attributes.isNoTileAtZoom();
    }

    private boolean tryLoadTileImage(CacheEntry cacheEntry) throws IOException {
        byte[] byArray;
        if (cacheEntry != null && (byArray = cacheEntry.getContent()) != null && byArray.length > 0) {
            this.tile.loadImage(new ByteArrayInputStream(byArray));
            if (this.tile.getImage() == null) {
                this.tile.setError(I18n.tr("Could not load image from tile server", new Object[0]));
                return false;
            }
        }
        return true;
    }
}

