/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;

public class SideButton
extends JButton
implements Destroyable {
    private transient PropertyChangeListener propertyChangeListener;

    public SideButton(Action action) {
        super(action);
        ImageResource imageResource = (ImageResource)action.getValue("ImageResource");
        if (imageResource != null) {
            this.setIcon(imageResource.getImageIconBounded(ImageProvider.ImageSizes.SIDEBUTTON.getImageDimension()));
        } else {
            Main.warn("Old style SideButton usage for action " + action);
            this.fixIcon(action);
        }
        this.doStyle();
    }

    public SideButton(Action action, boolean bl) {
        this(action);
        if (!bl) {
            this.setText(null);
        }
    }

    public SideButton(Action action, String string) {
        super(action);
        this.setIcon(ImageProvider.get("dialogs", string, ImageProvider.ImageSizes.SIDEBUTTON));
        this.doStyle();
    }

    @Deprecated
    private void fixIcon(Action action) {
        if (action != null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("SmallIcon".equals(propertyChangeEvent.getPropertyName())) {
                        SideButton.this.fixIcon(null);
                    }
                }
            };
            action.addPropertyChangeListener(this.propertyChangeListener);
        }
        int n = ImageProvider.ImageSizes.SIDEBUTTON.getImageDimension().height;
        Icon icon = this.getIcon();
        if (icon instanceof ImageIcon && icon.getIconHeight() != n) {
            Image image = ((ImageIcon)icon).getImage();
            int n2 = image.getWidth(null) * n / image.getHeight(null);
            ImageIcon imageIcon = new ImageIcon(image.getScaledInstance(n2, n, 4));
            this.setIcon(imageIcon);
        }
    }

    private void doStyle() {
        this.setLayout(new BorderLayout());
        this.setIconTextGap(2);
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public BasicArrowButton createArrow(ActionListener actionListener) {
        this.setMargin(new Insets(0, 0, 0, 0));
        BasicArrowButton basicArrowButton = new BasicArrowButton(5, null, null, Color.BLACK, null);
        basicArrowButton.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)basicArrowButton, "East");
        basicArrowButton.addActionListener(actionListener);
        return basicArrowButton;
    }

    @Override
    public void destroy() {
        Action action = this.getAction();
        if (action instanceof Destroyable) {
            ((Destroyable)((Object)action)).destroy();
        }
        if (action != null) {
            if (this.propertyChangeListener != null) {
                action.removePropertyChangeListener(this.propertyChangeListener);
            }
            this.setAction(null);
        }
    }
}

