/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.widgets.SearchTextResultListPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class MenuItemSearchDialog
extends ExtendedDialog {
    private final Selector selector;
    private static final MenuItemSearchDialog INSTANCE = new MenuItemSearchDialog(Main.main.menu);

    private MenuItemSearchDialog(MainMenu mainMenu) {
        super(Main.parent, I18n.tr("Search menu items", new Object[0]), new String[]{I18n.tr("Select", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.selector = new Selector(mainMenu);
        this.selector.setDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSearchDialog.this.buttonAction(0, null);
            }
        });
        this.setContent(this.selector, false);
        this.setPreferredSize(new Dimension(600, 300));
    }

    public static synchronized MenuItemSearchDialog getInstance() {
        return INSTANCE;
    }

    @Override
    public ExtendedDialog showDialog() {
        this.selector.init();
        super.showDialog();
        this.selector.clearSelection();
        return this;
    }

    @Override
    protected void buttonAction(int n, ActionEvent actionEvent) {
        super.buttonAction(n, actionEvent);
        if (n == 0 && this.selector.getSelectedItem() != null && this.selector.getSelectedItem().isEnabled()) {
            this.selector.getSelectedItem().getAction().actionPerformed(actionEvent);
        }
    }

    public static class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr("Search menu items", new Object[0]), "dialogs/search", null, Shortcut.registerShortcut("help:search-items", "Search menu items", 32, 5006), true, "dialogs/search-items", false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuItemSearchDialog.getInstance().showDialog();
        }
    }

    private static class CellRenderer
    implements ListCellRenderer<JMenuItem> {
        private final DefaultListCellRenderer def = new DefaultListCellRenderer();

        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JMenuItem> jList, JMenuItem jMenuItem, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.def.getListCellRendererComponent(jList, jMenuItem, n, bl, bl2);
            jLabel.setText(jMenuItem.getText());
            jLabel.setIcon(jMenuItem.getIcon());
            jLabel.setEnabled(jMenuItem.isEnabled());
            JMenuItem jMenuItem2 = new JMenuItem(jMenuItem.getText());
            jMenuItem2.setAction(jMenuItem.getAction());
            if (bl) {
                jMenuItem2.setBackground(jList.getSelectionBackground());
                jMenuItem2.setForeground(jList.getSelectionForeground());
            } else {
                jMenuItem2.setBackground(jList.getBackground());
                jMenuItem2.setForeground(jList.getForeground());
            }
            return jMenuItem2;
        }
    }

    private static class Selector
    extends SearchTextResultListPanel<JMenuItem> {
        private final MainMenu menu;

        Selector(MainMenu mainMenu) {
            this.menu = mainMenu;
            this.lsResult.setCellRenderer(new CellRenderer());
        }

        public JMenuItem getSelectedItem() {
            JMenuItem jMenuItem = (JMenuItem)this.lsResult.getSelectedValue();
            if (jMenuItem != null) {
                return jMenuItem;
            }
            if (!this.lsResultModel.isEmpty()) {
                return (JMenuItem)this.lsResultModel.getElementAt(0);
            }
            return null;
        }

        @Override
        protected void filterItems() {
            this.lsResultModel.setItems(this.menu.findMenuItems(this.edSearchText.getText(), true));
        }
    }
}

