/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.dialogs.MapPaintDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.util.StayOpenCheckBoxMenuItem;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapPaintMenu
extends JMenu
implements MapPaintStyles.MapPaintSylesUpdateListener {
    private final transient Map<String, MapPaintAction> actions = new HashMap<String, MapPaintAction>();

    public MapPaintMenu() {
        super(I18n.tr("Map Paint Styles", new Object[0]));
        this.setIcon(ImageProvider.get("dialogs", "mapstyle", ImageProvider.ImageSizes.MENU));
        MapPaintStyles.addMapPaintSylesUpdateListener(this);
        this.putClientProperty("help", HelpUtil.ht("/Dialog/MapPaint"));
    }

    @Override
    public void mapPaintStylesUpdated() {
        this.removeAll();
        for (StyleSource styleSource : MapPaintStyles.getStyles().getStyleSources()) {
            String string = styleSource.getDisplayString();
            MapPaintAction mapPaintAction = this.actions.get(string);
            if (mapPaintAction == null) {
                mapPaintAction = new MapPaintAction(styleSource);
                this.actions.put(string, mapPaintAction);
                this.add(mapPaintAction.getButton());
                continue;
            }
            mapPaintAction.setStyle(styleSource);
            this.add(mapPaintAction.getButton());
            mapPaintAction.updateButton();
        }
        this.addSeparator();
        this.add(MapPaintDialog.PREFERENCE_ACTION);
    }

    @Override
    public void mapPaintStyleEntryUpdated(int n) {
        this.mapPaintStylesUpdated();
    }

    private static class MapPaintAction
    extends JosmAction {
        private transient StyleSource style;
        private final JCheckBoxMenuItem button = new StayOpenCheckBoxMenuItem(this);

        MapPaintAction(StyleSource styleSource) {
            super(styleSource.getDisplayString(), styleSource.getIconProvider(), I18n.tr("Select the map painting styles", new Object[0]), null, true, "mappaint/" + styleSource.getDisplayString(), true);
            this.style = styleSource;
            this.updateButton();
            this.putValue("help", HelpUtil.ht("/Dialog/MapPaint"));
        }

        private void updateButton() {
            this.button.getModel().setSelected(this.style.active);
        }

        private void toggleStyle() {
            MapPaintStyles.toggleStyleActive(MapPaintStyles.getStyles().getStyleSources().indexOf(this.style));
            this.updateButton();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.toggleStyle();
        }

        public JCheckBoxMenuItem getButton() {
            return this.button;
        }

        public void setStyle(StyleSource styleSource) {
            this.style = styleSource;
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(Main.isDisplayingMapView() && (Main.main.hasEditLayer() || MapPaintAction.mapHasGpxorMarkerLayer()));
        }

        private static boolean mapHasGpxorMarkerLayer() {
            for (Layer layer : Main.getLayerManager().getLayers()) {
                if (!(layer instanceof GpxLayer) && !(layer instanceof MarkerLayer)) continue;
                return true;
            }
            return false;
        }
    }
}

