/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class AddWayHandler
extends RequestHandler {
    public static final String command = "add_way";
    private final List<LatLon> allCoordinates = new ArrayList<LatLon>();
    private Way way;
    private Map<LatLon, Node> addedNodes;

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"way"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"addtags"};
    }

    @Override
    public String getUsage() {
        return "adds a way (given by a semicolon separated sequence of lat,lon pairs) to the current dataset";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/add_way?way=53.2,13.3;53.3,13.3;53.3,13.2", "/add_way?&addtags=building=yes&way=45.437213,-2.810792;45.437988,-2.455983;45.224080,-2.455036;45.223302,-2.809845;45.437213,-2.810792"};
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                AddWayHandler.this.way = AddWayHandler.this.addWay();
            }
        });
        AddTagsDialog.addTags(this.args, this.sender, Collections.singleton(this.way));
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to create a new way.", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.CREATE_OBJECTS;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.allCoordinates.clear();
        for (String string : (this.args != null ? (String)this.args.get("way") : "").split(";\\s*")) {
            Object[] objectArray = string.split(",\\s*", 2);
            if (objectArray.length < 2) {
                throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("Invalid coordinates: {0}", Arrays.toString(objectArray)));
            }
            try {
                double d = Double.parseDouble(objectArray[0]);
                double d2 = Double.parseDouble((String)objectArray[1]);
                this.allCoordinates.add(new LatLon(d, d2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new RequestHandler.RequestHandlerBadRequestException("NumberFormatException (" + numberFormatException.getMessage() + ')', numberFormatException);
            }
        }
        if (this.allCoordinates.isEmpty()) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("Empty ways", new Object[0]));
        }
        if (this.allCoordinates.size() == 1) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("One node ways", new Object[0]));
        }
        if (!Main.main.hasEditLayer()) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("There is no layer opened to add way", new Object[0]));
        }
    }

    Node findOrCreateNode(LatLon latLon, List<Command> list) {
        Object object;
        Object object2 = null;
        if (Main.isDisplayingMapView() && (object2 = Main.map.mapView.getNearestNode((Point)(object = Main.map.mapView.getPoint(latLon)), OsmPrimitive.isUsablePredicate)) != null && ((Node)object2).getCoor().greatCircleDistance(latLon) > Main.pref.getDouble("remote.tolerance", 0.1)) {
            object2 = null;
        }
        object = null;
        for (Map.Entry<LatLon, Node> entry : this.addedNodes.entrySet()) {
            LatLon latLon2 = entry.getKey();
            if (!(latLon2.greatCircleDistance(latLon) < Main.pref.getDouble("remotecontrol.tolerance", 0.1))) continue;
            object = entry.getValue();
            break;
        }
        if (object != null) {
            object2 = object;
        } else if (object2 == null) {
            object2 = new Node(latLon);
            list.add(new AddCommand((OsmPrimitive)object2));
            this.addedNodes.put(latLon, (Node)object2);
        }
        return object2;
    }

    private Way addWay() {
        this.addedNodes = new HashMap<LatLon, Node>();
        Way way = new Way();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (LatLon latLon : this.allCoordinates) {
            Node node = this.findOrCreateNode(latLon, linkedList);
            way.addNode(node);
        }
        this.allCoordinates.clear();
        linkedList.add(new AddCommand(way));
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Add way", new Object[0]), linkedList));
        Main.getLayerManager().getEditDataSet().setSelected(way);
        if (PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            AutoScaleAction.autoScale("selection");
        } else {
            Main.map.mapView.repaint();
        }
        return way;
    }
}

