/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectType;
import org.netbeans.modules.cnd.makeproject.actions.AddExistingFolderItemsAction;
import org.netbeans.modules.cnd.makeproject.actions.AddExistingItemAction;
import org.netbeans.modules.cnd.makeproject.actions.DebugTestAction;
import org.netbeans.modules.cnd.makeproject.actions.NewFolderAction;
import org.netbeans.modules.cnd.makeproject.actions.NewTestActionFactory;
import org.netbeans.modules.cnd.makeproject.actions.RunTestAction;
import org.netbeans.modules.cnd.makeproject.actions.StepIntoTestAction;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.BrokenIncludes;
import org.netbeans.modules.cnd.makeproject.api.ui.LogicalViewNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.ui.LogicalViewNodeProviders;
import org.netbeans.modules.cnd.makeproject.ui.AddExternalItemAction;
import org.netbeans.modules.cnd.makeproject.ui.AnnotatedNode;
import org.netbeans.modules.cnd.makeproject.ui.CompileSingleAction;
import org.netbeans.modules.cnd.makeproject.ui.MoreBuildActionsAction;
import org.netbeans.modules.cnd.makeproject.ui.ProjectTabBridge;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesItemAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoteDevelopmentAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoteSyncActions;
import org.netbeans.modules.cnd.makeproject.ui.RemoveFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoveItemAction;
import org.netbeans.modules.cnd.makeproject.ui.SetConfigurationAction;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;

public class MakeLogicalViewProvider
implements LogicalViewProvider {
    private final MakeProject project;
    private static final Boolean ASYNC_ROOT_NODE = Boolean.getBoolean("cnd.async.root");
    private static final Logger log = Logger.getLogger("cnd.async.root");
    private static final MessageFormat ITEM_VIEW_FLAVOR = new MessageFormat("application/x-org-netbeans-modules-cnd-makeproject-uidnd; class=org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider$ViewItemNode; mask={0}");
    private static final boolean SYNC_PROJECT_ACTION = Boolean.getBoolean("cnd.remote.sync.project.action");
    private static final boolean DOWNLOAD_ACTION = Boolean.getBoolean("cnd.remote.download.project.action");
    private static final String PRIMARY_TYPE = "application";
    private static final String SUBTYPE = "x-org-netbeans-modules-cnd-makeproject-uidnd";
    private static final String MASK = "mask";
    private static StandardNodeAction renameAction = null;
    private static StandardNodeAction deleteAction = null;
    private static final RequestProcessor ANNOTATION_RP = new RequestProcessor("MakeLogicalViewProvider.AnnotationUpdater", 10);
    private static final RequestProcessor LOAD_NODES_RP = new RequestProcessor("MakeLogicalViewProvider.LoadingNodes", 10);
    private final AtomicBoolean findPathMode = new AtomicBoolean(false);
    private static final String brokenProjectBadgePath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif";
    private static final String brokenIncludeImgPath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenIncludeBadge.png";
    private static final Image brokenProjectBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif", "BrokenProjectTxt");
    private static final Image brokenIncludeBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenIncludeBadge.png", "BrokenIncludeTxt");
    private static final int WAIT_DELAY = 50;

    public MakeLogicalViewProvider(MakeProject project) {
        this.project = project;
        assert (project != null);
    }

    public Node createLogicalView() {
        MakeConfigurationDescriptor configurationDescriptor = this.getMakeConfigurationDescriptor();
        if (ASYNC_ROOT_NODE.booleanValue()) {
            log.log(Level.FINE, "creating async root node in EDT? {0}", SwingUtilities.isEventDispatchThread());
            return new MakeLogicalViewRootNode(configurationDescriptor.getLogicalFolders(), this);
        }
        if (configurationDescriptor == null || configurationDescriptor.getState() == ConfigurationDescriptor.State.BROKEN || configurationDescriptor.getConfs().size() == 0) {
            return new MakeLogicalViewRootNodeBroken(this.project);
        }
        return new MakeLogicalViewRootNode(configurationDescriptor.getLogicalFolders(), this);
    }

    private boolean isFindPathMode() {
        return this.findPathMode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node findPath(Node root, Object target) {
        Node returnNode = null;
        Project rootProject = (Project)root.getLookup().lookup(Project.class);
        if (rootProject == null) {
            return null;
        }
        if (target instanceof DataObject) {
            target = ((DataObject)target).getPrimaryFile();
        }
        if (!(target instanceof FileObject)) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)((FileObject)target));
        if (!this.gotMakeConfigurationDescriptor() || file == null) {
            return null;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        Item item = makeConfigurationDescriptor.findProjectItemByPath(file.getAbsolutePath());
        if (item == null && (item = makeConfigurationDescriptor.findExternalItemByPath(file.getAbsolutePath())) == null && (item = makeConfigurationDescriptor.findItemByFile(file)) == null) {
            return null;
        }
        if (this.findPathMode.compareAndSet(false, true)) {
            try {
                Node folderNode = MakeLogicalViewProvider.findFolderNode(root, item.getFolder());
                if (folderNode != null) {
                    Item nodeItem;
                    Node[] nodes = folderNode.getChildren().getNodes(true);
                    int index = 0;
                    for (index = 0; index < nodes.length && (nodeItem = (Item)nodes[index].getValue("Item")) != item; ++index) {
                    }
                    if (nodes.length > 0 && index < nodes.length) {
                        returnNode = nodes[index];
                    }
                }
            }
            finally {
                this.findPathMode.set(false);
            }
        }
        return returnNode;
    }

    private static Node findFolderNode(Node root, Folder folder) {
        if (root.getValue("Folder") == folder) {
            return root;
        }
        Folder parent = folder.getParent();
        if (parent == null) {
            return root;
        }
        Node parentNode = MakeLogicalViewProvider.findFolderNode(root, parent);
        if (parentNode == null) {
            return null;
        }
        Node[] nodes = parentNode.getChildren().getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].getValue("Folder") != folder) continue;
            return nodes[i];
        }
        return null;
    }

    private static Node findItemNode(Node root, Item item) {
        Node parentNode = MakeLogicalViewProvider.findFolderNode(root, item.getFolder());
        if (parentNode != null) {
            Node[] nodes = parentNode.getChildren().getNodes(true);
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i].getValue("Item") != item) continue;
                return nodes[i];
            }
        }
        return null;
    }

    public static void setVisible(Project project, Folder folder) {
        Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        Node projectRoot = MakeLogicalViewProvider.findProjectNode(rootNode, project);
        if (projectRoot == null) {
            return;
        }
        Node folderNode = MakeLogicalViewProvider.findFolderNode(projectRoot, folder);
        try {
            ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(new Node[]{folderNode});
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void setVisible(final Project project, final Item[] items) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (int i = 0; i < items.length; ++i) {
                    Node root = MakeLogicalViewProvider.findProjectNode(rootNode, project);
                    if (root == null) continue;
                    nodes.add(MakeLogicalViewProvider.findItemNode(root, items[i]));
                }
                try {
                    ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(nodes.toArray(new Node[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void checkForChangedName(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInformation pi;
                Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                Node root = MakeLogicalViewProvider.findProjectNode(rootNode, project);
                if (root != null && (pi = ProjectUtils.getInformation((Project)project)) != null) {
                    root.setDisplayName(pi.getDisplayName());
                }
            }
        });
    }

    public static void checkForChangedViewItemNodes(final Project project, Folder folder, final Item item) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object o;
                Node node;
                if (item == null) {
                    MakeLogicalViewProvider.checkForChangedViewItemNodes(project);
                    return;
                }
                Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                Node root = MakeLogicalViewProvider.findProjectNode(rootNode, project);
                if (root != null && (node = MakeLogicalViewProvider.findItemNode(root, item)) instanceof FilterNode && (o = node.getLookup().lookup(ViewItemNode.class)) != null) {
                    ((ChangeListener)o).stateChanged(null);
                }
            }
        });
    }

    private static void checkForChangedViewItemNodes(Project project) {
        Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        MakeLogicalViewProvider.checkForChangedViewItemNodes(MakeLogicalViewProvider.findProjectNode(rootNode, project));
    }

    private static void checkForChangedViewItemNodes(Node root) {
        if (root != null) {
            for (Node node : root.getChildren().getNodes(true)) {
                Object o;
                MakeLogicalViewProvider.checkForChangedViewItemNodes(node);
                if (!(node instanceof FilterNode) || (o = node.getLookup().lookup(ViewItemNode.class)) == null) continue;
                ((ChangeListener)o).stateChanged(null);
            }
        }
    }

    public static void refreshBrokenItems(Project project) {
        Node rootNode = MakeLogicalViewProvider.getRootNode();
        if (rootNode != null) {
            MakeLogicalViewProvider.refreshBrokenItemsImpl(MakeLogicalViewProvider.findProjectNode(rootNode, project));
        }
    }

    private static void refreshBrokenItemsImpl(Node root) {
        if (root != null) {
            if (root.isLeaf()) {
                BrokenViewItemNode brokenItem = (BrokenViewItemNode)((Object)root.getLookup().lookup(BrokenViewItemNode.class));
                if (brokenItem != null) {
                    brokenItem.refresh();
                }
            } else {
                for (Node node : root.getChildren().getNodes(true)) {
                    MakeLogicalViewProvider.refreshBrokenItemsImpl(node);
                }
            }
        }
    }

    private static Node getRootNode() {
        if (SwingUtilities.isEventDispatchThread()) {
            return ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        }
        final Node[] root = new Node[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    root[0] = MakeLogicalViewProvider.getRootNode();
                }
            });
        }
        catch (InterruptedException ex) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return root[0];
    }

    private static Node findProjectNode(Node root, Project p) {
        Node[] n = root.getChildren().getNodes(true);
        Lookup.Template t = new Lookup.Template(null, null, (Object)p);
        for (int cntr = 0; cntr < n.length; ++cntr) {
            if (n[cntr].getLookup().lookupItem(t) == null) continue;
            return n[cntr];
        }
        return null;
    }

    public static boolean hasBrokenLinks() {
        return false;
    }

    private static Image loadToolTipImage(String imgResouce, String textResource) {
        Image img = ImageUtilities.loadImage((String)imgResouce);
        img = ImageUtilities.assignToolTipToImage((Image)img, (String)("<img src=\"" + MakeLogicalViewRootNode.class.getClassLoader().getResource(imgResouce) + "\">&nbsp;" + NbBundle.getMessage(MakeLogicalViewRootNode.class, (String)textResource)));
        return img;
    }

    private static Node getWaitNode() {
        return new LoadingNode();
    }

    private static String getShortDescription(MakeProject project) {
        String prjDirDispName = FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory());
        DevelopmentHostConfiguration devHost = project.getDevelopmentHostConfiguration();
        if (devHost == null || devHost.isLocalhost()) {
            return NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)prjDirDispName);
        }
        return NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"HINT_project_root_node_on_host", (Object)prjDirDispName, (Object)devHost.getDisplayName(true));
    }

    private MakeProject getProject() {
        return this.project;
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        return makeConfigurationDescriptor;
    }

    private boolean gotMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        return pdp.gotDescriptor();
    }

    private static StandardNodeAction createRenameAction() {
        if (renameAction == null) {
            renameAction = new RenameNodeAction();
        }
        return renameAction;
    }

    private static StandardNodeAction createDeleteAction() {
        if (deleteAction == null) {
            deleteAction = new DeleteNodeAction();
        }
        return deleteAction;
    }

    private static void addSyncActions(List<Action> actions) {
        actions.add(RemoteSyncActions.createUploadAction());
        if (DOWNLOAD_ACTION) {
            actions.add(RemoteSyncActions.createDownloadAction());
        }
    }

    private static Action[] insertSyncActions(Action[] actions, Class insertAfter) {
        Action[] result = actions;
        if (DOWNLOAD_ACTION) {
            result = MakeLogicalViewProvider.insertAfter(result, new Action[]{RemoteSyncActions.createDownloadAction()}, insertAfter);
        }
        result = MakeLogicalViewProvider.insertAfter(result, new Action[]{RemoteSyncActions.createUploadAction()}, insertAfter);
        return result;
    }

    private static Action[] insertAfter(Action[] actions, Action[] actionsToInsert, Class insertAfter) {
        if (actionsToInsert == null || actionsToInsert.length == 0) {
            return actions;
        }
        int insertPos = -1;
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null || !actions[i].getClass().equals(insertAfter)) continue;
            insertPos = i + 1;
            break;
        }
        if (insertPos < 0) {
            return actions;
        }
        Action[] newActions = new Action[actions.length + actionsToInsert.length];
        System.arraycopy(actions, 0, newActions, 0, insertPos);
        int rest = actions.length - insertPos;
        int newIndex = insertPos;
        for (Action action : actionsToInsert) {
            newActions[newIndex++] = action;
        }
        if (rest > 0) {
            System.arraycopy(actions, insertPos, newActions, newIndex, rest);
        }
        return newActions;
    }

    private static Action[] insertAfter(Action[] actions, Action[] actionsToInsert) {
        if (actionsToInsert == null || actionsToInsert.length == 0) {
            return actions;
        }
        Action[] newActions = new Action[actions.length + actionsToInsert.length];
        System.arraycopy(actions, 0, newActions, 0, actions.length);
        System.arraycopy(actionsToInsert, 0, newActions, actions.length, actionsToInsert.length);
        return newActions;
    }

    private static final class DeleteNodeAction
    extends StandardNodeAction {
        public DeleteNodeAction() {
            super(SystemAction.get(DeleteAction.class));
        }
    }

    private static final class RenameNodeAction
    extends StandardNodeAction {
        public RenameNodeAction() {
            super(SystemAction.get(RenameAction.class));
        }
    }

    private static class StandardNodeAction
    extends NodeAction {
        private SystemAction systemAction;

        public StandardNodeAction(SystemAction systemAction) {
            this.systemAction = systemAction;
        }

        protected void performAction(Node[] activatedNodes) {
            Action a;
            if (activatedNodes.length > 0) {
                MakeConfigurationDescriptor mcd;
                ViewItemNode vin;
                Folder folder = (Folder)activatedNodes[0].getLookup().lookup(Folder.class);
                if (folder == null && (vin = (ViewItemNode)activatedNodes[0].getLookup().lookup(ViewItemNode.class)) != null) {
                    folder = vin.getFolder();
                }
                if (folder != null && (mcd = folder.getConfigurationDescriptor()) != null && !mcd.okToChange()) {
                    return;
                }
            }
            InstanceContent ic = new InstanceContent();
            for (int i = 0; i < activatedNodes.length; ++i) {
                ic.add((Object)activatedNodes[i]);
            }
            AbstractLookup actionContext = new AbstractLookup((AbstractLookup.Content)ic);
            if (this.systemAction instanceof NodeAction) {
                a = ((NodeAction)this.systemAction).createContextAwareInstance((Lookup)actionContext);
            } else if (this.systemAction instanceof CallbackSystemAction) {
                a = ((CallbackSystemAction)this.systemAction).createContextAwareInstance((Lookup)actionContext);
            } else {
                a = null;
                assert (false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    a.actionPerformed(new ActionEvent((Object)StandardNodeAction.this, 0, null));
                }
            });
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return this.systemAction.getHelpCtx();
        }

        public String getName() {
            return this.systemAction.getName();
        }
    }

    private static final class FolderSearchInfo
    implements SearchInfo {
        private Folder folder;

        FolderSearchInfo(Folder folder) {
            this.folder = folder;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<DataObject> objectsToSearch() {
            return this.folder.getAllItemsAsDataObjectSet(false, "text/").iterator();
        }
    }

    private static final class RefreshItemAction
    extends AbstractAction {
        private RefreshableItemsContainer childrenKeys;
        private Folder folder;
        private Item item;

        public RefreshItemAction(RefreshableItemsContainer childrenKeys, Folder folder, Item item) {
            this.childrenKeys = childrenKeys;
            this.folder = folder;
            this.item = item;
            this.putValue("Name", NbBundle.getBundle(this.getClass()).getString("CTL_Refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.item != null) {
                this.childrenKeys.refreshItem(this.item);
            } else {
                Item[] items = this.folder.getItemsAsArray();
                for (int i = 0; i < items.length; ++i) {
                    this.childrenKeys.refreshItem(items[i]);
                }
            }
        }
    }

    private static interface RefreshableItemsContainer {
        public void refreshItem(Item var1);
    }

    private static final class BrokenViewItemNode
    extends AbstractNode {
        private boolean broken;
        private final RefreshableItemsContainer childrenKeys;
        private final Folder folder;
        private final Item item;
        private final MakeProject project;

        public BrokenViewItemNode(RefreshableItemsContainer childrenKeys, Folder folder, Item item, MakeProject project) {
            super(Children.LEAF);
            this.childrenKeys = childrenKeys;
            this.folder = folder;
            this.item = item;
            File file = item.getNormalizedFile();
            this.setName(file.getPath());
            this.setDisplayName(file.getName());
            this.setShortDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"BrokenTxt", (Object)file.getPath()));
            this.broken = true;
            this.project = project;
        }

        public Image getIcon(int type) {
            PredefinedToolKind tool = this.item.getDefaultTool();
            Image original = tool == PredefinedToolKind.CCompiler ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/source/resources/CSrcIcon.gif") : (tool == PredefinedToolKind.CCCompiler ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/source/resources/CCSrcIcon.gif") : (tool == PredefinedToolKind.FortranCompiler ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/source/resources/FortranSrcIcon.gif") : ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/loaders/unknown.gif")));
            return this.broken ? ImageUtilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)11, (int)0) : original;
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(RemoveItemAction.class), new RefreshItemAction(this.childrenKeys, null, this.item), null, SystemAction.get(PropertiesItemAction.class)};
        }

        public void refresh() {
            this.childrenKeys.refreshItem(this.item);
        }

        public boolean canRename() {
            return false;
        }

        public Object getValue(String valstring) {
            if (valstring == null) {
                return super.getValue(null);
            }
            if (valstring.equals("Folder")) {
                return this.folder;
            }
            if (valstring.equals("Project")) {
                return this.project;
            }
            if (valstring.equals("Item")) {
                return this.item;
            }
            if (valstring.equals("This")) {
                return this;
            }
            return super.getValue(valstring);
        }
    }

    private static final class ViewItemTransferable
    extends ExTransferable.Single {
        private ViewItemNode node;

        public ViewItemTransferable(ViewItemNode node, int operation) throws ClassNotFoundException {
            super(new DataFlavor(ITEM_VIEW_FLAVOR.format(new Object[]{operation}), null, MakeLogicalViewProvider.class.getClassLoader()));
            this.node = node;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }

    private static final class ViewItemNode
    extends FilterNode
    implements ChangeListener {
        private RefreshableItemsContainer childrenKeys;
        private Folder folder;
        private Item item;
        private final MakeProject project;

        public ViewItemNode(RefreshableItemsContainer childrenKeys, Folder folder, Item item, DataObject dataObject, MakeProject project) {
            super(dataObject.getNodeDelegate());
            this.childrenKeys = childrenKeys;
            this.folder = folder;
            this.item = item;
            File file = item.getNormalizedFile();
            this.setShortDescription(file.getPath());
            this.project = project;
        }

        public void setName(String s) {
            super.setName(s.trim());
        }

        public Folder getFolder() {
            return this.folder;
        }

        public Item getItem() {
            return this.item;
        }

        public boolean canRename() {
            return true;
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canCut() {
            return true;
        }

        public boolean canCopy() {
            return true;
        }

        public Transferable clipboardCopy() throws IOException {
            return this.addViewItemTransferable(super.clipboardCopy(), 1);
        }

        public Transferable clipboardCut() throws IOException {
            return this.addViewItemTransferable(super.clipboardCut(), 2);
        }

        public Transferable drag() throws IOException {
            return this.addViewItemTransferable(super.drag(), 0);
        }

        private ExTransferable addViewItemTransferable(Transferable t, int operation) {
            try {
                ExTransferable extT = ExTransferable.create((Transferable)t);
                ViewItemTransferable viewItem = new ViewItemTransferable(this, operation);
                extT.put((ExTransferable.Single)viewItem);
                return extT;
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void destroy() throws IOException {
            super.destroy();
            this.folder.removeItemAction(this.item);
        }

        public Object getValue(String valstring) {
            if (valstring == null) {
                return super.getValue(null);
            }
            if (valstring.equals("Folder")) {
                return this.getFolder();
            }
            if (valstring.equals("Project")) {
                return this.project;
            }
            if (valstring.equals("Item")) {
                return this.getItem();
            }
            if (valstring.equals("This")) {
                return this;
            }
            return super.getValue(valstring);
        }

        public Action[] getActions(boolean context) {
            Action[] oldActions = super.getActions(false);
            ArrayList<Object> newActions = new ArrayList<Object>();
            if (this.getItem().getFolder() == null) {
                return oldActions;
            }
            if (this.getItem().getFolder().isDiskFolder()) {
                for (int i = 0; i < oldActions.length; ++i) {
                    String key = null;
                    if (oldActions[i] != null) {
                        key = (String)oldActions[i].getValue("key");
                    }
                    if (oldActions[i] != null && oldActions[i] instanceof OpenAction) {
                        newActions.add(oldActions[i]);
                        newActions.add(null);
                        continue;
                    }
                    if (oldActions[i] != null && oldActions[i] instanceof RenameAction) {
                        newActions.add((Object)MakeLogicalViewProvider.createRenameAction());
                        MakeLogicalViewProvider.addSyncActions(newActions);
                        continue;
                    }
                    if (key != null && key.equals("delete")) {
                        newActions.add((Object)MakeLogicalViewProvider.createDeleteAction());
                        continue;
                    }
                    if (oldActions[i] != null && oldActions[i] instanceof PropertiesAction && this.getFolder().isProjectFiles()) {
                        newActions.add(SystemAction.get(PropertiesItemAction.class));
                        continue;
                    }
                    newActions.add(oldActions[i]);
                }
                return newActions.toArray(new Action[newActions.size()]);
            }
            for (int i = 0; i < oldActions.length; ++i) {
                String key = null;
                if (oldActions[i] != null) {
                    key = (String)oldActions[i].getValue("key");
                }
                if (oldActions[i] != null && oldActions[i] instanceof OpenAction) {
                    newActions.add(oldActions[i]);
                    newActions.add(null);
                    continue;
                }
                if (oldActions[i] != null && oldActions[i] instanceof PasteAction) {
                    newActions.add(oldActions[i]);
                    newActions.add(SystemAction.get(CompileSingleAction.class));
                    if (this.getItem().getFolder().isTest()) continue;
                    newActions.add(NewTestActionFactory.createNewTestsSubmenu());
                    continue;
                }
                if (oldActions[i] != null && oldActions[i] instanceof RenameAction) {
                    newActions.add((Object)MakeLogicalViewProvider.createRenameAction());
                    MakeLogicalViewProvider.addSyncActions(newActions);
                    continue;
                }
                if (oldActions[i] != null && oldActions[i] instanceof PropertiesAction && this.getFolder().isProjectFiles()) {
                    newActions.add(SystemAction.get(PropertiesItemAction.class));
                    continue;
                }
                if (key != null && key.equals("delete")) {
                    newActions.add(SystemAction.get(RemoveItemAction.class));
                    newActions.add((Object)MakeLogicalViewProvider.createDeleteAction());
                    continue;
                }
                newActions.add(oldActions[i]);
            }
            return newActions.toArray(new Action[newActions.size()]);
        }

        public Image getIcon(int type) {
            Image image = super.getIcon(type);
            if (this.isExcluded() && image instanceof BufferedImage) {
                ColorSpace gray_space = ColorSpace.getInstance(1003);
                ColorConvertOp convert_to_gray_op = new ColorConvertOp(gray_space, null);
                image = convert_to_gray_op.filter((BufferedImage)image, null);
            }
            return image;
        }

        public String getHtmlDisplayName() {
            if (this.isExcluded()) {
                String baseName = super.getHtmlDisplayName();
                if (baseName != null && baseName.toLowerCase().contains("color=")) {
                    return baseName;
                }
                baseName = baseName != null ? baseName : this.getDisplayName();
                return "<font color='!controlShadow'>" + baseName;
            }
            return super.getHtmlDisplayName();
        }

        private boolean isExcluded() {
            if (this.item == null || this.item.getFolder() == null || this.item.getFolder().getConfigurationDescriptor() == null || this.item.getFolder().getConfigurationDescriptor().getConfs() == null) {
                return false;
            }
            MakeConfiguration makeConfiguration = this.item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
            ItemConfiguration itemConfiguration = this.item.getItemConfiguration(makeConfiguration);
            if (itemConfiguration == null) {
                return false;
            }
            BooleanConfiguration excl = itemConfiguration.getExcluded();
            return excl.getValue();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            EventQueue.invokeLater(new VisualUpdater());
        }

        private class VisualUpdater
        implements Runnable {
            private VisualUpdater() {
            }

            @Override
            public void run() {
                ViewItemNode.this.fireIconChange();
                ViewItemNode.this.fireOpenedIconChange();
                String displayName = ViewItemNode.this.getDisplayName();
                ViewItemNode.this.fireDisplayNameChange(displayName, "");
                ViewItemNode.this.fireDisplayNameChange("", displayName);
            }
        }
    }

    private static final class ExternalFilesChildren
    extends BaseMakeViewChildren {
        public ExternalFilesChildren(Folder folder, MakeLogicalViewProvider provider) {
            super(folder, provider);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof LoadingNode) {
                return new Node[]{(Node)key};
            }
            if (!(key instanceof Item)) {
                System.err.println("wrong item in external files folder " + key);
                return null;
            }
            Item item = (Item)key;
            DataObject fileDO = item.getDataObject();
            Object node = fileDO != null ? new ViewItemNode(this, this.getFolder(), item, fileDO, this.provider.getProject()) : new BrokenViewItemNode(this, this.getFolder(), item, this.provider.getProject());
            return new Node[]{node};
        }

        @Override
        protected Collection<Object> getKeys() {
            return this.getFolder().getElements();
        }
    }

    private static abstract class BaseMakeViewChildren
    extends Children.Keys<Object>
    implements ChangeListener,
    RefreshableItemsContainer {
        private final Folder folder;
        protected final MakeLogicalViewProvider provider;

        public BaseMakeViewChildren(Folder folder, MakeLogicalViewProvider provider) {
            this.folder = folder;
            this.provider = provider;
        }

        protected final MakeProject getProject() {
            return this.provider.project;
        }

        protected void addNotify() {
            if (this.provider.isFindPathMode()) {
                super.addNotify();
                this.folder.addChangeListener(this);
                this.setKeys(this.getKeys());
            } else if (SwingUtilities.isEventDispatchThread()) {
                super.addNotify();
                this.setKeys(new Object[]{MakeLogicalViewProvider.getWaitNode()});
                this.folder.addChangeListener(this);
                LOAD_NODES_RP.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BaseMakeViewChildren.this.getProject().getProjectDirectory() != null && BaseMakeViewChildren.this.getProject().getProjectDirectory().isValid()) {
                            BaseMakeViewChildren.this.setKeys(BaseMakeViewChildren.this.getKeys());
                        }
                    }
                }, 50);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BaseMakeViewChildren.this.addNotify();
                    }
                });
            }
        }

        @Override
        public void refreshItem(Item item) {
            this.refreshKey(item);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.folder.removeChangeListener(this);
            super.removeNotify();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Runnable todo = null;
            if (e.getSource() instanceof Item) {
                Item[] items;
                for (final Item item : items = this.getFolder().getItemsAsArray()) {
                    if (e.getSource() != item) continue;
                    todo = new Runnable(){

                        @Override
                        public void run() {
                            BaseMakeViewChildren.this.refreshItem(item);
                        }
                    };
                    break;
                }
            } else {
                final Collection<Object> keys = this.getKeys();
                todo = new Runnable(){

                    @Override
                    public void run() {
                        BaseMakeViewChildren.this.setKeys(keys);
                    }
                };
            }
            if (todo != null) {
                EventQueue.invokeLater(todo);
            }
        }

        protected abstract Collection<Object> getKeys();

        public Folder getFolder() {
            return this.folder;
        }
    }

    private static final class ExternalFilesNode
    extends AbstractNode {
        private final Folder folder;
        private final MakeLogicalViewProvider provider;

        public ExternalFilesNode(Folder folder, MakeLogicalViewProvider provider) {
            super((Children)new ExternalFilesChildren(folder, provider), Lookups.fixed((Object[])new Object[]{provider.getProject(), new FolderSearchInfo(folder)}));
            this.setName(folder.getName());
            this.setDisplayName(folder.getDisplayName());
            this.setShortDescription(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("ONLY_REFERENCE_TXT"));
            this.folder = folder;
            this.provider = provider;
        }

        public Object getValue(String valstring) {
            if (valstring == null) {
                return super.getValue(null);
            }
            if (valstring.equals("Folder")) {
                return this.folder;
            }
            if (valstring.equals("Project")) {
                return this.provider.getProject();
            }
            if (valstring.equals("This")) {
                return this;
            }
            return super.getValue(valstring);
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/importantFolder.gif");
        }

        public Image getOpenedIcon(int type) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/importantFolderOpened.gif");
        }

        public Action[] getActions(boolean context) {
            Action[] result = new Action[]{new AddExternalItemAction(this.provider.getProject()), null, SystemAction.get(FindAction.class)};
            MakeProjectType projectKind = (MakeProjectType)this.provider.getProject().getLookup().lookup(MakeProjectType.class);
            List actionsForMakeProject = Utilities.actionsForPath((String)projectKind.extFolderActionsPath());
            result = MakeLogicalViewProvider.insertAfter(result, actionsForMakeProject.toArray(new Action[actionsForMakeProject.size()]), AddExternalItemAction.class);
            result = MakeLogicalViewProvider.insertSyncActions(result, AddExternalItemAction.class);
            return result;
        }

        public boolean canRename() {
            return false;
        }
    }

    private static final class ViewItemPasteType
    extends PasteType {
        private final Folder toFolder;
        private final ViewItemNode viewItemNode;
        private final int type;
        private final MakeLogicalViewProvider provider;

        public ViewItemPasteType(Folder toFolder, ViewItemNode viewItemNode, int type, MakeLogicalViewProvider provider) {
            this.toFolder = toFolder;
            this.viewItemNode = viewItemNode;
            this.type = type;
            this.provider = provider;
        }

        private void copyItemConfigurations(ItemConfiguration[] newConfigurations, ItemConfiguration[] oldConfigurations) {
            if (newConfigurations == null || oldConfigurations == null) {
                return;
            }
            assert (newConfigurations.length == oldConfigurations.length);
            for (int i = 0; i < newConfigurations.length; ++i) {
                newConfigurations[i].assignValues(oldConfigurations[i]);
            }
        }

        public Transferable paste() throws IOException {
            if (!this.provider.gotMakeConfigurationDescriptor() || !this.provider.getMakeConfigurationDescriptor().okToChange()) {
                return null;
            }
            Item item = this.viewItemNode.getItem();
            ItemConfiguration[] oldConfigurations = item.getItemConfigurations();
            if (this.type == 2) {
                if (this.toFolder.getProject() == this.viewItemNode.getFolder().getProject()) {
                    if (this.toFolder.isDiskFolder()) {
                        FileObject itemFO = item.getFileObject();
                        String toFolderPath = CndPathUtilitities.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                        FileObject toFolderFO = FileUtil.toFileObject((File)new File(toFolderPath));
                        String newName = CndPathUtilitities.createUniqueFileName((String)toFolderPath, (String)itemFO.getName(), (String)itemFO.getExt());
                        FileObject movedFileFO = FileUtil.moveFile((FileObject)itemFO, (FileObject)toFolderFO, (String)newName);
                        File movedFileFile = FileUtil.toFile((FileObject)movedFileFO);
                        String itemPath = movedFileFile.getPath();
                        itemPath = CndPathUtilitities.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
                        Item movedItem = this.toFolder.findItemByPath(itemPath = CndPathUtilitities.normalize((String)itemPath));
                        if (movedItem != null) {
                            this.copyItemConfigurations(movedItem.getItemConfigurations(), oldConfigurations);
                        }
                    } else if (this.viewItemNode.getFolder().removeItem(item)) {
                        this.toFolder.addItem(item);
                        this.copyItemConfigurations(item.getItemConfigurations(), oldConfigurations);
                    }
                } else if (this.toFolder.isDiskFolder()) {
                    FileObject itemFO = item.getFileObject();
                    String toFolderPath = CndPathUtilitities.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                    FileObject toFolderFO = FileUtil.toFileObject((File)new File(toFolderPath));
                    String newName = CndPathUtilitities.createUniqueFileName((String)toFolderPath, (String)itemFO.getName(), (String)itemFO.getExt());
                    FileObject movedFileFO = FileUtil.moveFile((FileObject)itemFO, (FileObject)toFolderFO, (String)newName);
                } else if (CndPathUtilitities.isPathAbsolute((String)item.getPath())) {
                    if (this.viewItemNode.getFolder().removeItem(item)) {
                        this.toFolder.addItem(item);
                    }
                } else if (item.getPath().startsWith("..")) {
                    String originalFilePath = FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath();
                    String newFilePath = FileUtil.toFile((FileObject)this.toFolder.getProject().getProjectDirectory()).getPath();
                    String fromNewToOriginal = CndPathUtilitities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
                    fromNewToOriginal = CndPathUtilitities.normalize((String)fromNewToOriginal);
                    String newPath = fromNewToOriginal + item.getPath();
                    newPath = CndPathUtilitities.trimDotDot((String)newPath);
                    if (this.viewItemNode.getFolder().removeItemAction(item)) {
                        this.toFolder.addItemAction(new Item(CndPathUtilitities.normalize((String)newPath)));
                    }
                } else {
                    Project toProject = this.toFolder.getProject();
                    FileObject fo = item.getFileObject();
                    FileObject copy = fo.copy(toProject.getProjectDirectory(), fo.getName(), fo.getExt());
                    String newPath = CndPathUtilitities.toRelativePath((String)FileUtil.toFile((FileObject)toProject.getProjectDirectory()).getPath(), (String)FileUtil.toFile((FileObject)copy).getPath());
                    if (this.viewItemNode.getFolder().removeItemAction(item)) {
                        fo.delete();
                        this.toFolder.addItemAction(new Item(CndPathUtilitities.normalize((String)newPath)));
                    }
                }
            } else if (this.type == 1 || this.type == 0) {
                if (this.toFolder.getProject() == this.viewItemNode.getFolder().getProject()) {
                    if ((CndPathUtilitities.isPathAbsolute((String)item.getPath()) || item.getPath().startsWith("..")) && !this.toFolder.isDiskFolder()) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        FileObject fo = FileUtil.toFileObject((File)item.getNormalizedFile());
                        String ext = fo.getExt();
                        if (this.toFolder.isDiskFolder()) {
                            String toFolderPath = CndPathUtilitities.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                            FileObject toFolderFO = FileUtil.toFileObject((File)new File(toFolderPath));
                            String newName = CndPathUtilitities.createUniqueFileName((String)toFolderPath, (String)fo.getName(), (String)ext);
                            FileObject copiedFileObject = fo.copy(toFolderFO, newName, ext);
                            File copiedFileFile = FileUtil.toFile((FileObject)copiedFileObject);
                            String itemPath = copiedFileFile.getPath();
                            itemPath = CndPathUtilitities.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
                            Item copiedItemItem = this.toFolder.findItemByPath(itemPath = CndPathUtilitities.normalize((String)itemPath));
                            if (copiedItemItem != null) {
                                this.copyItemConfigurations(copiedItemItem.getItemConfigurations(), oldConfigurations);
                            }
                        } else {
                            String parent = FileUtil.toFile((FileObject)fo.getParent()).getPath();
                            String newName = CndPathUtilitities.createUniqueFileName((String)parent, (String)fo.getName(), (String)ext);
                            fo.copy(fo.getParent(), newName, ext);
                            String newPath = parent + "/" + newName;
                            if (ext.length() > 0) {
                                newPath = newPath + "." + ext;
                            }
                            newPath = CndPathUtilitities.toRelativePath((String)FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath(), (String)newPath);
                            Item newItem = new Item(CndPathUtilitities.normalize((String)newPath));
                            this.toFolder.addItemAction(newItem);
                            this.copyItemConfigurations(newItem.getItemConfigurations(), oldConfigurations);
                        }
                    }
                } else if (this.toFolder.isDiskFolder()) {
                    FileObject fo = FileUtil.toFileObject((File)item.getNormalizedFile());
                    String ext = fo.getExt();
                    String toFolderPath = CndPathUtilitities.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                    FileObject toFolderFO = FileUtil.toFileObject((File)new File(toFolderPath));
                    String newName = CndPathUtilitities.createUniqueFileName((String)toFolderPath, (String)fo.getName(), (String)ext);
                    fo.copy(toFolderFO, newName, ext);
                } else if (CndPathUtilitities.isPathAbsolute((String)item.getPath())) {
                    this.toFolder.addItem(new Item(item.getPath()));
                } else if (item.getPath().startsWith("..")) {
                    String originalFilePath = FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath();
                    String newFilePath = FileUtil.toFile((FileObject)this.toFolder.getProject().getProjectDirectory()).getPath();
                    String fromNewToOriginal = CndPathUtilitities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
                    fromNewToOriginal = CndPathUtilitities.normalize((String)fromNewToOriginal);
                    String newPath = fromNewToOriginal + item.getPath();
                    newPath = CndPathUtilitities.trimDotDot((String)newPath);
                    this.toFolder.addItemAction(new Item(CndPathUtilitities.normalize((String)newPath)));
                } else {
                    Project toProject = this.toFolder.getProject();
                    String parent = FileUtil.toFile((FileObject)toProject.getProjectDirectory()).getPath();
                    FileObject fo = item.getFileObject();
                    String ext = fo.getExt();
                    String newName = CndPathUtilitities.createUniqueFileName((String)parent, (String)fo.getName(), (String)ext);
                    fo.copy(toProject.getProjectDirectory(), newName, ext);
                    String newPath = newName;
                    if (ext.length() > 0) {
                        newPath = newPath + "." + ext;
                    }
                    this.toFolder.addItemAction(new Item(CndPathUtilitities.normalize((String)newPath)));
                }
            }
            return null;
        }
    }

    private static final class LogicalFolderNode
    extends AnnotatedNode
    implements ChangeListener {
        private final Folder folder;
        private final MakeLogicalViewProvider provider;

        public LogicalFolderNode(Node folderNode, Folder folder, MakeLogicalViewProvider provider) {
            super((Children)new LogicalViewChildren(folder, provider), LogicalFolderNode.createLFNLookup(folderNode, folder, provider), ANNOTATION_RP);
            this.folder = folder;
            this.provider = provider;
            this.setForceAnnotation(true);
            this.updateAnnotationFiles();
        }

        private static Lookup createLFNLookup(Node folderNode, Folder folder, MakeLogicalViewProvider provider) {
            MakeConfigurationDescriptor conf;
            ArrayList<Object> elems = new ArrayList<Object>(3);
            elems.add(folder);
            elems.add(provider.getProject());
            elems.add(new FolderSearchInfo(folder));
            if (folder.isDiskFolder() && (conf = folder.getConfigurationDescriptor()) != null) {
                DataFolder dataFolder;
                String rootPath = folder.getRootPath();
                String absRootPath = CndPathUtilitities.toAbsolutePath((String)conf.getBaseDir(), (String)rootPath);
                File folderFile = CndFileUtils.normalizeFile((File)new File(absRootPath));
                FileObject fo = FileUtil.toFileObject((File)folderFile);
                if (fo != null && fo.isFolder() && (dataFolder = DataFolder.findFolder((FileObject)fo)) != null) {
                    elems.add(dataFolder);
                }
            }
            return Lookups.fixed((Object[])elems.toArray());
        }

        private void updateAnnotationFiles() {
            ANNOTATION_RP.post((Runnable)new FileAnnotationUpdater(this));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateAnnotationFiles();
            EventQueue.invokeLater(new VisualUpdater());
        }

        public Folder getFolder() {
            return this.folder;
        }

        public Object getValue(String valstring) {
            if (valstring == null) {
                return super.getValue(null);
            }
            if (valstring.equals("Folder")) {
                return this.folder;
            }
            if (valstring.equals("Project")) {
                return this.provider.getProject();
            }
            if (valstring.equals("This")) {
                return this;
            }
            return super.getValue(valstring);
        }

        public Image getIcon(int type) {
            if (this.folder.isTest()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testContainer.gif"), type);
            }
            if (this.folder.isTestRootFolder()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolder.gif"), type);
            }
            if (this.folder.isDiskFolder() && this.folder.isTestLogicalFolder()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolder.gif"), type);
            }
            if (this.folder.isDiskFolder()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/tree_folder.gif"), type);
            }
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolder.gif"), type);
        }

        public Image getOpenedIcon(int type) {
            if (this.folder.isTest()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testContainer.gif"), type);
            }
            if (this.folder.isTestRootFolder()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolderOpened.gif"), type);
            }
            if (this.folder.isDiskFolder() && this.folder.isTestLogicalFolder()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolder.gif"), type);
            }
            if (this.folder.isDiskFolder()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/tree_folder.gif"), type);
            }
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolderOpened.gif"), type);
        }

        public String getName() {
            return this.folder.getDisplayName();
        }

        public String getDisplayName() {
            return this.annotateName(this.folder.getDisplayName());
        }

        public void setName(String newName) {
            String oldName = this.folder.getDisplayName();
            if (this.folder.isDiskFolder()) {
                String rootPath = this.folder.getRootPath();
                String AbsRootPath = CndPathUtilitities.toAbsolutePath((String)this.folder.getConfigurationDescriptor().getBaseDir(), (String)rootPath);
                File file = new File(AbsRootPath);
                if (!file.isDirectory() || !file.exists()) {
                    return;
                }
                FileObject fo = FileUtil.toFileObject((File)file);
                try {
                    fo.rename(fo.lock(), newName, null);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            if (this.folder.getParent() != null && this.folder.getParent().findFolderByDisplayName(newName) != null) {
                String msg = NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"CANNOT_RENAME", (Object)oldName, (Object)newName);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                return;
            }
            this.folder.setDisplayName(newName);
            this.fireDisplayNameChange(oldName, newName);
        }

        public boolean canRename() {
            return true;
        }

        public boolean canDestroy() {
            return this.getFolder().isDiskFolder();
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public void destroy() throws IOException {
            if (!this.getFolder().isDiskFolder()) {
                return;
            }
            String absPath = CndPathUtilitities.toAbsolutePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)this.getFolder().getRootPath());
            File folderFile = new File(absPath);
            if (!folderFile.isDirectory() || !folderFile.exists()) {
                return;
            }
            FileObject folderFileObject = FileUtil.toFileObject((File)folderFile);
            folderFileObject.delete();
            super.destroy();
        }

        public PasteType getDropType(Transferable transferable, int action, int index) {
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                return super.getDropType(transferable, action, index);
            }
            return null;
        }

        protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
            if (this.folder.isTestLogicalFolder()) {
                return;
            }
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                try {
                    ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(flavors[i]);
                    int type = new Integer(flavors[i].getParameter(MakeLogicalViewProvider.MASK));
                    list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, type, this.provider));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            super.createPasteTypes(transferable, list);
        }

        public void newLogicalFolder() {
        }

        public Action[] getActions(boolean context) {
            Action[] result;
            ResourceBundle bundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
            if (this.folder.isTestRootFolder()) {
                result = new Action[]{null, ProjectSensitiveActions.projectCommandAction((String)"test", (String)bundle.getString("LBL_TestAction_Name"), null), null, NewTestActionFactory.emptyTestFolderAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(PropertiesFolderAction.class)};
                result = MakeLogicalViewProvider.insertAfter(NewTestActionFactory.getTestCreationActions(this.folder.getProject()), result);
            } else if (this.folder.isTestLogicalFolder() && !this.folder.isDiskFolder()) {
                result = new Action[]{null, NewTestActionFactory.emptyTestFolderAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(RemoveFolderAction.class), MakeLogicalViewProvider.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)};
                result = MakeLogicalViewProvider.insertAfter(NewTestActionFactory.getTestCreationActions(this.folder.getProject()), result);
            } else {
                result = this.folder.isTest() ? new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(AddExistingItemAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(RunTestAction.class), SystemAction.get(DebugTestAction.class), SystemAction.get(StepIntoTestAction.class), null, SystemAction.get(RemoveFolderAction.class), MakeLogicalViewProvider.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)} : (this.folder.isDiskFolder() ? new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(FindAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), MakeLogicalViewProvider.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)} : new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(AddExistingItemAction.class), SystemAction.get(AddExistingFolderItemsAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(RemoveFolderAction.class), MakeLogicalViewProvider.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)});
            }
            MakeProjectType projectKind = (MakeProjectType)this.provider.getProject().getLookup().lookup(MakeProjectType.class);
            List actionsForMakeProject = Utilities.actionsForPath((String)projectKind.folderActionsPath());
            result = MakeLogicalViewProvider.insertAfter(result, actionsForMakeProject.toArray(new Action[actionsForMakeProject.size()]), RenameNodeAction.class);
            result = MakeLogicalViewProvider.insertSyncActions(result, RenameNodeAction.class);
            return result;
        }

        private final class VisualUpdater
        implements Runnable {
            private VisualUpdater() {
            }

            @Override
            public void run() {
                LogicalFolderNode.this.fireIconChange();
                LogicalFolderNode.this.fireOpenedIconChange();
            }
        }

        private final class FileAnnotationUpdater
        implements Runnable {
            private LogicalFolderNode logicalFolderNode;

            FileAnnotationUpdater(LogicalFolderNode logicalFolderNode2) {
                this.logicalFolderNode = logicalFolderNode2;
            }

            @Override
            public void run() {
                LogicalFolderNode.this.setFiles(new HashSet<FileObject>());
                ArrayList<Folder> allFolders = new ArrayList<Folder>();
                allFolders.add(LogicalFolderNode.this.folder);
                allFolders.addAll(LogicalFolderNode.this.folder.getAllFolders(true));
                Iterator iter = allFolders.iterator();
                while (iter.hasNext()) {
                    ((Folder)iter.next()).addChangeListener(this.logicalFolderNode);
                }
            }
        }
    }

    private static final class LogicalViewChildren
    extends BaseMakeViewChildren
    implements PropertyChangeListener {
        public LogicalViewChildren(Folder folder, MakeLogicalViewProvider provider) {
            super(folder, provider);
            if (folder.isDiskFolder()) {
                MakeOptions.getInstance().addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("viewBinaryFiles")) {
                this.stateChanged(new ChangeEvent(this));
            }
        }

        protected Node[] createNodes(Object key) {
            Object node = null;
            if (key instanceof LoadingNode) {
                node = (Node)key;
            } else if (key instanceof Node) {
                node = (Node)key;
            } else if (key instanceof Folder) {
                Folder folder = (Folder)key;
                if (folder.isProjectFiles() || folder.isTestLogicalFolder() || folder.isTest()) {
                    FileObject srcFileObject = this.getProject().getProjectDirectory();
                    DataObject srcDataObject = null;
                    try {
                        if (srcFileObject.isValid()) {
                            srcDataObject = DataObject.find((FileObject)srcFileObject);
                        }
                    }
                    catch (DataObjectNotFoundException e) {
                        // empty catch block
                    }
                    if (srcDataObject != null) {
                        node = new LogicalFolderNode(((DataFolder)srcDataObject).getNodeDelegate(), folder, this.provider);
                    }
                } else {
                    node = new ExternalFilesNode(folder, this.provider);
                }
            } else if (key instanceof Item) {
                Item item = (Item)key;
                DataObject fileDO = item.getDataObject();
                node = fileDO != null ? new ViewItemNode(this, this.getFolder(), item, fileDO, this.provider.getProject()) : new BrokenViewItemNode(this, this.getFolder(), item, this.provider.getProject());
            } else if (key instanceof AbstractNode) {
                node = (AbstractNode)key;
            }
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        @Override
        protected Collection<Object> getKeys() {
            LogicalViewNodeProvider[] providers;
            List<Object> collection;
            if (this.getFolder().isDiskFolder()) {
                File[] children;
                ArrayList<Object> collection2 = new ArrayList<Object>(this.getFolder().getElements());
                String absPath = CndPathUtilitities.toAbsolutePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)this.getFolder().getRootPath());
                File folderFile = new File(absPath);
                if (folderFile.isDirectory() && folderFile.exists() && (children = folderFile.listFiles()) != null) {
                    for (File child : children) {
                        if (!child.isFile() || this.getFolder().findItemByName(child.getName()) != null || !VisibilityQuery.getDefault().isVisible(child) || !this.getFolder().isTestLogicalFolder() && !MakeOptions.getInstance().getViewBinaryFiles() && CndFileVisibilityQuery.getDefault().isIgnored(child)) continue;
                        Item item = new Item(child.getAbsolutePath());
                        Folder.insertItemElementInList(collection2, item);
                    }
                }
                collection = collection2;
            } else {
                collection = this.getFolder().getElements();
            }
            switch (this.getFolder().getConfigurationDescriptor().getState()) {
                case READING: {
                    if (!collection.isEmpty()) break;
                    collection = Collections.singletonList(new LoadingNode());
                    break;
                }
            }
            if ("root".equals(this.getFolder().getName()) && (providers = LogicalViewNodeProviders.getInstance().getProvidersAsArray()).length > 0) {
                for (int i = 0; i < providers.length; ++i) {
                    AbstractNode node = providers[i].getLogicalViewNode(this.provider.getProject());
                    if (node == null) continue;
                    collection.add(node);
                }
            }
            return collection;
        }
    }

    private static final class MakeLogicalViewRootNodeBroken
    extends AbstractNode {
        private final MakeProject project;

        public MakeLogicalViewRootNodeBroken(MakeProject project) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{project}));
            this.project = project;
            this.setIconBaseWithExtension("org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif");
            this.setName(ProjectUtils.getInformation((Project)project).getDisplayName());
        }

        public Image getIcon(int type) {
            Image original = super.getIcon(type);
            return ImageUtilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)8, (int)0);
        }

        public Image getOpenedIcon(int type) {
            Image original = super.getOpenedIcon(type);
            return ImageUtilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)8, (int)0);
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(CommonProjectActions.closeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        public boolean canRename() {
            return false;
        }

        public String getShortDescription() {
            return MakeLogicalViewProvider.getShortDescription(this.project);
        }
    }

    private static final class MakeLogicalViewRootNode
    extends AnnotatedNode
    implements ChangeListener,
    LookupListener,
    PropertyChangeListener {
        private boolean brokenLinks;
        private boolean brokenIncludes;
        private Folder folder;
        private final Lookup.Result<BrokenIncludes> brokenIncludesResult;
        private final MakeLogicalViewProvider provider;

        public MakeLogicalViewRootNode(Folder folder, MakeLogicalViewProvider provider) {
            super((Children)new LogicalViewChildren(folder, provider), Lookups.fixed((Object[])new Object[]{folder, provider.getProject(), new FolderSearchInfo(folder)}), ANNOTATION_RP);
            this.folder = folder;
            this.provider = provider;
            this.setIconBaseWithExtension("org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif");
            this.setName(ProjectUtils.getInformation((Project)provider.getProject()).getDisplayName());
            this.brokenIncludesResult = Lookup.getDefault().lookup(new Lookup.Template(BrokenIncludes.class));
            this.brokenIncludesResult.addLookupListener((LookupListener)this);
            this.resultChanged(null);
            this.brokenLinks = MakeLogicalViewProvider.hasBrokenLinks();
            this.brokenIncludes = this.hasBrokenIncludes(provider.getProject());
            this.setForceAnnotation(true);
            this.updateAnnotationFiles();
            ProjectUtils.getInformation((Project)provider.getProject()).addPropertyChangeListener((PropertyChangeListener)this);
        }

        public Folder getFolder() {
            return this.folder;
        }

        private MakeProject getProject() {
            return this.provider.getProject();
        }

        private boolean gotMakeConfigurationDescriptor() {
            return this.provider.gotMakeConfigurationDescriptor();
        }

        private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
            return this.provider.getMakeConfigurationDescriptor();
        }

        private void updateAnnotationFiles() {
            HashSet<FileObject> set = new HashSet<FileObject>();
            FileObject fo = this.getProject().getProjectDirectory();
            if (fo == null || !fo.isValid()) {
                Logger.getLogger("cnd.makeproject").log(Level.WARNING, "project.getProjectDirectory() == null - {0}", this.getProject());
            }
            set.add(this.getProject().getProjectDirectory());
            if (!this.gotMakeConfigurationDescriptor()) {
                return;
            }
            MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
            if (makeConfigurationDescriptor == null) {
                return;
            }
            Configurations confs = makeConfigurationDescriptor.getConfs();
            if (confs == null) {
                return;
            }
            for (Configuration conf : confs.toArray()) {
                MakefileConfiguration makefileConfiguration;
                String path;
                File file;
                MakeConfiguration makeConfiguration = (MakeConfiguration)conf;
                if (!makeConfiguration.isMakefileConfiguration() || !(file = new File(path = (makefileConfiguration = makeConfiguration.getMakefileConfiguration()).getAbsBuildCommandWorkingDir())).exists()) continue;
                try {
                    set.add(FileUtil.toFileObject((File)file.getCanonicalFile()));
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.setFiles(set);
            ArrayList<Folder> allFolders = new ArrayList<Folder>();
            allFolders.add(this.folder);
            allFolders.addAll(this.folder.getAllFolders(true));
            Iterator iter = allFolders.iterator();
            while (iter.hasNext()) {
                ((Folder)iter.next()).addChangeListener(this);
            }
        }

        public String getShortDescription() {
            return MakeLogicalViewProvider.getShortDescription(this.provider.getProject());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setName(ProjectUtils.getInformation((Project)this.provider.getProject()).getDisplayName());
            String prop = evt.getPropertyName();
            if ("displayName".equals(prop)) {
                this.fireDisplayNameChange(null, null);
            } else if ("name".equals(prop)) {
                this.fireNameChange(null, null);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.brokenLinks = MakeLogicalViewProvider.hasBrokenLinks();
            this.brokenIncludes = this.hasBrokenIncludes(this.getProject());
            this.updateAnnotationFiles();
            EventQueue.invokeLater(new VisualUpdater());
        }

        public Object getValue(String valstring) {
            if (valstring == null) {
                return super.getValue(null);
            }
            if (valstring.equals("Folder")) {
                return this.folder;
            }
            if (valstring.equals("Project")) {
                return this.getProject();
            }
            if (valstring.equals("This")) {
                return this;
            }
            return super.getValue(valstring);
        }

        public Image getIcon(int type) {
            return this.mergeBadge(this.annotateIcon(super.getIcon(type), type));
        }

        private Image mergeBadge(Image original) {
            if (this.brokenLinks) {
                return ImageUtilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)8, (int)0);
            }
            if (this.brokenIncludes) {
                return ImageUtilities.mergeImages((Image)original, (Image)brokenIncludeBadge, (int)8, (int)0);
            }
            return original;
        }

        public Image getOpenedIcon(int type) {
            return this.mergeBadge(this.annotateIcon(super.getOpenedIcon(type), type));
        }

        public Action[] getActions(boolean context) {
            MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
            if (descriptor != null) {
                descriptor.getLogicalFolders();
            }
            ArrayList<Action> actions = new ArrayList<Action>();
            MakeConfiguration active = descriptor == null ? null : descriptor.getActiveConfiguration();
            Action[] standardActions = descriptor == null || active == null || active.isMakefileConfiguration() ? this.getAdditionalDiskFolderActions() : this.getAdditionalLogicalFolderActions();
            actions.addAll(Arrays.asList(standardActions));
            actions.add(null);
            MakeProjectType projectKind = (MakeProjectType)this.provider.getProject().getLookup().lookup(MakeProjectType.class);
            List actionsForMakeProject = Utilities.actionsForPath((String)projectKind.projectActionsPath());
            if (!actionsForMakeProject.isEmpty()) {
                actions.addAll(actionsForMakeProject);
                actions.add(null);
            }
            actions.add((Action)SystemAction.get(FindAction.class));
            actions.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            actions.add(null);
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        public boolean canRename() {
            return false;
        }

        public PasteType getDropType(Transferable transferable, int action, int index) {
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                return super.getDropType(transferable, action, index);
            }
            return null;
        }

        protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                try {
                    ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(flavors[i]);
                    int type = new Integer(flavors[i].getParameter(MakeLogicalViewProvider.MASK));
                    list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, type, this.provider));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            super.createPasteTypes(transferable, list);
        }

        private Action[] getAdditionalLogicalFolderActions() {
            ResourceBundle bundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
            Action[] result = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(AddExistingItemAction.class), SystemAction.get(AddExistingFolderItemsAction.class), SystemAction.get(NewFolderAction.class), null, ProjectSensitiveActions.projectCommandAction((String)"build", (String)bundle.getString("LBL_BuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)bundle.getString("LBL_RebuildAction_Name"), null), new MoreBuildActionsAction(new Action[]{ProjectSensitiveActions.projectCommandAction((String)"clean", (String)bundle.getString("LBL_CleanAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"batch_build", (String)bundle.getString("LBL_BatchBuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"build_packages", (String)bundle.getString("LBL_BuildPackagesAction_Name"), null)}), new SetConfigurationAction(this.getProject()), new RemoteDevelopmentAction(this.getProject()), null, ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug", (String)bundle.getString("LBL_DebugAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug.stepinto", (String)bundle.getString("LBL_DebugAction_Step_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"test", (String)bundle.getString("LBL_TestAction_Name"), null), null, CommonProjectActions.setAsMainProjectAction(), CommonProjectActions.openSubprojectsAction(), CommonProjectActions.closeProjectAction(), null, CommonProjectActions.renameProjectAction(), CommonProjectActions.moveProjectAction(), CommonProjectActions.copyProjectAction(), CommonProjectActions.deleteProjectAction(), null};
            if (SYNC_PROJECT_ACTION) {
                result = MakeLogicalViewProvider.insertSyncActions(result, RemoteDevelopmentAction.class);
            }
            return result;
        }

        private Action[] getAdditionalDiskFolderActions() {
            ResourceBundle bundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
            Action[] result = new Action[]{CommonProjectActions.newFileAction(), null, ProjectSensitiveActions.projectCommandAction((String)"build", (String)bundle.getString("LBL_BuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)bundle.getString("LBL_RebuildAction_Name"), null), new MoreBuildActionsAction(new Action[]{ProjectSensitiveActions.projectCommandAction((String)"clean", (String)bundle.getString("LBL_CleanAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"batch_build", (String)bundle.getString("LBL_BatchBuildAction_Name"), null)}), new SetConfigurationAction(this.getProject()), new RemoteDevelopmentAction(this.getProject()), null, ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug", (String)bundle.getString("LBL_DebugAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug.stepinto", (String)bundle.getString("LBL_DebugAction_Step_Name"), null), null, CommonProjectActions.setAsMainProjectAction(), CommonProjectActions.openSubprojectsAction(), CommonProjectActions.closeProjectAction(), null, CommonProjectActions.renameProjectAction(), CommonProjectActions.moveProjectAction(), CommonProjectActions.copyProjectAction(), CommonProjectActions.deleteProjectAction(), null};
            if (SYNC_PROJECT_ACTION) {
                result = MakeLogicalViewProvider.insertSyncActions(result, RemoteDevelopmentAction.class);
            }
            return result;
        }

        public void resultChanged(LookupEvent ev) {
            for (BrokenIncludes elem : this.brokenIncludesResult.allInstances()) {
                elem.addChangeListener(this);
            }
        }

        private boolean hasBrokenIncludes(Project project) {
            NativeProject id;
            BrokenIncludes biProvider = (BrokenIncludes)Lookup.getDefault().lookup(BrokenIncludes.class);
            if (biProvider != null && (id = (NativeProject)project.getLookup().lookup(NativeProject.class)) != null) {
                return biProvider.isBroken(id);
            }
            return false;
        }

        private final class VisualUpdater
        implements Runnable {
            private VisualUpdater() {
            }

            @Override
            public void run() {
                MakeLogicalViewRootNode.this.fireIconChange();
                MakeLogicalViewRootNode.this.fireOpenedIconChange();
                MakeLogicalViewRootNode.this.fireDisplayNameChange(null, null);
            }
        }
    }

    private static final class LoadingNode
    extends AbstractNode {
        public LoadingNode() {
            super(Children.LEAF);
            this.setName("dummy");
            this.setDisplayName(NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"Tree_Loading"));
        }

        public Image getIcon(int param) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/waitNode.gif");
        }
    }
}

