/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class RescueBodyNode
extends Node {
    private final Node exceptionNodes;
    private final Node bodyNode;
    private final RescueBodyNode optRescueNode;

    public RescueBodyNode(ISourcePosition position, Node exceptionNodes, Node bodyNode, RescueBodyNode optRescueNode) {
        super(position, NodeType.RESCUEBODYNODE);
        assert (bodyNode != null) : "bodyNode is not null";
        this.exceptionNodes = exceptionNodes;
        this.bodyNode = bodyNode;
        this.optRescueNode = optRescueNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueBodyNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public RescueBodyNode getOptRescueNode() {
        return this.optRescueNode;
    }

    public Node getExceptionNodes() {
        return this.exceptionNodes;
    }

    @Override
    public List<Node> childNodes() {
        if (this.optRescueNode != null) {
            return Node.createList(this.exceptionNodes, this.bodyNode, this.optRescueNode);
        }
        return Node.createList(this.exceptionNodes, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.bodyNode.interpret(runtime, context, self, aBlock);
    }
}

