/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.BlockAcceptingNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.IArityNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ZSuperNode
extends Node
implements IArityNode,
BlockAcceptingNode {
    private Node iterNode;

    public ZSuperNode(ISourcePosition position) {
        super(position, NodeType.ZSUPERNODE);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitZSuperNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.optional();
    }

    @Override
    public List<Node> childNodes() {
        return this.iterNode != null ? ZSuperNode.createList(this.iterNode) : EMPTY_LIST;
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        Block block = ASTInterpreter.getBlock(runtime, context, self, aBlock, this.iterNode);
        return RuntimeHelpers.callZSuper(runtime, context, block, self);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        String name = context.getFrameName();
        RubyModule klazz = context.getFrameKlazz();
        if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
            return "super";
        }
        return null;
    }
}

