/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.debugger.jpda.projects.EditorContextImpl;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BreakpointsActionsProvider
implements NodeActionsProviderFilter {
    private static final Action GO_TO_SOURCE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_GoToSource_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            BreakpointsActionsProvider.goToSource((JPDABreakpoint)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    private static String loc(String string) {
        return NbBundle.getBundle(BreakpointsActionsProvider.class).getString(string);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (!(object instanceof JPDABreakpoint) || object instanceof ThreadBreakpoint) {
            return nodeActionsProvider.getActions(object);
        }
        Action[] actionArray = nodeActionsProvider.getActions(object);
        Action[] actionArray2 = new Action[actionArray.length + 2];
        actionArray2[0] = GO_TO_SOURCE_ACTION;
        actionArray2[1] = null;
        System.arraycopy(actionArray, 0, actionArray2, 2, actionArray.length);
        return actionArray2;
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof JPDABreakpoint && !(object instanceof ThreadBreakpoint)) {
            BreakpointsActionsProvider.goToSource((JPDABreakpoint)object);
        } else {
            nodeActionsProvider.performDefaultAction(object);
        }
    }

    private static void goToSource(JPDABreakpoint jPDABreakpoint) {
        Object object;
        int n;
        String string;
        LineBreakpoint lineBreakpoint;
        Future<Integer> future;
        block37: {
            future = null;
            if (jPDABreakpoint instanceof LineBreakpoint) {
                lineBreakpoint = (LineBreakpoint)jPDABreakpoint;
                string = lineBreakpoint.getURL();
                n = lineBreakpoint.getLineNumber();
                if (n < 1) {
                    n = 1;
                }
            } else if (jPDABreakpoint instanceof FieldBreakpoint) {
                lineBreakpoint = (FieldBreakpoint)jPDABreakpoint;
                object = lineBreakpoint.getFieldName();
                String string2 = lineBreakpoint.getClassName();
                FileObject fileObject = BreakpointsActionsProvider.getFileObject(BreakpointsActionsProvider.getRelativePath(string2));
                if (fileObject == null) {
                    return;
                }
                try {
                    string = fileObject.getURL().toString();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return;
                }
                Future<Integer> future2 = EditorContextImpl.getFieldLineNumber(fileObject, string2, (String)object);
                if (future2.isDone()) {
                    try {
                        n = future2.get();
                    }
                    catch (InterruptedException interruptedException) {
                        n = 1;
                    }
                    catch (ExecutionException executionException) {
                        Exceptions.printStackTrace((Throwable)executionException);
                        n = 1;
                    }
                } else {
                    future = future2;
                    n = -1;
                }
            } else if (jPDABreakpoint instanceof MethodBreakpoint) {
                lineBreakpoint = (MethodBreakpoint)jPDABreakpoint;
                object = lineBreakpoint.getMethodName();
                String[] stringArray = lineBreakpoint.getClassFilters();
                if (stringArray.length < 1) {
                    return;
                }
                String string3 = stringArray[0];
                FileObject fileObject = BreakpointsActionsProvider.getFileObject(BreakpointsActionsProvider.getRelativePath(string3));
                if (fileObject == null) {
                    return;
                }
                try {
                    string = fileObject.getURL().toString();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return;
                }
                Future<int[]> future3 = EditorContextImpl.getMethodLineNumbers(fileObject, string3, lineBreakpoint.getClassExclusionFilters(), (String)object, lineBreakpoint.getMethodSignature());
                if (future3.isDone()) {
                    try {
                        int[] nArray = future3.get();
                        if (nArray.length == 0) {
                            n = 1;
                            break block37;
                        }
                        n = nArray[0];
                    }
                    catch (InterruptedException interruptedException) {
                        n = 1;
                    }
                    catch (ExecutionException executionException) {
                        Exceptions.printStackTrace((Throwable)executionException);
                        n = 1;
                    }
                } else {
                    future = future3;
                    n = -1;
                }
            } else if (jPDABreakpoint instanceof ExceptionBreakpoint) {
                lineBreakpoint = (ExceptionBreakpoint)jPDABreakpoint;
                object = lineBreakpoint.getExceptionClassName();
                FileObject fileObject = BreakpointsActionsProvider.getFileObject(BreakpointsActionsProvider.getRelativePath((String)object));
                if (fileObject == null) {
                    return;
                }
                try {
                    string = fileObject.getURL().toString();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return;
                }
                n = 1;
            } else if (jPDABreakpoint instanceof ClassLoadUnloadBreakpoint) {
                lineBreakpoint = (ClassLoadUnloadBreakpoint)jPDABreakpoint;
                object = lineBreakpoint.getClassFilters();
                if (((String[])object).length == 0) {
                    return;
                }
                String string4 = object[0];
                FileObject fileObject = BreakpointsActionsProvider.getFileObject(BreakpointsActionsProvider.getRelativePath(string4));
                if (fileObject == null) {
                    return;
                }
                try {
                    string = fileObject.getURL().toString();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return;
                }
                n = 1;
            } else {
                return;
            }
        }
        if (future != null) {
            lineBreakpoint = future;
            object = string;
            RequestProcessor.getDefault().post(new Runnable((Future)lineBreakpoint, (String)object){
                final /* synthetic */ Future val$future;
                final /* synthetic */ String val$u;
                {
                    this.val$future = future;
                    this.val$u = string;
                }

                @Override
                public void run() {
                    try {
                        int[] nArray;
                        Object v = this.val$future.get();
                        final int n = v instanceof Integer ? (Integer)v : ((nArray = (int[])v).length == 0 ? 1 : nArray[0]);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                EditorContextImpl.showSourceLine(val$u, n, null);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        Exceptions.printStackTrace((Throwable)executionException);
                    }
                }
            });
            return;
        }
        EditorContextImpl.showSourceLine(string, n, null);
    }

    private static FileObject getFileObject(String string) {
        SourcePathProvider sourcePathProvider;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine != null && (sourcePathProvider = (SourcePathProvider)debuggerEngine.lookupFirst(null, SourcePathProvider.class)) != null) {
            String string2 = sourcePathProvider.getURL(string, false);
            if (string2 == null) {
                string2 = sourcePathProvider.getURL(string, true);
            }
            if (string2 != null) {
                try {
                    FileObject fileObject = URLMapper.findFileObject((URL)new URL(string2));
                    if (fileObject != null) {
                        return fileObject;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                }
            }
        }
        string = SourcePathProviderImpl.normalize(string);
        sourcePathProvider = GlobalPathRegistry.getDefault().findResource(string);
        return sourcePathProvider;
    }

    private static String getRelativePath(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            string = string.substring(0, n);
        }
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }
}

