/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.ui.FieldsBrowserControllerUI;
import org.openide.util.NbBundle;

public class FieldsBrowserController
extends AbstractController {
    private static final String NONE_STRING = NbBundle.getMessage(FieldsBrowserController.class, (String)"FieldsBrowserController_NoneString");
    private static final String NO_INSTANCE_SELECTED_STRING = NbBundle.getMessage(FieldsBrowserController.class, (String)"FieldsBrowserController_NoInstanceSelectedString");
    private static final String NO_CLASS_SELECTED_STRING = NbBundle.getMessage(FieldsBrowserController.class, (String)"FieldsBrowserController_NoClassSelectedString");
    public static final int ROOT_INSTANCE = 0;
    public static final int ROOT_CLASS = 1;
    public static final AbstractHeapWalkerNode EMPTY_INSTANCE_NODE = new AbstractHeapWalkerNode(null){

        @Override
        protected String computeName() {
            return NO_INSTANCE_SELECTED_STRING;
        }

        @Override
        protected String computeType() {
            return NONE_STRING;
        }

        @Override
        protected String computeValue() {
            return NONE_STRING;
        }

        @Override
        protected String computeSize() {
            return "";
        }

        @Override
        protected String computeRetainedSize() {
            return "";
        }

        @Override
        protected Icon computeIcon() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    };
    public static final AbstractHeapWalkerNode EMPTY_CLASS_NODE = new AbstractHeapWalkerNode(null){

        @Override
        protected String computeName() {
            return NO_CLASS_SELECTED_STRING;
        }

        @Override
        protected String computeType() {
            return NONE_STRING;
        }

        @Override
        protected String computeValue() {
            return NONE_STRING;
        }

        @Override
        protected String computeSize() {
            return "";
        }

        @Override
        protected String computeRetainedSize() {
            return "";
        }

        @Override
        protected Icon computeIcon() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    };
    private Handler instancesControllerHandler;
    private Instance instance;
    private JavaClass javaClass;
    private int rootMode;

    public FieldsBrowserController(Handler instancesControllerHandler, int rootMode) {
        this.instancesControllerHandler = instancesControllerHandler;
        this.rootMode = rootMode;
    }

    public Handler getInstancesControllerHandler() {
        return this.instancesControllerHandler;
    }

    public HeapWalkerNode getFilteredSortedFields(String filterValue, int sortingColumn, boolean sortingOrder) {
        if (this.rootMode == 0) {
            if (this.instance == null) {
                return EMPTY_INSTANCE_NODE;
            }
            return this.getSortedFields(this.getFilteredFields(this.getFields(this.instance), filterValue), sortingColumn, sortingOrder);
        }
        if (this.rootMode == 1) {
            if (this.javaClass == null) {
                return EMPTY_CLASS_NODE;
            }
            return this.getSortedFields(this.getFilteredFields(this.getFields(this.javaClass), filterValue), sortingColumn, sortingOrder);
        }
        return null;
    }

    public void setInstance(Instance instance) {
        this.rootMode = 0;
        this.instance = instance;
        this.javaClass = null;
        this.update();
    }

    public void setJavaClass(JavaClass javaClass) {
        this.rootMode = 1;
        this.instance = null;
        this.javaClass = javaClass;
        this.update();
    }

    public int getRootMode() {
        return this.rootMode;
    }

    public void createNavigationHistoryPoint() {
        this.instancesControllerHandler.getHeapFragmentWalker().createNavigationHistoryPoint();
    }

    public void navigateToClass(JavaClass javaClass) {
        this.instancesControllerHandler.showClass(javaClass);
    }

    public void navigateToInstance(Instance instance) {
        this.instancesControllerHandler.showInstance(instance);
    }

    public void showInstance(Instance instance) {
        if (this.instance != instance) {
            this.setInstance(instance);
        }
    }

    public void showJavaClass(JavaClass javaClass) {
        if (this.javaClass != javaClass) {
            this.setJavaClass(javaClass);
        }
    }

    public void update() {
        ((FieldsBrowserControllerUI)((Object)this.getPanel())).update();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((FieldsBrowserControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new FieldsBrowserControllerUI(this);
    }

    private HeapWalkerNode getFields(Instance instance) {
        return HeapWalkerNodeFactory.createRootInstanceNode(instance, "this", new Runnable(){

            @Override
            public void run() {
                ((FieldsBrowserControllerUI)((Object)FieldsBrowserController.this.getPanel())).refreshView();
            }
        }, 1, this.instancesControllerHandler.getHeapFragmentWalker().getHeapFragment());
    }

    private HeapWalkerNode getFields(JavaClass javaClass) {
        return HeapWalkerNodeFactory.createRootClassNode(javaClass, "class", new Runnable(){

            @Override
            public void run() {
                ((FieldsBrowserControllerUI)((Object)FieldsBrowserController.this.getPanel())).refreshView();
            }
        }, 1, this.instancesControllerHandler.getHeapFragmentWalker().getHeapFragment());
    }

    private HeapWalkerNode getFilteredFields(HeapWalkerNode fields, String filterValue) {
        return fields;
    }

    private HeapWalkerNode getSortedFields(HeapWalkerNode filteredFields, int sortingColumn, boolean sortingOrder) {
        return filteredFields;
    }

    public static interface Handler {
        public HeapFragmentWalker getHeapFragmentWalker();

        public void showClass(JavaClass var1);

        public void showInstance(Instance var1);
    }
}

