/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SummaryControllerUI
extends JPanel {
    private SummaryController summaryController;
    private Presenter presenter;
    private static final String VIEW_TITLE = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ViewTitle");
    private static final String VIEW_DESCR = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ViewDescr");

    public SummaryControllerUI(SummaryController summaryController) {
        this.summaryController = summaryController;
        this.initComponents();
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel hintsPanel = this.summaryController.getHintsController().getPanel();
        JExtendedSplitPane contentsSplit = new JExtendedSplitPane(1, (Component)this.summaryController.getOverViewController().getPanel(), (Component)hintsPanel);
        contentsSplit.setResizeWeight(0.75);
        this.tweakSplitPaneUI((JSplitPane)contentsSplit);
        this.add((Component)contentsSplit, "Center");
    }

    private void tweakSplitPaneUI(JSplitPane splitPane) {
        splitPane.setBorder(null);
        splitPane.setDividerSize(3);
        if (!(splitPane.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)splitPane.getUI()).getDivider();
        if (divider != null) {
            divider.setBorder(null);
        }
    }

    private static class Presenter
    extends JToggleButton {
        private static ImageIcon ICON_INFO = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/infoTab.png", (boolean)false);

        public Presenter() {
            this.setText(VIEW_TITLE);
            this.setToolTipText(VIEW_DESCR);
            this.setIcon(ICON_INFO);
            this.setMargin(new Insets(this.getMargin().top, this.getMargin().top, this.getMargin().bottom, this.getMargin().top));
        }
    }
}

