/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.ModifyQuery;

public abstract class ObjectLevelModifyQuery
extends ModifyQuery {
    protected Vector primaryKey;
    protected Object object;
    protected ObjectChangeSet objectChangeSet;
    protected Object backupClone;

    public ObjectLevelModifyQuery() {
        this.cascadePolicy = 2;
    }

    public void checkDescriptor(AbstractSession session) throws QueryException {
        if (this.getDescriptor() == null) {
            if (this.getObject() == null) {
                throw QueryException.objectToModifyNotSpecified(this);
            }
            ClassDescriptor referenceDescriptor = session.getDescriptor(this.getObject());
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getObject().getClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
    }

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException {
        if (unitOfWork.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWork.getLifecycle(), "executeQuery(ObjectLevelModifyQuery)");
        }
        return this.executeInUnitOfWorkObjectLevelModifyQuery(unitOfWork, translationRow);
    }

    protected Object executeInUnitOfWorkObjectLevelModifyQuery(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        if (!unitOfWork.getCommitManager().isActive()) {
            throw QueryException.invalidQuery(this);
        }
        if (this.getObject() != null && unitOfWork.isClassReadOnly(this.getObject().getClass())) {
            return this.getObject();
        }
        if (unitOfWork.shouldPerformNoValidation() && unitOfWork.getUnregisteredExistingObjects().containsKey(this.getObject())) {
            return null;
        }
        return super.executeInUnitOfWork(unitOfWork, translationRow);
    }

    public Object getBackupClone() {
        if (this.backupClone == null && this.getSession().isUnitOfWork()) {
            this.setBackupClone(((UnitOfWorkImpl)this.getSession()).getBackupCloneForCommit(this.getObject()));
        }
        return this.backupClone;
    }

    public Object getObject() {
        return this.object;
    }

    public ObjectChangeSet getObjectChangeSet() {
        return this.objectChangeSet;
    }

    public Vector getPrimaryKey() {
        return this.primaryKey;
    }

    public Class getReferenceClass() {
        return this.getObject().getClass();
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public boolean isObjectLevelModifyQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        this.checkDescriptor(this.getSession());
        if (this.getObject() != null) {
            this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.getDescriptor(), this);
        }
        super.prepare();
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(this);
        }
        this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        if (this.getPrimaryKey() == null) {
            if (this.getObjectChangeSet() != null) {
                this.setPrimaryKey(this.getObjectChangeSet().getPrimaryKeys());
            } else {
                this.setPrimaryKey(this.getSession().keyFromObject(this.getObject()));
            }
        }
    }

    public void setBackupClone(Object backupClone) {
        this.backupClone = backupClone;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setObjectChangeSet(ObjectChangeSet changeSet) {
        this.objectChangeSet = changeSet;
    }

    public void setPrimaryKey(Vector primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + String.valueOf(this.getObject()) + ")";
    }
}

