/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.util.logging.Logger;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionLocal;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionRemote;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionScript;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionSelenium;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionTest;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class ConfigAction {
    protected static final Logger LOGGER = Logger.getLogger(ConfigAction.class.getName());
    protected final PhpProject project;

    protected ConfigAction(PhpProject project) {
        assert (project != null);
        this.project = project;
    }

    public static Type convert(PhpProjectProperties.RunAsType runAsType) {
        Type type = null;
        switch (runAsType) {
            case LOCAL: {
                type = Type.LOCAL;
                break;
            }
            case REMOTE: {
                type = Type.REMOTE;
                break;
            }
            case SCRIPT: {
                type = Type.SCRIPT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)runAsType));
            }
        }
        return type;
    }

    public static ConfigAction get(Type type, PhpProject project) {
        assert (type != null);
        ConfigAction action = null;
        switch (type) {
            case LOCAL: {
                action = new ConfigActionLocal(project);
                break;
            }
            case REMOTE: {
                action = new ConfigActionRemote(project);
                break;
            }
            case SCRIPT: {
                action = new ConfigActionScript(project);
                break;
            }
            case TEST: {
                action = new ConfigActionTest(project);
                break;
            }
            case SELENIUM: {
                action = new ConfigActionSelenium(project);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
            }
        }
        assert (action != null);
        return action;
    }

    public boolean isRunProjectEnabled() {
        return true;
    }

    public boolean isDebugProjectEnabled() {
        return XDebugStarterFactory.getInstance() != null;
    }

    public abstract boolean isValid(boolean var1);

    public abstract boolean isRunFileEnabled(Lookup var1);

    public abstract boolean isDebugFileEnabled(Lookup var1);

    public abstract void runProject();

    public abstract void debugProject();

    public abstract void runFile(Lookup var1);

    public abstract void debugFile(Lookup var1);

    protected void showCustomizer() {
        ((CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("Run");
    }

    protected boolean isIndexFileValid(FileObject baseDirectory) {
        assert (baseDirectory != null);
        String indexFile = ProjectPropertiesSupport.getIndexFile(this.project);
        return indexFile != null && indexFile.trim().length() != 0 && baseDirectory.getFileObject(indexFile) != null;
    }

    public static enum Type {
        LOCAL,
        REMOTE,
        SCRIPT,
        TEST,
        SELENIUM;

    }
}

