/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.ruby;

import java.io.UnsupportedEncodingException;
import org.jruby.Ruby;
import org.yecht.ErrorHandler;
import org.yecht.Parser;

public class RubyErrHandler
implements ErrorHandler {
    private Ruby runtime;

    public RubyErrHandler(Ruby runtime) {
        this.runtime = runtime;
    }

    public void handle(Parser p, String msg) {
        int endl = p.cursor;
        while (p.buffer.buffer[endl] != 0 && p.buffer.buffer[endl] != 10) {
            ++endl;
        }
        try {
            int len;
            int lp = p.lineptr;
            if (lp < 0) {
                lp = 0;
            }
            if ((len = endl - lp) < 0) {
                len = 0;
            }
            String line = new String(p.buffer.buffer, lp, len, "ISO-8859-1");
            String m1 = msg + " on line " + p.linect + ", col " + (p.cursor - lp) + ": `" + line + "'";
            throw this.runtime.newArgumentError(m1);
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
    }
}

