/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.file.TransmitTextFilePreprocessor;

public class DefaultTransmitTextFilePreprocessor
implements TransmitTextFilePreprocessor {
    private static final int CHUNK_SIZE = 32768;
    private File tempDir;

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public File getPreprocessedTextFile(File originalTextFile) throws IOException {
        File preprocessedTextFile = File.createTempFile("cvs", null, this.tempDir);
        byte[] newLine = System.getProperty("line.separator").getBytes();
        boolean doConversion = newLine.length != 1 || newLine[0] != 10;
        OutputStream out = null;
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(originalTextFile));
            out = new BufferedOutputStream(new FileOutputStream(preprocessedTextFile));
            byte[] fileChunk = new byte[32768];
            byte[] fileWriteChunk = new byte[32768];
            int readLength = in.read(fileChunk);
            while (readLength > 0) {
                if (doConversion) {
                    int writeLength = 0;
                    int i = 0;
                    while (i < readLength) {
                        int pos = DefaultTransmitTextFilePreprocessor.findIndexOf(fileChunk, newLine, i);
                        if (pos >= i && pos < readLength) {
                            System.arraycopy(fileChunk, i, fileWriteChunk, writeLength, pos - i);
                            writeLength += pos - i;
                            i = pos + newLine.length;
                            fileWriteChunk[writeLength++] = 10;
                            continue;
                        }
                        System.arraycopy(fileChunk, i, fileWriteChunk, writeLength, readLength - i);
                        writeLength += readLength - i;
                        i = readLength;
                    }
                    out.write(fileWriteChunk, 0, writeLength);
                } else {
                    out.write(fileChunk, 0, readLength);
                }
                readLength = in.read(fileChunk);
            }
            File file = preprocessedTextFile;
            return file;
        }
        catch (IOException ex) {
            if (preprocessedTextFile != null) {
                this.cleanup(preprocessedTextFile);
            }
            throw ex;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private static int findIndexOf(byte[] array, byte[] pattern, int start) {
        int subPosition = 0;
        for (int i = start; i < array.length; ++i) {
            if (array[i] == pattern[subPosition]) {
                if (++subPosition != pattern.length) continue;
                return i - subPosition + 1;
            }
            subPosition = 0;
        }
        return -1;
    }

    public void cleanup(File preprocessedTextFile) {
        if (preprocessedTextFile != null) {
            preprocessedTextFile.delete();
        }
    }
}

