/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.io.ReaderInputStream;

final class RakeTaskReader {
    private final Project project;

    RakeTaskReader(Project project) {
        this.project = project;
    }

    Set<RakeTask> getRakeTaskTree() {
        return this.getRakeTaskTree(true);
    }

    Set<RakeTask> getRakeTaskTree(boolean withDescriptionOnly) {
        try {
            Set<RakeTask> tasks;
            String rawOutput = this.rawRead();
            Set<RakeTask> set = tasks = rawOutput == null ? Collections.emptySet() : RakeTaskReader.parseTasks(new StringReader(rawOutput));
            if (withDescriptionOnly) {
                Iterator it = tasks.iterator();
                while (it.hasNext()) {
                    RakeTask task = (RakeTask)it.next();
                    if (task.isNameSpace() || task.getDescription() != null) continue;
                    it.remove();
                }
            }
            return tasks;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return Collections.emptySet();
        }
    }

    String rawRead() {
        final FileObject projectDir = this.project.getProjectDirectory();
        try {
            final StringBuilder sb = new StringBuilder(5000);
            projectDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject rakeTasksFile = projectDir.getFileObject("nbproject/private/rake-d.txt");
                    if (rakeTasksFile == null) {
                        return;
                    }
                    BufferedReader reader = null;
                    try {
                        String line;
                        InputStream is = rakeTasksFile.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(is));
                        while ((line = reader.readLine()) != null) {
                            sb.append(line);
                            sb.append('\n');
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
            });
            return sb.length() > 0 ? sb.toString() : null;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    private static Set<RakeTask> parseTasks(Reader is) throws IOException {
        Properties tasksProps = new Properties();
        tasksProps.load((InputStream)new ReaderInputStream(is));
        TreeSet<RakeTask> tasks = new TreeSet<RakeTask>();
        HashMap<String, RakeTask> map = new HashMap<String, RakeTask>(50);
        HashSet<String> processedTasks = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : tasksProps.entrySet()) {
            String task = (String)entry.getKey();
            String description = (String)entry.getValue();
            if ("".equals(description)) {
                description = null;
            }
            if (!processedTasks.add(task)) continue;
            RakeTask parent = null;
            String[] path = task.split(":");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < path.length - 1; ++i) {
                if (sb.length() > 0) {
                    sb.append(':');
                }
                sb.append(path[i]);
                String folderPath = sb.toString();
                RakeTask p = (RakeTask)map.get(folderPath);
                if (p == null) {
                    RakeTask r = RakeTask.newNameSpace(path[i]);
                    if (parent == null) {
                        tasks.add(r);
                    } else {
                        parent.addChild(r);
                    }
                    map.put(folderPath, r);
                    parent = r;
                    continue;
                }
                parent = p;
            }
            RakeTask t = new RakeTask(task, path[path.length - 1], description);
            if (parent != null) {
                parent.addChild(t);
                continue;
            }
            tasks.add(t);
        }
        return tasks;
    }
}

