/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.JspConfig;
import org.netbeans.modules.j2ee.dd.api.web.JspPropertyGroup;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.xml.multiview.Error;
import org.openide.util.NbBundle;

public class SectionValidator {
    static Error validateServlets(WebApp webApp) {
        Servlet[] servletArray = webApp.getServlet();
        Error error = null;
        block0: for (int i = 0; i < servletArray.length; ++i) {
            String[] stringArray;
            String string = servletArray[i].getServletName();
            if (string == null || string.length() == 0) {
                stringArray = new Error.ErrorLocation((Object)servletArray[i], "ServletName");
                error = new Error(2, "Servlet Name", (Error.ErrorLocation)stringArray);
                break;
            }
            string = servletArray[i].getServletClass();
            if (string == null) {
                string = servletArray[i].getJspFile();
            }
            if (string == null || string.length() == 0) {
                stringArray = new Error.ErrorLocation((Object)servletArray[i], "ServletClass");
                error = new Error(2, "Servlet Class", (Error.ErrorLocation)stringArray);
                break;
            }
            stringArray = DDUtils.getUrlPatterns(webApp, servletArray[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                Error.ErrorLocation errorLocation;
                String string2 = DDUtils.checkServletMappig(stringArray[j]);
                if (string2 != null) {
                    errorLocation = new Error.ErrorLocation((Object)servletArray[i], "ServletMapping");
                    error = new Error(0, string2, errorLocation);
                    continue block0;
                }
                if (!DDUtils.isServletMapping(webApp, servletArray[i], stringArray[j])) continue;
                errorLocation = new Error.ErrorLocation((Object)servletArray[i], "ServletMapping");
                error = new Error(3, stringArray[j], errorLocation);
                continue block0;
            }
        }
        return error;
    }

    static Error validateFilters(WebApp webApp) {
        Filter[] filterArray = webApp.getFilter();
        Error error = null;
        for (int i = 0; i < filterArray.length; ++i) {
            String string = filterArray[i].getFilterName();
            if (string == null || string.length() == 0) {
                Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)filterArray[i], "FilterName");
                error = new Error(2, "Filter Name", errorLocation);
                break;
            }
            string = filterArray[i].getFilterClass();
            if (string != null && string.length() != 0) continue;
            Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)filterArray[i], "FilterClass");
            error = new Error(2, "Filter Class", errorLocation);
            break;
        }
        return error;
    }

    static Error validatePages(WebApp webApp) {
        Error error = null;
        JspConfig jspConfig = null;
        JspPropertyGroup[] jspPropertyGroupArray = null;
        try {
            jspConfig = webApp.getSingleJspConfig();
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            return null;
        }
        if (jspConfig == null) {
            return null;
        }
        jspPropertyGroupArray = jspConfig.getJspPropertyGroup();
        if (jspPropertyGroupArray == null) {
            return null;
        }
        for (int i = 0; i < jspPropertyGroupArray.length; ++i) {
            if (jspPropertyGroupArray[i].sizeUrlPattern() != 0) continue;
            Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)jspPropertyGroupArray[i], "url_patterns");
            error = new Error(2, "URL Pattern", errorLocation);
            break;
        }
        return error;
    }

    static String validateNewServlet(WebApp webApp, String string, String string2, String string3, String string4) {
        if (string.length() == 0) {
            return NbBundle.getMessage(SectionValidator.class, (String)"TXT_EmptyServletName");
        }
        Object[] objectArray = webApp.getServlet();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!string.equals(objectArray[i].getServletName())) continue;
            n = 1;
            break;
        }
        if (n != 0) {
            return NbBundle.getMessage(SectionValidator.class, (String)"TXT_ServletNameExists", (Object)string);
        }
        if (string2.length() == 0 && string3.length() == 0) {
            return NbBundle.getMessage(SectionValidator.class, (String)"TXT_Servlet_BothMissing");
        }
        if (string2.length() > 0 && string3.length() > 0) {
            return NbBundle.getMessage(SectionValidator.class, (String)"TXT_Servlet_BothSpecified");
        }
        objectArray = DDUtils.getStringArray(string4);
        if (objectArray.length > 0) {
            for (n = 0; n < objectArray.length; ++n) {
                String string5 = DDUtils.checkServletMappig((String)objectArray[n]);
                if (string5 != null) {
                    return string5;
                }
                if (!DDUtils.isServletMapping(webApp, (String)objectArray[n])) continue;
                return NbBundle.getMessage(SectionValidator.class, (String)"TXT_UrlPatternExists", (Object)objectArray[n]);
            }
        }
        return null;
    }

    static String validateNewFilter(WebApp webApp, String string, String string2) {
        if (string.length() == 0) {
            return NbBundle.getMessage(SectionValidator.class, (String)"TXT_EmptyFilterName");
        }
        Filter[] filterArray = webApp.getFilter();
        boolean bl = false;
        for (int i = 0; i < filterArray.length; ++i) {
            if (!string.equals(filterArray[i].getFilterName())) continue;
            bl = true;
            break;
        }
        if (bl) {
            return NbBundle.getMessage(SectionValidator.class, (String)"TXT_FilterNameExists", (Object)string);
        }
        if (string2.length() == 0) {
            return NbBundle.getMessage(SectionValidator.class, (String)"TXT_EmptyFilterClass");
        }
        return null;
    }

    static String validateNewJspPropertyGroup(String string) {
        String[] stringArray = DDUtils.getStringArray(string);
        if (stringArray.length == 0) {
            return NbBundle.getMessage(SectionValidator.class, (String)"TXT_EmptyUrls");
        }
        return null;
    }
}

