/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;

public final class HtmlSourceTask
extends ParserResultTask<HtmlParserResult> {
    private static final String CSS_CLASS_MAP_PROPERTY_KEY = "cssClassTagAttrMap";
    private static final String HTML_FACELETS_LIB_NS = "http://java.sun.com/jsf/html";
    private static final String STYLE_CLASS_ATTR_NAME = "styleClass";

    public int getPriority() {
        return 50;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public void run(HtmlParserResult htmlParserResult, SchedulerEvent schedulerEvent) {
        String string;
        Source source = htmlParserResult.getSnapshot().getSource();
        if (!source.getMimeType().equals("text/xhtml")) {
            return;
        }
        JsfSupport jsfSupport = JsfSupport.findFor(source);
        if (jsfSupport == null) {
            return;
        }
        Document document = htmlParserResult.getSnapshot().getSource().getDocument(true);
        if (document == null) {
            return;
        }
        InputAttributes inputAttributes = (InputAttributes)document.getProperty(InputAttributes.class);
        if (inputAttributes == null) {
            inputAttributes = new InputAttributes();
            inputAttributes.setValue(HTMLTokenId.language(), (Object)"enable el", new Object(), false);
            document.putProperty(InputAttributes.class, inputAttributes);
        }
        if ((string = (String)htmlParserResult.getNamespaces().get(HTML_FACELETS_LIB_NS)) != null) {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            FaceletsLibraryDescriptor faceletsLibraryDescriptor = jsfSupport.getFaceletsLibraryDescriptor(HTML_FACELETS_LIB_NS);
            for (LibraryDescriptor.Tag tag : faceletsLibraryDescriptor.getTags().values()) {
                if ("dataTable".equals(tag.getName())) {
                    hashMap.put(string + ":" + tag.getName(), Arrays.asList(STYLE_CLASS_ATTR_NAME, "headerClass", "footerClass", "rowClasses", "columnClasses", "captionClass"));
                    continue;
                }
                if (tag.getAttribute(STYLE_CLASS_ATTR_NAME) == null) continue;
                hashMap.put(string + ":" + tag.getName(), Collections.singletonList(STYLE_CLASS_ATTR_NAME));
            }
            inputAttributes.setValue(HTMLTokenId.language(), (Object)CSS_CLASS_MAP_PROPERTY_KEY, hashMap, true);
        } else {
            inputAttributes.setValue(HTMLTokenId.language(), (Object)CSS_CLASS_MAP_PROPERTY_KEY, null, true);
        }
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            String string = snapshot.getMimeType();
            if (string.equals("text/html")) {
                return Collections.singletonList(new HtmlSourceTask());
            }
            return Collections.EMPTY_LIST;
        }
    }
}

