/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.componentssupport.ui.IconUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.CustomComponentHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.ComponentProducerWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DocumentAdapter;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NewComponentDescriptor;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.PaletteCategory;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ComponentProducerVisualPanel
extends JPanel {
    private static final String MSG_ERR_CLASS_NAME_EMPTY = "MSG_CP_EmptyClassName";
    private static final String MSG_ERR_CLASS_NAME_INVALID = "MSG_CP_InvalidClassName";
    private static final String MSG_ERR_CLASS_NAME_EXISTS = "MSG_CP_ExistingClassName";
    private static final String MSG_ERR_PALETTE_DISP_NAME_EMPTY = "MSG_CP_EmptyPaletteDispName";
    private static final String MSG_ERR_LIB_NAME_EMPTY = "MSG_CP_EmptyLibName";
    private static final String MSG_ERR_SMALL_NOT_EXIST = "MSG_CP_SmallIconNotExist";
    private static final String MSG_ERR_LARGE_NOT_EXIST = "MSG_CP_LargeIconNotExist";
    private static final String LBL_SELECT = "LBL_Select";
    private static final String TXT_NONE = "TXT_NONE";
    private static final String NONE = ComponentProducerVisualPanel.getMessage("TXT_NONE", new Object[0]);
    private static final int ICON_LARGE_W = 32;
    private static final int ICON_LARGE_H = 32;
    private static final int ICON_SMALL_W = 16;
    private static final int ICON_SMALL_H = 16;
    private JCheckBox myCPAddLibDependencyChk;
    private JTextField myCPClassName;
    private JLabel myCPClassNameLabel;
    private JTextField myCPLargeIconPath;
    private JButton myCPLargeIconPathButton;
    private JLabel myCPLargeIconPathLabel;
    private JTextField myCPLibName;
    private JLabel myCPLibNameLabel;
    private JComboBox myCPPaletteCategoryCombo;
    private JLabel myCPPaletteCategoryLabel;
    private JTextField myCPPaletteDispName;
    private JLabel myCPPaletteDispNameLabel;
    private JTextField myCPPaletteTooltip;
    private JLabel myCPPaletteTooltipLabel;
    private JTextField myCPSmallIconPath;
    private JButton myCPSmallIconPathButton;
    private JLabel myCPSmallIconPathLabel;
    private JRadioButton myCPValidAlwaysRadio;
    private JRadioButton myCPValidCustomRadio;
    private JRadioButton myCPValidPlatformRadio;
    private JPanel myCompProducerPanel;
    private JPanel myLibNamePanel;
    private ButtonGroup myValidButtonGroup;
    private JPanel myValidityPanel;
    private WizardDescriptor mySettings;
    private ComponentProducerWizardPanel myPanel;
    private boolean isSmallIconUpdated;
    private boolean isLargeIconUpdated;
    private boolean isCPClassNameUpdated;
    private boolean listenersAttached;
    DocumentListener myDocListener;
    DocumentListener myClassNameListener;
    DocumentListener mySmallIconPathListener;
    DocumentListener myLargeIconPathListener;
    ActionListener myAddLibDependencyListener;

    ComponentProducerVisualPanel(ComponentProducerWizardPanel componentProducerWizardPanel) {
        this.myPanel = componentProducerWizardPanel;
        this.initComponents();
        this.myCPPaletteCategoryCombo.setModel(PaletteCategory.getComboBoxModel());
        this.myCPValidAlwaysRadio.setSelected(true);
        this.myDocListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
        this.myClassNameListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ComponentProducerVisualPanel.this.isCPClassNameUpdated = true;
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
        this.mySmallIconPathListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ComponentProducerVisualPanel.this.isSmallIconUpdated = true;
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
        this.myLargeIconPathListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ComponentProducerVisualPanel.this.isLargeIconUpdated = true;
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
        this.myAddLibDependencyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
        this.checkValidity();
    }

    @Override
    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    void storeData(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("compProdClassName", (Object)this.getClassNameValue());
        wizardDescriptor.putProperty("compProdPaletteDispName", (Object)this.getPaletteDispNameValue());
        wizardDescriptor.putProperty("compProdPaletteTip", (Object)this.getPaletteTooltipValue());
        wizardDescriptor.putProperty("compProdPaletteCategory", (Object)this.getPaletteCategoryValue());
        wizardDescriptor.putProperty("compProdSmallIcon", (Object)this.getSmallIconValue());
        wizardDescriptor.putProperty("compProdLargeIcon", (Object)this.getLargeIconValue());
        wizardDescriptor.putProperty("compProdAddLib", (Object)this.getAddLibraryValue());
        wizardDescriptor.putProperty("compProdLibName", (Object)this.getLibraryNameValue());
        wizardDescriptor.putProperty("compProdValidAlways", (Object)this.getValidAlwaysValue());
        wizardDescriptor.putProperty("compProdValidPlatform", (Object)this.getValidPlatformValue());
        wizardDescriptor.putProperty("compProdValidCustom", (Object)this.getValidCustomValue());
    }

    void readData(WizardDescriptor wizardDescriptor) {
        this.mySettings = wizardDescriptor;
        this.readClassNameValue();
        this.myCPPaletteDispName.setText(this.getPaletteDispName());
        this.myCPPaletteTooltip.setText(this.getPaletteTooltip());
        this.myCPPaletteCategoryCombo.setSelectedItem((Object)this.getPaletteCategory());
        this.myCPSmallIconPath.setText(this.getSmallIcon());
        this.myCPLargeIconPath.setText(this.getLargeIcon());
        this.myCPAddLibDependencyChk.setSelected(this.getAddLib());
        this.myCPLibName.setText((String)this.mySettings.getProperty("compProdLibName"));
        if (this.getValidAlways() != null) {
            this.myCPValidAlwaysRadio.setSelected(this.getValidAlways());
        }
        if (this.getValidPlatform() != null) {
            this.myCPValidPlatformRadio.setSelected(this.getValidPlatform());
        }
        if (this.getValidCustom() != null) {
            this.myCPValidCustomRadio.setSelected(this.getValidCustom());
        }
        this.checkValidity();
    }

    private CustomComponentHelper getHelper() {
        return (CustomComponentHelper)this.mySettings.getProperty("custCompHelper");
    }

    private String getPaletteDispName() {
        String string = (String)this.mySettings.getProperty("compProdPaletteDispName");
        return string == null ? this.getPrefix() : string;
    }

    private String getPaletteTooltip() {
        String string = (String)this.mySettings.getProperty("compProdPaletteTip");
        return string == null ? this.getPrefix() : string;
    }

    private PaletteCategory getPaletteCategory() {
        Object object = this.mySettings.getProperty("compProdPaletteCategory");
        if (object == null || !(object instanceof PaletteCategory)) {
            return PaletteCategory.CATEGORY_DISPLAYABLES;
        }
        return (PaletteCategory)((Object)object);
    }

    private String getPrefix() {
        String string = (String)this.mySettings.getProperty("prefix");
        assert (string != null);
        return string;
    }

    private void readClassNameValue() {
        String string = (String)this.mySettings.getProperty("compProdClassName");
        if (string == null || !this.isCPClassNameUpdated) {
            string = NewComponentDescriptor.createDefaultProducerClass(this.getPrefix());
            this.myCPClassName.setText(string);
            this.isCPClassNameUpdated = false;
        } else {
            this.myCPClassName.setText(string);
        }
    }

    private Boolean getAddLib() {
        Object object = this.mySettings.getProperty("compProdAddLib");
        if (object == null) {
            return Boolean.FALSE;
        }
        return (Boolean)object;
    }

    private String getSmallIcon() {
        String string = (String)this.mySettings.getProperty("compProdSmallIcon");
        return string == null || string.length() == 0 ? NONE : string;
    }

    private String getLargeIcon() {
        String string = (String)this.mySettings.getProperty("compProdLargeIcon");
        return string == null || string.length() == 0 ? NONE : string;
    }

    private Boolean getValidAlways() {
        return (Boolean)this.mySettings.getProperty("compProdValidAlways");
    }

    private Boolean getValidPlatform() {
        return (Boolean)this.mySettings.getProperty("compProdValidPlatform");
    }

    private Boolean getValidCustom() {
        return (Boolean)this.mySettings.getProperty("compProdValidCustom");
    }

    private boolean checkValidity() {
        if (!this.isCPClassNameValid()) {
            return false;
        }
        if (!this.isCPPaletteDispNameValid()) {
            return false;
        }
        if (!this.isCPSmallIconValid()) {
            return false;
        }
        if (!this.isCPLargeIconValid()) {
            return false;
        }
        if (!this.isCPLibNameValid()) {
            return false;
        }
        this.markValid();
        return true;
    }

    private boolean isCPSmallIconValid() {
        String string = this.getSmallIconValue();
        if (string.length() == 0) {
            this.setWarning(IconUtils.getNoIconMessage(16, 16));
        } else {
            if (!ComponentProducerVisualPanel.isFileExist(string)) {
                this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_SMALL_NOT_EXIST, new Object[0]));
                return false;
            }
            if (!IconUtils.isValidIcon(new File(string), 16, 16)) {
                this.setWarning(IconUtils.getIconDimensionMessage(new File(string), 16, 16));
            }
        }
        return true;
    }

    private boolean isCPLargeIconValid() {
        String string = this.getLargeIconValue();
        if (string.length() == 0) {
            this.setWarning(IconUtils.getNoIconMessage(32, 32));
        } else {
            if (!ComponentProducerVisualPanel.isFileExist(string)) {
                this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_LARGE_NOT_EXIST, new Object[0]));
                return false;
            }
            if (!IconUtils.isValidIcon(new File(string), 32, 32)) {
                this.setWarning(IconUtils.getIconDimensionMessage(new File(string), 32, 32));
            }
        }
        return true;
    }

    private static boolean isFileExist(String string) {
        File file = new File(string);
        return file.exists();
    }

    private boolean isCPClassNameValid() {
        String string = this.getClassNameValue();
        if (string.length() == 0) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_CLASS_NAME_EMPTY, new Object[0]));
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_CLASS_NAME_INVALID, new Object[0]));
            return false;
        }
        if (this.getHelper().isProducerClassNameExist(string)) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_CLASS_NAME_EXISTS, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCPPaletteDispNameValid() {
        String string = this.getPaletteDispNameValue();
        if (string.length() == 0) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_PALETTE_DISP_NAME_EMPTY, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCPLibNameValid() {
        if (!this.getAddLibraryValue().booleanValue()) {
            return true;
        }
        String string = this.getLibraryNameValue();
        if (string.length() == 0) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_LIB_NAME_EMPTY, new Object[0]));
            return false;
        }
        return true;
    }

    protected final void setError(String string) {
        assert (string != null);
        this.setMessage(string);
        this.setValid(false);
    }

    protected final void setWarning(String string) {
        assert (string != null);
        this.setMessage(string);
        this.setValid(true);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    private final void setMessage(String string) {
        this.mySettings.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    private final void setValid(boolean bl) {
        this.myPanel.setValid(bl);
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(ComponentProducerVisualPanel.class);
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)string, (Object[])objectArray);
    }

    private String getClassNameValue() {
        return this.myCPClassName.getText().trim();
    }

    private String getPaletteDispNameValue() {
        return this.myCPPaletteDispName.getText().trim();
    }

    private String getPaletteTooltipValue() {
        return this.myCPPaletteTooltip.getText().trim();
    }

    private PaletteCategory getPaletteCategoryValue() {
        return (PaletteCategory)((Object)this.myCPPaletteCategoryCombo.getSelectedItem());
    }

    private String getSmallIconValue() {
        String string = this.myCPSmallIconPath.getText().trim();
        return string.equals(NONE) ? "" : string;
    }

    private String getLargeIconValue() {
        String string = this.myCPLargeIconPath.getText().trim();
        return string.equals(NONE) ? "" : string;
    }

    private Boolean getAddLibraryValue() {
        return this.myCPAddLibDependencyChk.isSelected();
    }

    private String getLibraryNameValue() {
        return this.myCPLibName.getText().trim();
    }

    private Boolean getValidAlwaysValue() {
        return this.myCPValidAlwaysRadio.isSelected();
    }

    private Boolean getValidPlatformValue() {
        return this.myCPValidPlatformRadio.isSelected();
    }

    private Boolean getValidCustomValue() {
        return this.myCPValidCustomRadio.isSelected();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.myCPClassName.getDocument().addDocumentListener(this.myClassNameListener);
            this.myCPPaletteDispName.getDocument().addDocumentListener(this.myDocListener);
            this.myCPPaletteTooltip.getDocument().addDocumentListener(this.myDocListener);
            this.myCPSmallIconPath.getDocument().addDocumentListener(this.mySmallIconPathListener);
            this.myCPLargeIconPath.getDocument().addDocumentListener(this.myLargeIconPathListener);
            this.myCPLibName.getDocument().addDocumentListener(this.myDocListener);
            this.myCPAddLibDependencyChk.addActionListener(this.myAddLibDependencyListener);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.myCPClassName.getDocument().removeDocumentListener(this.myClassNameListener);
            this.myCPPaletteDispName.getDocument().removeDocumentListener(this.myDocListener);
            this.myCPPaletteTooltip.getDocument().removeDocumentListener(this.myDocListener);
            this.myCPSmallIconPath.getDocument().removeDocumentListener(this.mySmallIconPathListener);
            this.myCPLargeIconPath.getDocument().removeDocumentListener(this.myLargeIconPathListener);
            this.myCPLibName.getDocument().removeDocumentListener(this.myDocListener);
            this.myCPAddLibDependencyChk.removeActionListener(this.myAddLibDependencyListener);
            this.listenersAttached = false;
        }
    }

    private void initComponents() {
        this.myValidButtonGroup = new ButtonGroup();
        this.myCompProducerPanel = new JPanel();
        this.myCPClassNameLabel = new JLabel();
        this.myCPClassName = new JTextField();
        this.myCPPaletteDispNameLabel = new JLabel();
        this.myCPPaletteDispName = new JTextField();
        this.myCPPaletteTooltipLabel = new JLabel();
        this.myCPPaletteTooltip = new JTextField();
        this.myCPPaletteCategoryLabel = new JLabel();
        this.myCPPaletteCategoryCombo = new JComboBox();
        this.myCPSmallIconPathLabel = new JLabel();
        this.myCPSmallIconPath = new JTextField();
        this.myCPSmallIconPathButton = new JButton();
        this.myCPLargeIconPathLabel = new JLabel();
        this.myCPLargeIconPath = new JTextField();
        this.myCPLargeIconPathButton = new JButton();
        this.myCPAddLibDependencyChk = new JCheckBox();
        this.myLibNamePanel = new JPanel();
        this.myCPLibNameLabel = new JLabel();
        this.myCPLibName = new JTextField();
        this.myValidityPanel = new JPanel();
        this.myCPValidAlwaysRadio = new JRadioButton();
        this.myCPValidPlatformRadio = new JRadioButton();
        this.myCPValidCustomRadio = new JRadioButton();
        this.myCompProducerPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ComponentProducer")));
        this.myCPClassNameLabel.setLabelFor(this.myCPClassName);
        Mnemonics.setLocalizedText((JLabel)this.myCPClassNameLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ClassNameLabel"));
        this.myCPClassName.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ClassNameLabel"));
        this.myCPPaletteDispNameLabel.setLabelFor(this.myCPPaletteDispName);
        Mnemonics.setLocalizedText((JLabel)this.myCPPaletteDispNameLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_PaletteDisplayName"));
        this.myCPPaletteDispName.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteDisplayName"));
        this.myCPPaletteTooltipLabel.setLabelFor(this.myCPPaletteTooltip);
        Mnemonics.setLocalizedText((JLabel)this.myCPPaletteTooltipLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_PaletteTooltip"));
        this.myCPPaletteTooltip.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteTooltip"));
        this.myCPPaletteCategoryLabel.setLabelFor(this.myCPPaletteCategoryCombo);
        Mnemonics.setLocalizedText((JLabel)this.myCPPaletteCategoryLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_PaletteCategory"));
        this.myCPPaletteCategoryCombo.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteCategory"));
        this.myCPSmallIconPathLabel.setLabelFor(this.myCPSmallIconPath);
        Mnemonics.setLocalizedText((JLabel)this.myCPSmallIconPathLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_SmallIconPath"));
        this.myCPSmallIconPath.setText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)TXT_NONE));
        this.myCPSmallIconPath.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_SmallIconPath"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCPSmallIconPathButton, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_SmallIconButton"));
        this.myCPSmallIconPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentProducerVisualPanel.this.myCPSmallIconPathButtonActionPerformed(actionEvent);
            }
        });
        this.myCPLargeIconPathLabel.setLabelFor(this.myCPLargeIconPath);
        Mnemonics.setLocalizedText((JLabel)this.myCPLargeIconPathLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_LargeIconPath"));
        this.myCPLargeIconPath.setText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)TXT_NONE));
        this.myCPLargeIconPath.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LargeIconPath"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCPLargeIconPathButton, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_LargeIconButton"));
        this.myCPLargeIconPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentProducerVisualPanel.this.myCPLargeIconPathButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.myCPAddLibDependencyChk, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_AddLibraryChk"));
        this.myCPLibNameLabel.setLabelFor(this.myCPLibName);
        Mnemonics.setLocalizedText((JLabel)this.myCPLibNameLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_LibName"));
        this.myCPLibName.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LibName"));
        GroupLayout groupLayout = new GroupLayout((Container)this.myLibNamePanel);
        this.myLibNamePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(40, 40, 40).add((Component)this.myCPLibNameLabel).addPreferredGap(1).add((Component)this.myCPLibName, -1, 287, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.myCPLibNameLabel).add((Component)this.myCPLibName, -2, -1, -2)));
        this.myCPLibNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_LibName"));
        this.myCPLibNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LibName"));
        this.myValidityPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_Validity")));
        this.myValidButtonGroup.add(this.myCPValidAlwaysRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.myCPValidAlwaysRadio, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ValidAlways"));
        this.myCPValidAlwaysRadio.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidAlways"));
        this.myValidButtonGroup.add(this.myCPValidPlatformRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.myCPValidPlatformRadio, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ValidPlatform"));
        this.myCPValidPlatformRadio.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidPlatform"));
        this.myValidButtonGroup.add(this.myCPValidCustomRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.myCPValidCustomRadio, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ValidCustom"));
        this.myCPValidCustomRadio.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidCustom"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.myValidityPanel);
        this.myValidityPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.myCPValidAlwaysRadio).add((Component)this.myCPValidPlatformRadio).add((Component)this.myCPValidCustomRadio)).addContainerGap(241, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.myCPValidAlwaysRadio).addPreferredGap(0).add((Component)this.myCPValidPlatformRadio).addPreferredGap(0).add((Component)this.myCPValidCustomRadio).addContainerGap(-1, Short.MAX_VALUE)));
        this.myCPValidAlwaysRadio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ValidAlways"));
        this.myCPValidAlwaysRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidAlways"));
        this.myCPValidPlatformRadio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ValidPlatform"));
        this.myCPValidPlatformRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidPlatform"));
        this.myCPValidCustomRadio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ValidCustom"));
        this.myCPValidCustomRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidCustom"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.myCompProducerPanel);
        this.myCompProducerPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.myValidityPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add(1, (Component)this.myCPAddLibDependencyChk).add(1, (Component)this.myLibNamePanel, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.myCPPaletteDispNameLabel).add((Component)this.myCPPaletteTooltipLabel).add((Component)this.myCPPaletteCategoryLabel).add((Component)this.myCPSmallIconPathLabel).add((Component)this.myCPLargeIconPathLabel).add((Component)this.myCPClassNameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.myCPClassName, -1, 295, Short.MAX_VALUE).add((Component)this.myCPPaletteTooltip, -1, 295, Short.MAX_VALUE).add((Component)this.myCPPaletteDispName, -1, 295, Short.MAX_VALUE).add((Component)this.myCPPaletteCategoryCombo, -2, 182, -2).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add((Component)this.myCPLargeIconPath, -1, 222, Short.MAX_VALUE).add((Component)this.myCPSmallIconPath, -1, 222, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (Component)this.myCPSmallIconPathButton).add(2, (Component)this.myCPLargeIconPathButton)))))).addPreferredGap(0))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.myCPClassNameLabel).add((Component)this.myCPClassName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.myCPPaletteDispNameLabel).add((Component)this.myCPPaletteDispName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.myCPPaletteTooltipLabel).add((Component)this.myCPPaletteTooltip, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.myCPPaletteCategoryLabel).add((Component)this.myCPPaletteCategoryCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.myCPSmallIconPathLabel).add((Component)this.myCPSmallIconPathButton).add((Component)this.myCPSmallIconPath, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.myCPLargeIconPathLabel).add((Component)this.myCPLargeIconPathButton).add((Component)this.myCPLargeIconPath, -2, -1, -2)).addPreferredGap(0).add((Component)this.myCPAddLibDependencyChk).addPreferredGap(0).add((Component)this.myLibNamePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.myValidityPanel, -2, -1, -2)));
        this.myCPClassNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ClassNameLabel"));
        this.myCPClassNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ClassNameLabel"));
        this.myCPPaletteDispNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_PaletteDisplayName"));
        this.myCPPaletteDispNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteDisplayName"));
        this.myCPPaletteTooltipLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_PaletteTooltip"));
        this.myCPPaletteTooltipLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteTooltip"));
        this.myCPPaletteCategoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_PaletteCategory"));
        this.myCPPaletteCategoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteCategory"));
        this.myCPSmallIconPathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_SmallIconPath"));
        this.myCPSmallIconPathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_SmallIconPath"));
        this.myCPSmallIconPathButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_SmallIconButton"));
        this.myCPSmallIconPathButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_SmallIconButton"));
        this.myCPLargeIconPathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_LargeIconPath"));
        this.myCPLargeIconPathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LargeIconPath"));
        this.myCPLargeIconPathButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_LargeIconButton"));
        this.myCPLargeIconPathButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LargeIconButton"));
        this.myCPAddLibDependencyChk.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_AddLibraryChk"));
        this.myCPAddLibDependencyChk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_AddLibraryChk"));
        GroupLayout groupLayout4 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.myCompProducerPanel, -1, -1, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.myCompProducerPanel, -2, -1, -2));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ComponentProducerPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ComponentProducerPanel"));
    }

    private void myCPSmallIconPathButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = IconUtils.getIconFileChooser(this.myCPSmallIconPath.getText());
        int n = jFileChooser.showDialog(this, ComponentProducerVisualPanel.getMessage(LBL_SELECT, new Object[0]));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            File file2 = ComponentProducerVisualPanel.getAnotherIconPath(file);
            if (file2 != null) {
                boolean bl = IconUtils.isValidIcon(file, 16, 16);
                String string = bl ? file.getAbsolutePath() : file2.getAbsolutePath();
                String string2 = bl ? file2.getAbsolutePath() : file.getAbsolutePath();
                this.myCPSmallIconPath.setText(string);
                if (!this.isLargeIconUpdated) {
                    this.myCPLargeIconPath.setText(string2);
                    this.isLargeIconUpdated = false;
                }
            } else {
                this.myCPSmallIconPath.setText(file.getAbsolutePath());
            }
        }
    }

    private void myCPLargeIconPathButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = IconUtils.getIconFileChooser(this.myCPLargeIconPath.getText());
        int n = jFileChooser.showDialog(this, ComponentProducerVisualPanel.getMessage(LBL_SELECT, new Object[0]));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            File file2 = ComponentProducerVisualPanel.getAnotherIconPath(file);
            if (file2 != null) {
                boolean bl = IconUtils.isValidIcon(file, 16, 16);
                String string = bl ? file.getAbsolutePath() : file2.getAbsolutePath();
                String string2 = bl ? file2.getAbsolutePath() : file.getAbsolutePath();
                this.myCPLargeIconPath.setText(string2);
                if (!this.isSmallIconUpdated) {
                    this.myCPSmallIconPath.setText(string);
                    this.isSmallIconUpdated = false;
                }
            } else {
                this.myCPLargeIconPath.setText(file.getAbsolutePath());
            }
        }
    }

    private static File getAnotherIconPath(File file) {
        Set<File> set = IconUtils.getPossibleIcons(file.getAbsolutePath());
        assert (set.contains(file));
        set.remove(file);
        boolean bl = IconUtils.isValidIcon(file, 16, 16);
        File file2 = null;
        boolean bl2 = false;
        Iterator<File> iterator = set.iterator();
        while (iterator.hasNext() && !bl2) {
            File file3 = iterator.next();
            bl2 = bl ? IconUtils.isValidIcon(file3, 32, 32) : IconUtils.isValidIcon(file3, 16, 16);
            if (!bl2) continue;
            file2 = file3;
            break;
        }
        return file2;
    }
}

