/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.projects.AntFilesHelper;
import org.netbeans.modules.websvc.rest.projects.RestApplicationsPanel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRs;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRsStackProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebProjectRestSupport
extends WebRestSupport {
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    String[] classPathTypes = new String[]{"classpath/compile"};

    public WebProjectRestSupport(Project project) {
        super(project);
    }

    public void upgrade() {
        if (!this.isRestSupportOn()) {
            return;
        }
        try {
            FileObject fileObject = this.getDeploymentDescriptor();
            if (fileObject == null) {
                return;
            }
            WebApp webApp = this.findWebApp();
            if (webApp == null) {
                return;
            }
            Servlet servlet = this.getRestServletAdaptorByName(webApp, "ServletAdaptor");
            if (servlet != null && "com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(servlet.getServletClass())) {
                boolean bl = this.hasSpringSupport();
                if (bl) {
                    servlet.setServletClass("com.sun.jersey.spi.spring.container.servlet.SpringServlet");
                    InitParam initParam = (InitParam)servlet.findBeanByName("InitParam", "ParamName", "com.sun.jersey.config.property.packages");
                    if (initParam == null) {
                        try {
                            initParam = (InitParam)servlet.createBean("InitParam");
                            initParam.setParamName("com.sun.jersey.config.property.packages");
                            initParam.setParamValue(".");
                            initParam.setDescription("Multiple packages, separated by semicolon(;), can be specified in param-value");
                            servlet.addInitParam(initParam);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                } else {
                    servlet.setServletClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                }
                webApp.write(fileObject);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void extendBuildScripts() throws IOException {
        new AntFilesHelper((RestSupport)this).initRestBuildExtension();
    }

    public void ensureRestDevelopmentReady() throws IOException {
        FileObject fileObject;
        boolean bl = false;
        String string = "/resources/*";
        if (!this.isRestSupportOn()) {
            bl = true;
            this.setProjectProperty("rest.support.on", "true");
            string = this.setApplicationConfigProperty(RestUtils.isAnnotationConfigAvailable(this.project));
        }
        this.extendBuildScripts();
        this.addSwdpLibrary();
        String string2 = this.getProjectProperty("rest.config.type");
        if (string2 == null || "dd".equals(string2)) {
            this.addResourceConfigToWebApp(string);
        }
        if ("ide".equals(string2) && (fileObject = Utils.findBuildXml(this.project)) != null) {
            ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"generate-rest-config"}, null);
        }
        if (this.hasSpringSupport()) {
            this.addJerseySpringJar();
        }
        ProjectManager.getDefault().saveProject(this.getProject());
        if (bl) {
            this.refreshRestServicesMetadataModel();
        }
    }

    public void removeRestDevelopmentReadiness() throws IOException {
        this.removeResourceConfigFromWebApp();
        this.removeSwdpLibrary(new String[]{"classpath/compile", "classpath/execute"});
        this.setProjectProperty("rest.support.on", "false");
        ProjectManager.getDefault().saveProject(this.getProject());
    }

    public boolean isReady() {
        return this.isRestSupportOn() && this.hasSwdpLibrary() && this.hasRestServletAdaptor();
    }

    private boolean platformHasRestLib(J2eePlatform j2eePlatform) {
        WSStack wSStack;
        if (j2eePlatform != null && (wSStack = JaxRsStackProvider.getJaxRsStack((J2eePlatform)j2eePlatform)) != null) {
            return wSStack.isFeatureSupported((WSStack.Feature)JaxRs.Feature.JAXRS);
        }
        return false;
    }

    public boolean hasSwdpLibrary() {
        J2eePlatform j2eePlatform = this.getPlatform();
        if (j2eePlatform == null) {
            return false;
        }
        if (this.platformHasRestLib(j2eePlatform)) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (File file : j2eePlatform.getClasspathEntries()) {
            String string = file.getName();
            if (string.equals("jsr311-api.jar")) {
                bl = true;
            }
            if (string.startsWith("jersey") && string.endsWith(".jar")) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return false;
    }

    public J2eePlatform getPlatform() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return null;
        }
        try {
            return Deployment.getDefault().getServerInstance(j2eeModuleProvider.getServerInstanceID()).getJ2eePlatform();
        }
        catch (InstanceRemovedException instanceRemovedException) {
            return null;
        }
    }

    private void addSwdpLibrary() throws IOException {
        if (!this.hasSwdpLibrary()) {
            this.addSwdpLibrary(this.classPathTypes);
        } else {
            J2eeModuleProvider j2eeModuleProvider;
            WSStack wSStack;
            J2eePlatform j2eePlatform = this.getPlatform();
            if (j2eePlatform != null && (wSStack = JaxRsStackProvider.getJaxRsStack((J2eePlatform)j2eePlatform)) != null && (j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
                String string = this.getServerRestLibraryName(j2eeModuleProvider);
                Library library = LibraryManager.getDefault().getLibrary(string);
                if (library != null) {
                    this.addSwdpLibrary(this.classPathTypes, library);
                }
            }
        }
    }

    private String getServerRestLibraryName(J2eeModuleProvider j2eeModuleProvider) {
        return "restlib_" + j2eeModuleProvider.getServerID();
    }

    private J2eePlatform getJ2eePlatform(J2eeModuleProvider j2eeModuleProvider) {
        String string = j2eeModuleProvider.getServerInstanceID();
        if (string != null && string.length() > 0) {
            try {
                return Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(WebProjectRestSupport.class.getName()).log(Level.INFO, "Failed to find J2eePlatform");
            }
        }
        return null;
    }

    public FileObject getPersistenceXml() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (persistenceScope != null) {
            return persistenceScope.getPersistenceXml();
        }
        return null;
    }

    public FileObject getApplicationContextXml() {
        FileObject fileObject;
        FileObject fileObject2;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        FileObject[] fileObjectArray = j2eeModuleProvider.getSourceRoots();
        if (fileObjectArray.length > 0 && (fileObject2 = (fileObject = fileObjectArray[0]).getFileObject("WEB-INF")) != null) {
            return fileObject2.getFileObject("applicationContext", "xml");
        }
        return null;
    }

    public Datasource getDatasource(String string) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        try {
            return j2eeModuleProvider.getConfigSupport().findDatasource(string);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setDirectoryDeploymentProperty(Properties properties) {
        String string = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty(J2EE_SERVER_INSTANCE);
        if (string != null) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            String string2 = j2eeModuleProvider.getServerInstanceID();
            J2eeModule j2eeModule = j2eeModuleProvider.getJ2eeModule();
            if (string2 != null && j2eeModule != null) {
                boolean bl = Deployment.getDefault().canFileDeploy(string, j2eeModule);
                properties.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, String.valueOf(bl));
            }
        }
    }

    protected void logResourceCreation(Project project) {
        Object[] objectArray = new Object[]{"JAX-RS", this.project.getClass().getName(), "REST RESOURCE"};
        LogUtils.logWsDetect((Object[])objectArray);
    }

    public String getApplicationPath() throws IOException {
        String string = this.getApplicationPathFromDD();
        String string2 = this.getApplicationPathFromAnnotations(string);
        return string2 == null ? super.getApplicationPath() : string2;
    }

    private String getApplicationPathFromAnnotations(final String string) {
        List list = this.getRestApplications();
        if (string == null) {
            if (list.size() == 0) {
                return null;
            }
            return this.getApplicationPathFromDialog(list);
        }
        if (list.size() == 0) {
            return string;
        }
        boolean bl = false;
        for (RestApplication restApplication : list) {
            if (!string.equals(restApplication.getApplicationPath())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            list.add(new RestApplication(){

                public String getApplicationPath() {
                    return string;
                }

                public String getApplicationClass() {
                    return "web.xml";
                }
            });
        }
        return this.getApplicationPathFromDialog(list);
    }

    private String getApplicationPathFromDialog(List<RestApplication> list) {
        if (list.size() == 1) {
            return list.get(0).getApplicationPath();
        }
        RestApplicationsPanel restApplicationsPanel = new RestApplicationsPanel(list);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)restApplicationsPanel, NbBundle.getMessage(WebProjectRestSupport.class, (String)"TTL_RestResourcesPath"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            return restApplicationsPanel.getApplicationPath();
        }
        return null;
    }
}

