/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.output;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class OutputUtils {
    static final Pattern linePattern = Pattern.compile("(?:\\[catch\\])?\\sat (.*)\\((.*)\\.java\\:(.*)\\)");

    private OutputUtils() {
    }

    public static OutputListener matchStackTraceLine(String line, ClassPath classPath) {
        Matcher match = linePattern.matcher(line);
        StacktraceOutputListener list = null;
        if (match.matches()) {
            String packageName;
            String resourceName;
            FileObject resource;
            String method = match.group(1);
            String file = match.group(2);
            String lineNum = match.group(3);
            int index = method.indexOf(file);
            if (index > -1 && (resource = classPath.findResource(resourceName = (packageName = method.substring(0, index).replace('.', '/')) + file + ".class")) != null) {
                FileObject root = classPath.findOwnerRoot(resource);
                URL url = URLMapper.findURL((FileObject)root, (int)0);
                SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)url);
                FileObject[] rootz = res.getRoots();
                for (int i = 0; i < rootz.length; ++i) {
                    String path = packageName + file + ".java";
                    FileObject javaFo = rootz[i].getFileObject(path);
                    if (javaFo == null) continue;
                    try {
                        DataObject obj = DataObject.find((FileObject)javaFo);
                        EditorCookie cook = (EditorCookie)obj.getCookie(EditorCookie.class);
                        int lineInt = Integer.parseInt(lineNum);
                        list = new StacktraceOutputListener(cook, lineInt);
                        continue;
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return list;
    }

    private static class StacktraceOutputListener
    implements OutputListener {
        private EditorCookie cookie;
        private int line;

        public StacktraceOutputListener(EditorCookie cook, int ln) {
            this.cookie = cook;
            this.line = ln - 1;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            this.cookie.getLineSet().getCurrent(this.line).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

