/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.modules.maven.MavenValidators;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.newproject.ArchetypeWizardUtils;
import org.netbeans.modules.maven.newproject.BasicWizardPanel;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class BasicPanelVisual
extends JPanel
implements DocumentListener,
WindowFocusListener,
Runnable {
    public static final String PROP_PROJECT_NAME = "projectName";
    private static final String ERROR_MSG = "WizardPanel_errorMessage";
    private static final ArtifactVersion BORDER_VERSION = new DefaultArtifactVersion("2.0.7");
    private boolean askedForVersion;
    private ArtifactVersion mavenVersion;
    private static final Object MAVEN_VERSION_LOCK = new Object();
    private BasicWizardPanel panel;
    private String lastProjectName = "";
    private final ValidationGroup vg;
    private boolean changedPackage = false;
    private JButton browseButton;
    private JButton btnSetupNewer;
    private JComboBox comboEEVersion;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel lblAdditionalProps;
    private JLabel lblArtifactId;
    private JLabel lblEEVersion;
    private JLabel lblGroupId;
    private JLabel lblPackage;
    private JLabel lblVersion;
    private JPanel pnlAdditionals;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JTable tblAdditionalProps;
    private JTextField txtArtifactId;
    private JTextField txtGroupId;
    private JTextField txtPackage;
    private JTextField txtVersion;

    public BasicPanelVisual(BasicWizardPanel panel) {
        this.panel = panel;
        this.initComponents();
        this.projectLocationTextField.putClientProperty("_name", NbBundle.getMessage(BasicPanelVisual.class, (String)"VAL_projectLocationTextField"));
        this.projectNameTextField.putClientProperty("_name", NbBundle.getMessage(BasicPanelVisual.class, (String)"VAL_projectNameTextField"));
        this.txtArtifactId.putClientProperty("_name", NbBundle.getMessage(BasicPanelVisual.class, (String)"VAL_ArtifactId"));
        this.txtVersion.putClientProperty("_name", NbBundle.getMessage(BasicPanelVisual.class, (String)"VAL_Version"));
        this.txtGroupId.putClientProperty("_name", NbBundle.getMessage(BasicPanelVisual.class, (String)"VAL_GroupId"));
        this.txtPackage.putClientProperty("_name", NbBundle.getMessage(BasicPanelVisual.class, (String)"VAL_Package"));
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.txtArtifactId.getDocument().addDocumentListener(this);
        this.txtGroupId.getDocument().addDocumentListener(this);
        this.txtVersion.getDocument().addDocumentListener(this);
        this.txtPackage.getDocument().addDocumentListener(this);
        this.tblAdditionalProps.setVisible(false);
        this.lblAdditionalProps.setVisible(false);
        this.jScrollPane1.setVisible(false);
        if (panel.getArchetypes() == null) {
            this.lblEEVersion.setVisible(false);
            this.comboEEVersion.setVisible(false);
        }
        this.btnSetupNewer.setVisible(false);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_CreateProjectStep2"));
        this.txtGroupId.setText(MavenSettings.getDefault().getLastArchetypeGroupId());
        this.vg = ValidationGroup.create((ValidationUI[])new ValidationUI[0]);
        this.vg.add((JTextComponent)this.txtGroupId, new Validator[]{MavenValidators.createGroupIdValidators()});
        this.vg.add((JTextComponent)this.txtArtifactId, new Validator[]{MavenValidators.createArtifactIdValidators()});
        this.vg.add((JTextComponent)this.txtVersion, new Validator[]{MavenValidators.createVersionValidators()});
        this.vg.add((JTextComponent)this.txtPackage, new Validator[]{Validators.merge((boolean)true, (Validator[])new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.JAVA_PACKAGE_NAME})});
        this.vg.add((JTextComponent)this.projectNameTextField, new Validator[]{Validators.merge((boolean)true, (Validator[])new Validator[]{MavenValidators.createArtifactIdValidators(), Validators.REQUIRE_VALID_FILENAME})});
        this.vg.add((JTextComponent)this.projectLocationTextField, new Validator[]{Validators.merge((boolean)true, (Validator[])new Validator[]{new Validator<String>(){

            public boolean validate(Problems problems, String compName, String model) {
                File fil;
                File projLoc;
                for (projLoc = fil = FileUtil.normalizeFile((File)new File(model)); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
                }
                if (projLoc == null || !projLoc.canWrite()) {
                    problems.add(NbBundle.getMessage(BasicPanelVisual.class, (String)"ERR_Project_Folder_cannot_be_created"));
                    return false;
                }
                if (FileUtil.toFileObject((File)projLoc) == null) {
                    problems.add(NbBundle.getMessage(BasicPanelVisual.class, (String)"ERR_Project_Folder_is_not_valid_path"));
                    return false;
                }
                if (Utilities.isWindows() && fil.getAbsolutePath().startsWith("\\\\")) {
                    problems.add(NbBundle.getMessage(BasicPanelVisual.class, (String)"ERR_Project_Folder_is_UNC"));
                    return false;
                }
                return true;
            }
        }})});
        this.vg.add(new ValidationListener(){

            protected boolean validate(Problems problems) {
                boolean tooOld = BasicPanelVisual.this.isMavenTooOld();
                BasicPanelVisual.this.btnSetupNewer.setVisible(tooOld);
                if (tooOld) {
                    problems.add(NbBundle.getMessage(BasicPanelVisual.class, (String)"ERR_old_maven", (Object)BasicPanelVisual.this.getCommandLineMavenVersion()));
                    return false;
                }
                File destFolder = FileUtil.normalizeFile((File)new File(new File(BasicPanelVisual.this.projectLocationTextField.getText().trim()), BasicPanelVisual.this.projectNameTextField.getText().trim()).getAbsoluteFile());
                File[] kids = destFolder.listFiles();
                if (destFolder.exists() && kids != null && kids.length > 0) {
                    problems.add(NbBundle.getMessage(BasicPanelVisual.class, (String)"ERR_Project_Folder_exists"));
                    return false;
                }
                return true;
            }
        });
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.lblArtifactId = new JLabel();
        this.txtArtifactId = new JTextField();
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblPackage = new JLabel();
        this.txtPackage = new JTextField();
        this.jLabel1 = new JLabel();
        this.pnlAdditionals = new JPanel();
        this.lblAdditionalProps = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblAdditionalProps = new JTable();
        this.btnSetupNewer = new JButton();
        this.lblEEVersion = new JLabel();
        this.comboEEVersion = new JComboBox();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_ProjectName"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_ProjectLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"BTN_Browse"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicPanelVisual.this.browseButtonActionPerformed(evt);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_ProjectFolder"));
        this.createdFolderTextField.setEditable(false);
        this.createdFolderTextField.setEnabled(false);
        this.lblArtifactId.setLabelFor(this.txtArtifactId);
        Mnemonics.setLocalizedText((JLabel)this.lblArtifactId, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_ArtifactId"));
        this.txtArtifactId.setEditable(false);
        this.txtArtifactId.setEnabled(false);
        this.lblGroupId.setLabelFor(this.txtGroupId);
        Mnemonics.setLocalizedText((JLabel)this.lblGroupId, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_GroupId"));
        this.lblVersion.setLabelFor(this.txtVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblVersion, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_Version"));
        this.txtVersion.setText("1.0-SNAPSHOT");
        this.lblPackage.setLabelFor(this.txtPackage);
        Mnemonics.setLocalizedText((JLabel)this.lblPackage, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_Package"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_Optional"));
        this.lblAdditionalProps.setLabelFor(this.tblAdditionalProps);
        Mnemonics.setLocalizedText((JLabel)this.lblAdditionalProps, (String)"jLabel2");
        this.tblAdditionalProps.setModel(this.createPropModel());
        this.tblAdditionalProps.setColumnSelectionAllowed(true);
        this.jScrollPane1.setViewportView(this.tblAdditionalProps);
        this.tblAdditionalProps.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.tblAdditionalProps.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.tblAdditionalProps.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetupNewer, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"BTN_SetupNewer.text"));
        this.btnSetupNewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicPanelVisual.this.btnSetupNewerActionPerformed(evt);
            }
        });
        GroupLayout pnlAdditionalsLayout = new GroupLayout((Container)this.pnlAdditionals);
        this.pnlAdditionals.setLayout((LayoutManager)pnlAdditionalsLayout);
        pnlAdditionalsLayout.setHorizontalGroup((GroupLayout.Group)pnlAdditionalsLayout.createParallelGroup(1).add((GroupLayout.Group)pnlAdditionalsLayout.createSequentialGroup().add((Component)this.lblAdditionalProps).addContainerGap(493, Short.MAX_VALUE)).add((GroupLayout.Group)pnlAdditionalsLayout.createSequentialGroup().add((Component)this.btnSetupNewer).addContainerGap()).add((Component)this.jScrollPane1, -1, 538, Short.MAX_VALUE));
        pnlAdditionalsLayout.setVerticalGroup((GroupLayout.Group)pnlAdditionalsLayout.createParallelGroup(1).add((GroupLayout.Group)pnlAdditionalsLayout.createSequentialGroup().add((Component)this.lblAdditionalProps).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 102, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnSetupNewer)));
        this.btnSetupNewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.btnSetupNewer.AccessibleContext.accessibleDescription"));
        this.lblEEVersion.setLabelFor(this.comboEEVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblEEVersion, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_JavaEE"));
        this.comboEEVersion.setModel(new DefaultComboBoxModel<String>(this.panel.getEELevels()));
        this.comboEEVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicPanelVisual.this.comboEEVersionActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblPackage).add((Component)this.lblVersion).add((Component)this.lblGroupId).add((Component)this.lblArtifactId).add((Component)this.createdFolderLabel).add((Component)this.projectLocationLabel).add((Component)this.projectNameLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.projectNameTextField, -1, 316, Short.MAX_VALUE).add(2, (Component)this.projectLocationTextField, -1, 316, Short.MAX_VALUE).add(2, (Component)this.createdFolderTextField, -1, 316, Short.MAX_VALUE).add((Component)this.txtPackage, -1, 316, Short.MAX_VALUE).add((Component)this.txtVersion, -1, 316, Short.MAX_VALUE).add((Component)this.txtGroupId, -1, 316, Short.MAX_VALUE).add((Component)this.txtArtifactId, -1, 316, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.browseButton).add((Component)this.jLabel1))).add((Component)this.pnlAdditionals, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblEEVersion).add(18, 18, 18).add((Component)this.comboEEVersion, -2, -1, -2).add(253, 253, 253)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectNameTextField, -2, -1, -2).add((Component)this.projectNameLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.browseButton).add((Component)this.projectLocationLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createdFolderTextField, -2, -1, -2).add((Component)this.createdFolderLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblEEVersion).add((Component)this.comboEEVersion, -2, -1, -2)).add(31, 31, 31).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.txtArtifactId, -2, -1, -2).add((Component)this.lblArtifactId)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.txtGroupId, -2, -1, -2).add((Component)this.lblGroupId)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.txtVersion, -2, -1, -2).add((Component)this.lblVersion)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.txtPackage, -2, -1, -2).add((Component)this.lblPackage).add((Component)this.jLabel1)).addPreferredGap(0).add((Component)this.pnlAdditionals, -1, -1, Short.MAX_VALUE)));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.projectLocationTextField.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.browseButton.AccessibleContext.accessibleDescription"));
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.createdFolderTextField.AccessibleContext.accessibleDescription"));
        this.txtArtifactId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.txtArtifactId.AccessibleContext.accessibleDescription"));
        this.txtGroupId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.txtGroupId.AccessibleContext.accessibleDescription"));
        this.txtVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.txtVersion.AccessibleContext.accessibleDescription"));
        this.txtPackage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.txtPackage.AccessibleContext.accessibleDescription"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.jLabel1.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.AccessibleContext.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setDialogTitle(NbBundle.getMessage(BasicPanelVisual.class, (String)"TIT_Select_Project_Location"));
            chooser.setFileSelectionMode(1);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    private void comboEEVersionActionPerformed(ActionEvent evt) {
    }

    private void btnSetupNewerActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Advanced/Maven");
        this.panel.getValidationGroup().validateAll();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
        this.tblAdditionalProps.setVisible(false);
        this.lblAdditionalProps.setVisible(false);
        this.jScrollPane1.setVisible(false);
        SwingUtilities.getWindowAncestor(this).addWindowFocusListener(this);
    }

    static boolean containsMultiByte(String text, WizardDescriptor wd) {
        char[] textChars = text.toCharArray();
        for (int i = 0; i < textChars.length; ++i) {
            if (textChars[i] <= '\u00ff') continue;
            wd.putProperty(ERROR_MSG, (Object)NbBundle.getMessage(BasicPanelVisual.class, (String)"ERR_multibyte"));
            return true;
        }
        return false;
    }

    private boolean isMavenTooOld() {
        ArtifactVersion version = this.getCommandLineMavenVersion();
        return version != null ? BORDER_VERSION.compareTo((Object)version) > 0 : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArtifactVersion getCommandLineMavenVersion() {
        if (!this.askedForVersion) {
            this.askedForVersion = true;
            RequestProcessor.getDefault().post((Runnable)this);
        }
        Object object = MAVEN_VERSION_LOCK;
        synchronized (object) {
            return this.mavenVersion;
        }
    }

    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("name", (Object)name);
        d.putProperty("artifactId", (Object)this.txtArtifactId.getText().trim());
        d.putProperty("groupId", (Object)this.txtGroupId.getText().trim());
        MavenSettings.getDefault().setLastArchetypeGroupId(this.txtGroupId.getText().trim());
        d.putProperty("version", (Object)this.txtVersion.getText().trim());
        d.putProperty("package", (Object)this.txtPackage.getText().trim());
        if (this.tblAdditionalProps.isVisible()) {
            TableModel mdl = this.tblAdditionalProps.getModel();
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < mdl.getRowCount(); ++i) {
                map.put((String)mdl.getValueAt(i, 0), (String)mdl.getValueAt(i, 1));
            }
            d.putProperty("additionalProps", map);
        }
        if (this.panel.getArchetypes() != null) {
            d.putProperty("archetype", (Object)this.getArchetype(d));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicPanelVisual.this.panel.getValidationGroup().removeValidationGroup(BasicPanelVisual.this.vg);
            }
        });
    }

    void read(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("name");
        if (projectName == null) {
            int baseCount = 1;
            String formatter = NbBundle.getMessage(BasicPanelVisual.class, (String)"TXT_MavenProjectName");
            while ((projectName = this.validFreeProjectName(projectLocation, formatter, baseCount)) == null) {
                ++baseCount;
            }
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
        if (this.panel.areAdditional()) {
            final Archetype arch = this.getArchetype(settings);
            this.lblAdditionalProps.setText(NbBundle.getMessage(BasicPanelVisual.class, (String)"TXT_Checking1"));
            this.lblAdditionalProps.setVisible(true);
            this.tblAdditionalProps.setVisible(false);
            this.jScrollPane1.setVisible(false);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    BasicPanelVisual.this.prepareAdditionalProperties(arch);
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicPanelVisual.this.panel.getValidationGroup().addValidationGroup(BasicPanelVisual.this.vg, true);
            }
        });
    }

    private void prepareAdditionalProperties(Archetype arch) {
        final DefaultTableModel dtm = new DefaultTableModel();
        dtm.addColumn(NbBundle.getMessage(BasicPanelVisual.class, (String)"COL_Key"));
        dtm.addColumn(NbBundle.getMessage(BasicPanelVisual.class, (String)"COL_Value"));
        try {
            Artifact art = this.downloadArchetype(arch);
            File fil = art.getFile();
            if (fil.exists()) {
                Map<String, String> props = ArchetypeWizardUtils.getAdditionalProperties(art);
                for (String key : props.keySet()) {
                    String defVal = props.get(key);
                    dtm.addRow(new Object[]{key, defVal == null ? "" : defVal});
                }
            }
        }
        catch (ArtifactResolutionException ex) {
            Logger.getLogger(BasicPanelVisual.class.getName()).log(Level.FINE, "Cannot download archetype", ex);
        }
        catch (ArtifactNotFoundException ex) {
            Logger.getLogger(BasicPanelVisual.class.getName()).log(Level.FINE, "Cannot download archetype", ex);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (dtm.getRowCount() > 0) {
                    Mnemonics.setLocalizedText((JLabel)BasicPanelVisual.this.lblAdditionalProps, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"TXT_Checking2"));
                    BasicPanelVisual.this.lblAdditionalProps.setVisible(true);
                    BasicPanelVisual.this.jScrollPane1.setVisible(true);
                    BasicPanelVisual.this.tblAdditionalProps.setModel(dtm);
                    BasicPanelVisual.this.tblAdditionalProps.setVisible(true);
                } else {
                    BasicPanelVisual.this.tblAdditionalProps.setVisible(false);
                    BasicPanelVisual.this.lblAdditionalProps.setVisible(false);
                    BasicPanelVisual.this.jScrollPane1.setVisible(false);
                }
            }
        });
    }

    private Archetype getArchetype(WizardDescriptor settings) {
        Archetype[] archs = this.panel.getArchetypes();
        if (archs == null) {
            return (Archetype)settings.getProperty("archetype");
        }
        return archs[Math.max(0, this.comboEEVersion.getSelectedIndex())];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Artifact downloadArchetype(Archetype arch) throws ArtifactResolutionException, ArtifactNotFoundException {
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        Artifact art = online.createArtifact(arch.getGroupId(), arch.getArtifactId(), arch.getVersion(), "jar", "maven-archetype");
        Artifact pom = online.createArtifact(arch.getGroupId(), arch.getArtifactId(), arch.getVersion(), "pom", "pom");
        art.setArtifactHandler(new ArtifactHandler(){

            public String getExtension() {
                return "jar";
            }

            public String getDirectory() {
                return null;
            }

            public String getClassifier() {
                return null;
            }

            public String getPackaging() {
                return "maven-archetype";
            }

            public boolean isIncludesDependencies() {
                return false;
            }

            public String getLanguage() {
                return "java";
            }

            public boolean isAddedToClasspath() {
                return false;
            }
        });
        List<ArtifactRepository> repos = arch.getRepository() == null ? Collections.singletonList(EmbedderFactory.createRemoteRepository((MavenEmbedder)online, (String)"http://repo1.maven.org/maven2", (String)"central")) : Collections.singletonList(EmbedderFactory.createRemoteRepository((MavenEmbedder)online, (String)arch.getRepository(), (String)"custom-repo"));
        AggregateProgressHandle hndl = AggregateProgressFactory.createHandle((String)NbBundle.getMessage(BasicPanelVisual.class, (String)"Handle_Download"), (ProgressContributor[])new ProgressContributor[]{AggregateProgressFactory.createProgressContributor((String)"zaloha")}, null, null);
        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)hndl);
        try {
            hndl.start();
            try {
                WagonManager wagon = (WagonManager)online.getPlexusContainer().lookup(WagonManager.class);
                wagon.setDownloadMonitor((TransferListener)new ProgressTransferListener());
            }
            catch (ComponentLookupException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            online.resolve(pom, repos, online.getLocalRepository());
            online.resolve(art, repos, online.getLocalRepository());
        }
        finally {
            hndl.finish();
            ProgressTransferListener.clearAggregateHandle();
        }
        RepositoryInfo info = RepositoryPreferences.getInstance().getRepositoryInfoById("local");
        if (info != null) {
            RepositoryIndexer.updateIndexWithArtifacts((RepositoryInfo)info, Collections.singletonList(art));
        }
        return art;
    }

    private TableModel createPropModel() {
        return new DefaultTableModel();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            String projectFolder = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        }
        if (this.projectNameTextField.getDocument() == doc) {
            String projName = this.projectNameTextField.getText().trim();
            this.txtArtifactId.setText(projName.replaceAll(" ", ""));
        }
        if (!(this.changedPackage || this.projectNameTextField.getDocument() != doc && this.txtGroupId.getDocument() != doc)) {
            this.txtPackage.getDocument().removeDocumentListener(this);
            this.txtPackage.setText(BasicPanelVisual.getPackageName(this.txtGroupId.getText() + "." + this.projectNameTextField.getText()));
            this.txtPackage.getDocument().addDocumentListener(this);
        }
        if (this.txtPackage.getDocument() == doc) {
            boolean bl = this.changedPackage = this.txtPackage.getText().trim().length() != 0;
        }
        if (this.vg != null) {
            this.vg.validateAll();
        }
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, new Integer(index));
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    static String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if (!firstLetter && Character.isJavaIdentifierPart(c) || firstLetter && Character.isJavaIdentifierStart(c)) {
                firstLetter = false;
                if (Character.isUpperCase(c)) {
                    c = Character.toLowerCase(c);
                }
                builder.append(c);
                continue;
            }
            if (firstLetter || c != '.') continue;
            firstLetter = true;
            builder.append(c);
        }
        String toRet = builder.length() == 0 ? "pkg" : builder.toString();
        return toRet;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.askedForVersion = false;
        this.getCommandLineMavenVersion();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            String version = MavenSettings.getCommandLineMavenVersion();
            Object object = MAVEN_VERSION_LOCK;
            synchronized (object) {
                this.mavenVersion = version != null ? new DefaultArtifactVersion(version.trim()) : null;
            }
            SwingUtilities.invokeLater(this);
        } else {
            this.vg.validateAll();
        }
    }
}

