/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOrRenameOperationImplementation;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class ModuleOperations
implements DeleteOperationImplementation,
MoveOrRenameOperationImplementation,
CopyOperationImplementation {
    private static final Map<String, SuiteProject> TEMPORARY_CACHE = new HashMap<String, SuiteProject>();
    private final NbModuleProject project;
    private final FileObject projectDir;

    public ModuleOperations(NbModuleProject project) {
        this.project = project;
        this.projectDir = project.getProjectDirectory();
    }

    public void notifyDeleting() throws IOException {
        this.notifyDeleting(false);
    }

    private void notifyDeleting(boolean temporary) throws IOException {
        SuiteProject suite;
        FileObject buildXML = this.projectDir.getFileObject("build.xml");
        if (buildXML != null) {
            ActionUtils.runTarget((FileObject)buildXML, (String[])new String[]{"clean"}, null).waitFinished();
        }
        if ((suite = SuiteUtils.findSuite(this.project)) != null) {
            if (temporary) {
                SuiteUtils.removeModuleFromSuite(this.project);
            } else {
                SuiteUtils.removeModuleFromSuiteWithDependencies(this.project);
            }
        }
        this.project.notifyDeleting();
    }

    public void notifyDeleted() throws IOException {
        this.project.getHelper().notifyDeleted();
    }

    public void notifyMoving() throws IOException {
        SuiteProject suite = SuiteUtils.findSuite(this.project);
        if (suite != null) {
            TEMPORARY_CACHE.put(this.project.getCodeNameBase(), suite);
        }
        this.notifyDeleting(true);
    }

    public void notifyMoved(Project original, File originalPath, String nueName) throws IOException {
        if (original == null) {
            this.project.getHelper().notifyDeleted();
        } else {
            boolean isRename;
            SuiteProject suite = TEMPORARY_CACHE.remove(this.project.getCodeNameBase());
            if (suite != null) {
                SuiteUtils.addModule(suite, this.project);
            }
            if (isRename = original.getProjectDirectory().getParent().equals(this.project.getProjectDirectory().getParent())) {
                this.setDisplayName(nueName);
            }
        }
    }

    public void notifyRenaming() throws IOException {
    }

    public void notifyRenamed(String nueName) throws IOException {
        this.setDisplayName(nueName);
    }

    public void notifyCopying() throws IOException {
        SuiteProject suite = SuiteUtils.findSuite(this.project);
        if (suite != null) {
            TEMPORARY_CACHE.put(this.project.getCodeNameBase(), suite);
            SuiteUtils.removeModuleFromSuite(this.project);
        }
    }

    public void notifyCopied(Project original, File originalPath, String nueName) throws IOException {
        if (original == null) {
            SuiteProject suite = TEMPORARY_CACHE.remove(this.project.getCodeNameBase());
            if (suite != null) {
                SuiteUtils.addModule(suite, this.project);
            }
        } else {
            this.adjustDisplayName();
        }
    }

    public List<FileObject> getMetadataFiles() {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        this.addFile("build.xml", files);
        this.addFile("manifest.mf", files);
        this.addFile("nbproject", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        Sources srcs = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] grps = srcs.getSourceGroups("java");
        for (int i = 0; i < grps.length; ++i) {
            FileObject srcRoot = grps[i].getRootFolder();
            if (srcRoot.getPath().endsWith("test/unit/src")) {
                this.addFile("test", files);
                continue;
            }
            files.add(srcRoot);
        }
        return files;
    }

    private void addFile(String fileName, List<FileObject> result) {
        FileObject file = this.projectDir.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    private void adjustDisplayName() throws IOException {
        this.setDisplayName(ProjectUtils.getInformation((Project)this.project).getDisplayName() + " (0)");
    }

    private void setDisplayName(String nueName) throws IOException {
        LocalizedBundleInfo info;
        LocalizedBundleInfo.Provider lbiProvider = (LocalizedBundleInfo.Provider)this.project.getLookup().lookup(LocalizedBundleInfo.Provider.class);
        if (lbiProvider != null && (info = lbiProvider.getLocalizedBundleInfo()) != null) {
            info.setDisplayName(nueName);
            info.store();
        }
    }

    static boolean canRun(NbModuleProject project) {
        boolean result = true;
        if (project.getTestUserDirLockFile().isFile()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleOperations.class, (String)"ERR_ModuleIsBeingRun")));
            result = false;
        }
        return result;
    }
}

