/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.HashSet;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.filters.SourceFileFilter;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AllSourceFileFilter
extends SourceFileFilter {
    private static AllSourceFileFilter instance = null;
    private static String[] suffixes = null;

    public static AllSourceFileFilter getInstance() {
        if (instance == null) {
            instance = new AllSourceFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(SourceFileFilter.class, (String)"FILECHOOSER_All_SOURCES_FILEFILTER", (Object)this.getSuffixesAsString());
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            if (FileUtil.getExtension((String)f.getPath()).length() == 0) {
                return "text/x-h".equals(MIMESupport.getFileMIMEType(f));
            }
            return super.accept(f);
        }
        return false;
    }

    @Override
    public String[] getSuffixes() {
        if (suffixes == null) {
            suffixes = this.getAllSuffixes();
        }
        return suffixes;
    }

    private String[] getAllSuffixes() {
        HashSet<String> allSuffixes = new HashSet<String>();
        allSuffixes.addAll(MIMEExtensions.get("text/x-c++").getValues());
        allSuffixes.addAll(MIMEExtensions.get("text/x-c").getValues());
        allSuffixes.addAll(MIMEExtensions.get("text/x-h").getValues());
        allSuffixes.addAll(MIMEExtensions.get("text/x-fortran").getValues());
        return allSuffixes.toArray(new String[allSuffixes.size()]);
    }
}

