/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.NbBundle;

class SearchThreadJdk12_japan
extends IndexSearchThread {
    private Reader in;
    private URL contextURL;
    private boolean stopSearch = false;
    private boolean splitedIndex = false;
    private int currentIndexNumber;
    private FileObject folder = null;
    private String JapanEncoding;
    private final Object LOCK = new Object();
    private static final String STR_CLASS = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_CLASS");
    private static final String STR_INTERFACE = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_INTERFACE");
    private static final String STR_EXCEPTION = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_EXCEPTION");
    private static final String STR_CONSTRUCTOR = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_CONSTRUCTOR");
    private static final String STR_METHOD = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_METHOD");
    private static final String STR_ERROR = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_ERROR");
    private static final String STR_VARIABLE = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_VARIABLE");
    private static final String STR_STATIC = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_STATIC");
    private static final String STR_DASH = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_DASH");
    private static final String STR_PACKAGE = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK12_PACKAGE");
    private static final String STR_ENUM = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK15_ENUM");
    private static final String STR_ANNTYPE = NbBundle.getMessage(SearchThreadJdk12_japan.class, (String)"JDK15_ANNOTATION_TYPE");
    private static final String STR_CLASS_LOC = "\u30af\u30e9\u30b9";
    private static final String STR_INTERFACE_LOC = "\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9";
    private static final String STR_EXCEPTION_LOC = "\u4f8b\u5916";
    private static final String STR_CONSTRUCTOR_LOC = "\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf";
    private static final String STR_METHOD_LOC = "\u30e1\u30bd\u30c3\u30c9";
    private static final String STR_ERROR_LOC = "\u30a8\u30e9\u30fc";
    private static final String STR_VARIABLE_LOC = "\u5909\u6570";
    private static final String STR_STATIC_LOC = "static";
    private static final String STR_DASH_LOC = "-";
    private static final String STR_PACKAGE_LOC = "\u30d1\u30c3\u30b1\u30fc\u30b8";
    private static final String STR_ENUM_LOC = "\u5217\u6319\u578b";
    private static final String STR_ANNTYPE_LOC = "\u6ce8\u91c8\u578b";
    private static final int IN_BALAST = 0;
    private static final int IN_DT = 1;
    private static final int IN_AREF = 2;
    private static final int IN_DESCRIPTION = 4;
    private static final int IN_DESCRIPTION_SUFFIX = 5;

    public SearchThreadJdk12_japan(String toFind, FileObject fo, IndexSearchThread.DocIndexItemConsumer diiConsumer, boolean caseSensitive, String JapanEncoding) {
        super(toFind, fo, diiConsumer, caseSensitive);
        this.JapanEncoding = JapanEncoding;
        if (fo.isFolder()) {
            this.folder = fo;
            this.currentIndexNumber = Character.toUpperCase(this.lastField.charAt(0)) - 65 + 1;
            if (this.currentIndexNumber < 1) {
                this.currentIndexNumber = 1;
            } else if (this.currentIndexNumber > 26) {
                this.currentIndexNumber = 27;
            }
            this.findFileObject(0);
            this.splitedIndex = true;
        } else {
            try {
                this.contextURL = this.indexRoot.getURL();
            }
            catch (FileStateInvalidException e) {
                throw new InternalError("Can't create documentation folder URL - file state invalid");
            }
            this.splitedIndex = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopSearch() {
        Reader br;
        Object object = this.LOCK;
        synchronized (object) {
            this.stopSearch = true;
            br = this.in;
        }
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ParserDelegator pd = new ParserDelegator();
        if (this.indexRoot == null || this.lastField == null || this.lastField.length() == 0) {
            this.taskFinished();
            return;
        }
        SearchCallbackJdk12_japan sc = null;
        int theDirection = 0;
        do {
            if (sc != null) {
                if (sc.badFile != theDirection) break;
                this.findFileObject(sc.badFile);
                if (this.indexRoot == null) break;
            }
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    if (this.stopSearch) {
                        break;
                    }
                    this.in = new BufferedReader(new InputStreamReader(this.indexRoot.getInputStream(), this.JapanEncoding));
                }
                sc = new SearchCallbackJdk12_japan(this.splitedIndex, this.caseSensitive);
                pd.parse(this.in, sc, true);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (sc.badFile == 0 || theDirection != 0) continue;
            theDirection = sc.badFile;
        } while (sc.badFile != 0);
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.taskFinished();
    }

    private void findFileObject(int direction) {
        if (direction < 0) {
            --this.currentIndexNumber;
        } else if (direction > 0) {
            ++this.currentIndexNumber;
        }
        do {
            if (this.currentIndexNumber < 0 || this.currentIndexNumber > 27) {
                this.indexRoot = null;
                return;
            }
            String fileName = "index-" + this.currentIndexNumber;
            if (this.folder == null) {
                this.indexRoot = null;
                return;
            }
            this.indexRoot = this.folder.getFileObject(fileName, "html");
            if (this.indexRoot != null) {
                try {
                    this.contextURL = this.indexRoot.getURL();
                }
                catch (FileStateInvalidException e) {
                    throw new InternalError("Can't create documentation folder URL - file state invalid");
                }
            } else {
                this.currentIndexNumber += direction > 0 ? 1 : -1;
            }
        } while (this.indexRoot == null);
    }

    private class SearchCallbackJdk12_japan
    extends HTMLEditorKit.ParserCallback {
        private String hrefVal;
        private DocIndexItem currentDii = null;
        private int where = 0;
        private boolean splited;
        private boolean stopOnNext = false;
        private int badFile = 0;
        int printText = 0;

        SearchCallbackJdk12_japan(boolean splited, boolean caseSensitive) {
            this.splited = splited;
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.DT) {
                this.where = 1;
                this.currentDii = null;
            } else if (t == HTML.Tag.A && this.where == 1) {
                this.where = 2;
                Object val = a.getAttribute(HTML.Attribute.HREF);
                if (val != null) {
                    this.hrefVal = val.toString();
                    this.currentDii = new DocIndexItem(null, null, SearchThreadJdk12_japan.this.contextURL, this.hrefVal);
                }
            } else if (t != HTML.Tag.A || this.where != 5 && this.where != 4) {
                this.where = t == HTML.Tag.B && this.where == 2 ? 2 : 0;
            }
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            if (t == HTML.Tag.DT && this.where != 0) {
                this.where = 0;
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            if (this.where == 2) {
                char curr;
                char first;
                if (this.stopOnNext) {
                    try {
                        SearchThreadJdk12_japan.this.in.close();
                        this.where = 0;
                        return;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                String text = new String(data);
                if (this.splited && (first = Character.toUpperCase(SearchThreadJdk12_japan.this.lastField.charAt(0))) != (curr = Character.toUpperCase(data[0]))) {
                    this.badFile = first < curr ? -1 : 1;
                    try {
                        SearchThreadJdk12_japan.this.in.close();
                        this.where = 0;
                        return;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                this.currentDii.setField(text.trim());
                this.where = 4;
            } else if (this.where == 4) {
                String token;
                String text = new String(data);
                int dashIdx = text.indexOf(STR_DASH);
                if (dashIdx < 0) {
                    return;
                }
                text = text.substring(dashIdx - 1);
                this.currentDii.setRemark(text);
                StringTokenizer st = new StringTokenizer(text);
                boolean isStatic = false;
                try {
                    token = st.nextToken();
                    if (token.equals(STR_DASH)) {
                        token = st.nextToken();
                    }
                    if (token.equalsIgnoreCase(STR_STATIC)) {
                        isStatic = true;
                        token = st.nextToken();
                    }
                }
                catch (NoSuchElementException ex) {
                    this.where = 5;
                    return;
                }
                if (token.equalsIgnoreCase(STR_CLASS)) {
                    this.currentDii.setIconIndex(2);
                } else if (token.equalsIgnoreCase(STR_INTERFACE)) {
                    this.currentDii.setIconIndex(3);
                } else if (token.equalsIgnoreCase(STR_ENUM)) {
                    this.currentDii.setIconIndex(4);
                } else if (token.equalsIgnoreCase(STR_ANNTYPE)) {
                    this.currentDii.setIconIndex(5);
                } else if (token.equalsIgnoreCase(STR_EXCEPTION)) {
                    this.currentDii.setIconIndex(6);
                } else if (token.equalsIgnoreCase(STR_ERROR)) {
                    this.currentDii.setIconIndex(7);
                } else if (token.equalsIgnoreCase(STR_PACKAGE)) {
                    this.currentDii.setIconIndex(1);
                } else if (token.equalsIgnoreCase(STR_CONSTRUCTOR)) {
                    this.currentDii.setIconIndex(8);
                } else if (token.equalsIgnoreCase(STR_METHOD)) {
                    this.currentDii.setIconIndex(isStatic ? 10 : 9);
                } else if (token.equalsIgnoreCase(STR_VARIABLE)) {
                    this.currentDii.setIconIndex(isStatic ? 12 : 11);
                }
                if (this.currentDii.getPackage() != null) {
                    this.where = 5;
                } else if (text.endsWith(".")) {
                    this.where = 5;
                    this.currentDii.setPackage(text.substring(text.lastIndexOf(32)).trim());
                } else {
                    this.where = 0;
                }
            } else if (this.where == 5) {
                boolean isStatic = false;
                String remark = String.valueOf(data);
                if (remark.contains(SearchThreadJdk12_japan.STR_STATIC_LOC)) {
                    isStatic = true;
                }
                if (remark.contains(SearchThreadJdk12_japan.STR_CLASS_LOC)) {
                    this.currentDii.setIconIndex(2);
                } else if (remark.contains(SearchThreadJdk12_japan.STR_INTERFACE_LOC)) {
                    this.currentDii.setIconIndex(3);
                } else if (remark.contains(SearchThreadJdk12_japan.STR_ENUM_LOC)) {
                    this.currentDii.setIconIndex(4);
                } else if (remark.contains(SearchThreadJdk12_japan.STR_ANNTYPE_LOC)) {
                    this.currentDii.setIconIndex(5);
                } else if (remark.contains(SearchThreadJdk12_japan.STR_EXCEPTION_LOC)) {
                    this.currentDii.setIconIndex(6);
                } else if (remark.contains(SearchThreadJdk12_japan.STR_ERROR_LOC)) {
                    this.currentDii.setIconIndex(7);
                } else if (remark.contains(SearchThreadJdk12_japan.STR_PACKAGE_LOC)) {
                    this.currentDii.setIconIndex(1);
                } else if (remark.contains(SearchThreadJdk12_japan.STR_CONSTRUCTOR_LOC)) {
                    this.currentDii.setIconIndex(8);
                } else if (remark.contains(SearchThreadJdk12_japan.STR_METHOD_LOC)) {
                    this.currentDii.setIconIndex(isStatic ? 10 : 9);
                } else if (remark.contains(SearchThreadJdk12_japan.STR_VARIABLE_LOC)) {
                    this.currentDii.setIconIndex(isStatic ? 12 : 11);
                }
                this.currentDii.setRemark(this.currentDii.getRemark() + remark);
                String declaringClass = remark.trim();
                if (!".".equals(declaringClass) && this.currentDii.getDeclaringClass() == null) {
                    this.currentDii.setDeclaringClass(declaringClass);
                    SearchThreadJdk12_japan.this.insertDocIndexItem(this.currentDii);
                }
            } else {
                this.where = 0;
            }
        }
    }
}

