/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXBusyLabel;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatPanel;
import org.netbeans.modules.kenai.collab.chat.ContactList;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.awt.Mnemonics;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ChatTopComponent
extends TopComponent {
    private static final String KENAI_OPEN_CHATS_PREF = ".open.chats.";
    private static ChatTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/kenai/collab/resources/chat.png";
    static final String PLUS = "org/netbeans/modules/kenai/collab/resources/plus.png";
    private static final String PREFERRED_ID = "ChatTopComponent";
    private HashSet<String> open = new HashSet();
    private final Preferences prefs = NbPreferences.forModule(ChatTopComponent.class);
    private final JPanel chatsPanel = new JPanel(){

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    };
    private boolean initInProgress = false;
    private JTabbedPane chats;
    private ContactList contactList;
    private JPanel errorScreen;
    private JLabel initLabel;
    private JPanel initPanel;
    private JLabel lblXmppError;
    private JLabel loginLink;
    private JPanel loginScreen;
    private JLabel retryLink;

    public void reconnect(final KenaiConnection kec) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                KenaiConnection kenaiConnection = kec;
                synchronized (kenaiConnection) {
                    try {
                        kec.reconnect(null);
                    }
                    catch (XMPPException ex) {
                        Logger.getLogger(ChatTopComponent.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                    }
                }
                if (kec.isConnected()) {
                    ChatTopComponent.this.putChatsScreen(kec);
                } else if (kec.isConnectionFailed()) {
                    ChatTopComponent.this.putErrorScreen();
                } else {
                    ChatTopComponent.this.putLoginScreen();
                }
            }
        });
    }

    public void requestActive() {
        this.requestActive(true);
    }

    void requestActive(final boolean b) {
        super.requestActive();
        Component c = this.chats.getSelectedComponent();
        if (c != null) {
            c.requestFocus();
        }
        if (this.chats.getTabCount() == 1 && b) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ChatTopComponent.this.chats.getTabCount() != 1 || !b || ChatTopComponent.this.chats.isShowing()) {
                        // empty if block
                    }
                }
            });
        }
    }

    private ChatTopComponent() {
        this.initComponents();
        this.clearChatsTabbedPane();
        this.contactList.putClientProperty("noCloseButton", Boolean.TRUE);
        this.setName(NbBundle.getMessage(ChatTopComponent.class, (String)"CTL_ChatTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ChatTopComponent.class, (String)"HINT_ChatTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        OverlayLayout overlay = new OverlayLayout(this.chatsPanel);
        this.chatsPanel.setLayout(overlay);
        this.chats.setAlignmentX(0.0f);
        this.chats.setAlignmentY(0.0f);
        this.chatsPanel.add(this.chats);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int index = ChatTopComponent.this.chats.getSelectedIndex();
                if (index >= 0) {
                    String name;
                    ChatTopComponent.this.chats.setForegroundAt(index, Color.BLACK);
                    if (!ChatTopComponent.this.initInProgress && (name = ChatTopComponent.this.chats.getComponentAt(index).getName()) != null) {
                        ChatNotifications notifications = ChatNotifications.getDefault();
                        notifications.removeGroup(name);
                        notifications.removePrivate(name);
                    }
                    ChatTopComponent.this.chats.getComponentAt(index).requestFocus();
                }
            }
        };
        KenaiManager.getDefault().addPropertyChangeListener((PropertyChangeListener)new KenaiL());
        this.chats.addChangeListener(changeListener);
        this.chats.addPropertyChangeListener("close", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("close".equals(evt.getPropertyName()) && evt.getNewValue() instanceof ChatPanel) {
                    ChatTopComponent.this.removeChat((ChatPanel)evt.getNewValue());
                }
            }
        });
        boolean chatsdone = false;
        boolean failed = false;
        for (KenaiConnection kec : KenaiConnection.getAllInstances()) {
            if (kec.isConnected()) {
                this.putChatsScreen(kec);
                chatsdone = true;
            }
            if (!kec.isConnectionFailed()) continue;
            failed = true;
        }
        if (!chatsdone && failed) {
            this.putErrorScreen();
        } else if (!chatsdone) {
            this.putLoginScreen();
        }
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.chats.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.chats.setOpaque(true);
        }
    }

    private void putChatsScreen(final KenaiConnection kec) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ChatTopComponent.this.removeAll();
                ChatTopComponent.this.add(ChatTopComponent.this.chatsPanel, "Center");
                ChatTopComponent.this.putChats(kec);
                ChatTopComponent.this.contactList.updateFilter();
                ChatTopComponent.this.validate();
                ChatTopComponent.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void clearChatsTabbedPane() {
        this.chats.removeAll();
        this.addMoreChatsTab(0);
    }

    private void addMoreChatsTab(int index) {
        this.chats.add(this.contactList);
        this.chats.setTitleAt(0, "");
        this.chats.setIconAt(index, ImageUtilities.loadImageIcon((String)PLUS, (boolean)true));
        this.chats.setToolTipTextAt(index, NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_MoreChats"));
    }

    private void putLoginScreen() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ChatTopComponent.this.removeAll();
                ChatTopComponent.this.clearChatsTabbedPane();
                ChatTopComponent.this.open.clear();
                ChatTopComponent.this.add(ChatTopComponent.this.loginScreen, "Center");
                ChatTopComponent.this.validate();
                ChatTopComponent.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void putErrorScreen() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ChatTopComponent.this.removeAll();
                ChatTopComponent.this.clearChatsTabbedPane();
                ChatTopComponent.this.open.clear();
                ChatTopComponent.this.add(ChatTopComponent.this.errorScreen, "Center");
                ChatTopComponent.this.validate();
                ChatTopComponent.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void putConnectingScreen() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ChatTopComponent.this.removeAll();
                ChatTopComponent.this.clearChatsTabbedPane();
                ChatTopComponent.this.open.clear();
                ((JXBusyLabel)ChatTopComponent.this.initLabel).setBusy(true);
                ChatTopComponent.this.add(ChatTopComponent.this.initPanel, "Center");
                ChatTopComponent.this.validate();
                ChatTopComponent.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private int getTab(String name) {
        for (int i = 0; i < this.chats.getTabCount(); ++i) {
            if (!name.equals(this.chats.getComponentAt(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public void setActiveGroup(String name) {
        Utilities.assertJid(name);
        ChatNotifications.getDefault().removeGroup(name);
        int indexOfTab = this.getTab(name);
        if (indexOfTab < 0) {
            MultiUserChat muc = KenaiConnection.getDefault(KenaiConnection.getKenai(name)).getChat(StringUtils.parseName((String)name));
            if (muc != null) {
                ChatPanel chatPanel = new ChatPanel(muc);
                this.addChat(chatPanel);
                indexOfTab = this.chats.getTabCount() - 1;
                this.chats.setSelectedComponent(chatPanel);
            }
        } else {
            this.chats.setSelectedIndex(indexOfTab);
        }
    }

    public void setActivePrivate(String name) {
        Utilities.assertJid(name);
        ChatNotifications.getDefault().removePrivate(name);
        int indexOfTab = this.getTab(name);
        if (indexOfTab < 0) {
            ChatPanel chatPanel = new ChatPanel(name);
            this.addChat(chatPanel);
            indexOfTab = this.chats.getTabCount() - 1;
            this.chats.setSelectedComponent(chatPanel);
        } else {
            this.chats.setSelectedIndex(indexOfTab);
        }
    }

    public void insertToActiveChat(String message) {
        Component selectedComponent = this.chats.getSelectedComponent();
        if (selectedComponent instanceof ChatPanel) {
            ChatPanel chatPanel = (ChatPanel)selectedComponent;
            chatPanel.insertToInputArea(message);
        }
    }

    public void addChat(ChatPanel chatPanel) {
        int idx = this.chats.getTabCount();
        this.chats.add(chatPanel);
        try {
            if (!chatPanel.isPrivate()) {
                Kenai k = KenaiConnection.getKenai(chatPanel.getName());
                this.chats.setTitleAt(idx, k.getProject(chatPanel.getShortName()).getDisplayName());
            } else {
                this.chats.setTitleAt(idx, new KenaiUserUI(chatPanel.getName()).getUserName());
            }
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!chatPanel.isPrivate()) {
            this.open.add(chatPanel.getName());
            this.storeOpenChats();
        }
        this.chats.setSelectedComponent(chatPanel);
        this.validate();
    }

    void removeChat(ChatPanel chatPanel) {
        int index = this.chats.indexOfComponent(chatPanel);
        assert (index >= 0) : "Component not found in CloseButtonTabbedPane " + chatPanel;
        this.open.remove(chatPanel.getName());
        this.chats.remove(chatPanel);
        if (this.chats.getSelectedIndex() == this.chats.getTabCount() - 1 && this.chats.getTabCount() > 1) {
            this.chats.setSelectedIndex(this.chats.getSelectedIndex() - 1);
        }
        chatPanel.leave();
        this.validate();
        this.storeOpenChats();
    }

    void setModified(ChatPanel panel) {
        int i = this.chats.indexOfComponent(panel);
        this.chats.setForegroundAt(i, Color.BLUE);
    }

    public static boolean isGroupInitedAndVisible(String name) {
        Utilities.assertJid(name);
        return instance == null ? false : instance.isShowing() && instance.isOpened() && ChatTopComponent.instance.open.contains(name) && name.equals(ChatTopComponent.instance.chats.getSelectedComponent().getName());
    }

    public static boolean isPrivateInitedAndVisible(String name) {
        Utilities.assertJid(name);
        return instance == null ? false : instance.isShowing() && instance.isOpened() && name.equals(ChatTopComponent.instance.chats.getSelectedComponent().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putChats(KenaiConnection kec) {
        this.initInProgress = true;
        try {
            String s;
            List<MultiUserChat> chs = kec.getChats();
            if (chs.size() == 1) {
                MultiUserChat next = (MultiUserChat)chs.iterator().next();
                ChatPanel chatPanel = new ChatPanel(next);
                this.addChat(chatPanel);
            } else if (chs.size() != 0 && (s = this.prefs.get(kec.getKenai().getUrl().getHost() + KENAI_OPEN_CHATS_PREF + kec.getKenai().getPasswordAuthentication().getUserName(), "")).length() > 1) {
                Component chatPanel = null;
                for (String chat : s.split(",")) {
                    MultiUserChat muc = kec.getChat(chat);
                    if (muc != null) {
                        chatPanel = new ChatPanel(muc);
                        this.addChat((ChatPanel)chatPanel);
                        continue;
                    }
                    Logger.getLogger(ChatTopComponent.class.getName()).warning("Cannot find chat " + chat);
                }
                if (chatPanel != null) {
                    ChatNotifications.getDefault().removeGroup(chatPanel.getName());
                }
            }
            this.validate();
        }
        finally {
            this.initInProgress = false;
        }
    }

    private void initComponents() {
        this.chats = TabbedPaneFactory.createCloseButtonTabbedPane();
        this.contactList = new ContactList();
        this.loginScreen = new JPanel();
        this.loginLink = new JLabel();
        this.errorScreen = new JPanel();
        this.lblXmppError = new JLabel();
        this.retryLink = new JLabel();
        this.initPanel = new JPanel();
        this.initLabel = new JXBusyLabel(new Dimension(16, 16));
        this.chats.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChatTopComponent.this.chatsMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ChatTopComponent.this.chatsMousePressed(evt);
            }
        });
        this.chats.addTab(NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.contactList.TabConstraints.tabTitle", (Object[])new Object[0]), this.contactList);
        this.loginScreen.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.loginLink.setForeground(Color.blue);
        Mnemonics.setLocalizedText((JLabel)this.loginLink, (String)NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.loginLink.text"));
        this.loginLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChatTopComponent.this.loginLinkMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ChatTopComponent.this.loginLinkMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ChatTopComponent.this.loginLinkMouseExited(evt);
            }
        });
        GroupLayout loginScreenLayout = new GroupLayout((Container)this.loginScreen);
        this.loginScreen.setLayout((LayoutManager)loginScreenLayout);
        loginScreenLayout.setHorizontalGroup((GroupLayout.Group)loginScreenLayout.createParallelGroup(1).add((GroupLayout.Group)loginScreenLayout.createSequentialGroup().add(4, 4, 4).add((Component)this.loginLink).addContainerGap(194, Short.MAX_VALUE)));
        loginScreenLayout.setVerticalGroup((GroupLayout.Group)loginScreenLayout.createParallelGroup(1).add((GroupLayout.Group)loginScreenLayout.createSequentialGroup().add(4, 4, 4).add((Component)this.loginLink).addContainerGap(414, Short.MAX_VALUE)));
        this.errorScreen.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        Mnemonics.setLocalizedText((JLabel)this.lblXmppError, (String)NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.lblXmppError.text"));
        Mnemonics.setLocalizedText((JLabel)this.retryLink, (String)NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.retryLink.text"));
        this.retryLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChatTopComponent.this.retryLinkMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ChatTopComponent.this.retryLinkMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ChatTopComponent.this.retryLinkMouseExited(evt);
            }
        });
        GroupLayout errorScreenLayout = new GroupLayout((Container)this.errorScreen);
        this.errorScreen.setLayout((LayoutManager)errorScreenLayout);
        errorScreenLayout.setHorizontalGroup((GroupLayout.Group)errorScreenLayout.createParallelGroup(1).add((GroupLayout.Group)errorScreenLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.lblXmppError).addPreferredGap(0).add((Component)this.retryLink).addContainerGap(31, Short.MAX_VALUE)));
        errorScreenLayout.setVerticalGroup((GroupLayout.Group)errorScreenLayout.createParallelGroup(1).add((GroupLayout.Group)errorScreenLayout.createSequentialGroup().add(5, 5, 5).add((GroupLayout.Group)errorScreenLayout.createParallelGroup(3).add((Component)this.lblXmppError).add((Component)this.retryLink)).addContainerGap(413, Short.MAX_VALUE)));
        this.setLayout(new BorderLayout());
        this.initPanel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        Mnemonics.setLocalizedText((JLabel)this.initLabel, (String)NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.initLabel.text"));
        GroupLayout initPanelLayout = new GroupLayout((Container)this.initPanel);
        this.initPanel.setLayout((LayoutManager)initPanelLayout);
        initPanelLayout.setHorizontalGroup((GroupLayout.Group)initPanelLayout.createParallelGroup(1).add((GroupLayout.Group)initPanelLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.initLabel).addContainerGap(292, Short.MAX_VALUE)));
        initPanelLayout.setVerticalGroup((GroupLayout.Group)initPanelLayout.createParallelGroup(1).add((GroupLayout.Group)initPanelLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.initLabel).addContainerGap(279, Short.MAX_VALUE)));
        this.add(this.initPanel, "Center");
    }

    private void retryLinkMouseClicked(MouseEvent evt) {
        this.reconnect(null);
    }

    private void retryLinkMouseEntered(MouseEvent evt) {
        this.retryLink.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void retryLinkMouseExited(MouseEvent evt) {
        this.retryLink.setCursor(Cursor.getDefaultCursor());
    }

    private void chatsMouseClicked(MouseEvent evt) {
        int tab = this.chats.getUI().tabForCoordinate(this.chats, evt.getX(), evt.getY());
        if (tab == this.chats.getTabCount() - 1) {
            // empty if block
        }
    }

    private void loginLinkMouseExited(MouseEvent evt) {
        this.loginLink.setCursor(Cursor.getDefaultCursor());
    }

    private void loginLinkMouseEntered(MouseEvent evt) {
        this.loginLink.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void loginLinkMouseClicked(MouseEvent evt) {
        final Kenai kenai = Utilities.getPreferredKenai();
        if (kenai == null || kenai.getStatus() == Kenai.Status.OFFLINE) {
            UIUtils.showLogin();
        } else if (!Utilities.isChatSupported(kenai)) {
            JOptionPane.showMessageDialog(this.retryLink, NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.ChatNotAvailable", (Object)kenai.getName()));
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        PasswordAuthentication passwordAuthentication = kenai.getPasswordAuthentication();
                        kenai.login(passwordAuthentication.getUserName(), passwordAuthentication.getPassword(), true);
                    }
                    catch (KenaiException ex) {
                        if (!Utilities.isChatSupported(kenai, true)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(ChatTopComponent.this.retryLink, NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.ChatNotAvailable", (Object)kenai.getName()));
                                }
                            });
                        }
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    private void chatsMousePressed(MouseEvent evt) {
        int tab = this.chats.getUI().tabForCoordinate(this.chats, evt.getX(), evt.getY());
        if (tab != 0 && evt.isPopupTrigger()) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new Close());
            if (this.chats.getTabCount() > 2) {
                menu.add(new CloseAll());
                menu.add(new CloseAllButCurrent());
            }
            menu.show((Component)evt.getSource(), evt.getX(), evt.getY());
        }
    }

    public static synchronized ChatTopComponent getDefault() {
        if (instance == null) {
            instance = new ChatTopComponent();
        }
        return instance;
    }

    public static synchronized ChatTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ChatTopComponent.class.getName()).warning("Cannot find ChatTopComponent component. It will not be located properly in the window system.");
            return ChatTopComponent.getDefault();
        }
        if (win instanceof ChatTopComponent) {
            return (ChatTopComponent)win;
        }
        Logger.getLogger(ChatTopComponent.class.getName()).warning("There seem to be multiple components with the 'ChatTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ChatTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static void refreshContactList() {
        if (instance != null && ChatTopComponent.instance.contactList != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    instance.contactList.updateContacts();
                    instance.repaint();
                }
            });
        }
    }

    void switchToContactList() {
        this.chats.setSelectedIndex(0);
    }

    private void storeOpenChats() {
        HashMap<Kenai, StringBuffer> hm = new HashMap<Kenai, StringBuffer>();
        for (String i : this.open) {
            Kenai k = KenaiConnection.getKenai(i);
            StringBuffer b = (StringBuffer)hm.get(k);
            if (b == null) {
                b = new StringBuffer();
                hm.put(k, b);
            }
            b.append(StringUtils.parseName((String)i));
            b.append(",");
        }
        for (Kenai k : KenaiManager.getDefault().getKenais()) {
            if (k.getStatus() != Kenai.Status.ONLINE) continue;
            String key = k.getUrl().getHost() + KENAI_OPEN_CHATS_PREF + k.getPasswordAuthentication().getUserName();
            StringBuffer value = (StringBuffer)hm.get(k);
            value = value == null ? new StringBuffer() : new StringBuffer(value.subSequence(0, value.length() - 1));
            this.prefs.put(key, value.toString());
        }
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_CloseAllButCurrent"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Component c : ChatTopComponent.this.chats.getComponents()) {
                if (!(c instanceof ChatPanel) || c.isShowing()) continue;
                ChatTopComponent.this.removeChat((ChatPanel)c);
            }
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_CloseAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Component c : ChatTopComponent.this.chats.getComponents()) {
                if (!(c instanceof ChatPanel)) continue;
                ChatTopComponent.this.removeChat((ChatPanel)c);
            }
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_CloseWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChatPanel panel = (ChatPanel)ChatTopComponent.this.chats.getSelectedComponent();
            ChatTopComponent.this.removeChat(panel);
        }
    }

    final class KenaiL
    implements PropertyChangeListener {
        KenaiL() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            if ("login".equals(e.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Kenai.Status s = ((Kenai)e.getSource()).getStatus();
                        if (s != Kenai.Status.ONLINE) {
                            ChatTopComponent.this.loginLink.setText(NbBundle.getMessage(ChatTopComponent.class, (String)(s == Kenai.Status.OFFLINE ? "ChatTopComponent.loginLink.text" : "ChatTopComponent.loginLink.startChat")));
                        }
                    }
                });
            } else if ("xmpp_login".equals(e.getPropertyName())) {
                if (e.getNewValue() == null) {
                    for (Kenai k : KenaiManager.getDefault().getKenais()) {
                        if (k.getStatus() != Kenai.Status.ONLINE) continue;
                        ChatTopComponent.this.contactList.updateContacts();
                        return;
                    }
                    ChatTopComponent.this.putLoginScreen();
                } else {
                    final KenaiConnection kec = KenaiConnection.getDefault((Kenai)e.getSource());
                    kec.post(new Runnable(){

                        @Override
                        public void run() {
                            if (kec.isConnectionFailed()) {
                                ChatTopComponent.this.putErrorScreen();
                            } else {
                                kec.getMyChats();
                                ChatTopComponent.this.putChatsScreen(kec);
                            }
                        }
                    });
                }
            } else if ("xmpp_login_started".equals(e.getPropertyName())) {
                ChatTopComponent.this.putConnectingScreen();
            } else if ("xmpp_login_failed".equals(e.getPropertyName())) {
                ChatTopComponent.this.putLoginScreen();
            }
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ChatTopComponent.getDefault();
        }
    }
}

