/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.kenai.ui.KenaiCheckListRenderer;

public class CheckListSupport
extends MouseAdapter
implements ListSelectionListener,
ActionListener {
    private ListSelectionModel sModel = new DefaultListSelectionModel();
    private JList list = new JList();
    private int checkBoxWidth;

    public CheckListSupport(JList list) {
        this.checkBoxWidth = new JCheckBox().getPreferredSize().width;
        this.list = list;
        list.setCellRenderer(new KenaiCheckListRenderer(list.getCellRenderer(), this.sModel));
        list.registerKeyboardAction(this, KeyStroke.getKeyStroke(32, 0), 0);
        list.addMouseListener(this);
        this.sModel.addListSelectionListener(this);
    }

    public ListSelectionModel getSelectionModel() {
        return this.sModel;
    }

    private void select(int index) {
        if (index < 0) {
            return;
        }
        if (this.sModel.isSelectedIndex(index)) {
            this.sModel.removeSelectionInterval(index, index);
        } else {
            this.sModel.addSelectionInterval(index, index);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        int index = this.list.locationToIndex(me.getPoint());
        if (index < 0) {
            return;
        }
        if (me.getX() > this.list.getCellBounds((int)index, (int)index).x + this.checkBoxWidth) {
            return;
        }
        this.select(index);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.list.repaint(this.list.getCellBounds(e.getFirstIndex(), e.getLastIndex()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.select(this.list.getSelectedIndex());
    }
}

