/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.NameAndLicenseWizardPanel;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.SourceAndIssuesWizardPanel;
import org.netbeans.modules.kenai.ui.SummaryWizardPanel;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NewKenaiProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private transient int index;
    private Node[] activeNodes;
    public static final String PROP_PRJ_NAME = "projectName";
    public static final String PROP_PRJ_TITLE = "projectTitle";
    public static final String PROP_PRJ_DESC = "projectDescription";
    public static final String PROP_PRJ_LICENSE = "projectLicense";
    public static final String PROP_SCM_TYPE = "projectSCMType";
    public static final String PROP_SCM_NAME = "projectSCMName";
    public static final String PROP_SCM_URL = "projectSCMUrl";
    public static final String PROP_SCM_LOCAL = "projectSCMLocal";
    public static final String PROP_SCM_PREVIEW = "projectSCMPreview";
    public static final String PROP_ISSUES = "projectIssues";
    public static final String PROP_ISSUES_URL = "projectIssuesUrl";
    public static final String PROP_AUTO_COMMIT = "projectAutoCommit";
    public static final String PROP_CREATE_CHAT = "projectCreateChat";
    public static final String PROP_FOLDERS_TO_SHARE = "projectFoldersToShare";
    public static final String PROP_EXC_ERR_MSG = "exceptionErrorMessage";
    public static final String NO_REPO = "none";
    public static final String NO_ISSUES = "none";
    private Kenai kenai;
    private Logger logger = Logger.getLogger("org.netbeans.modules.kenai");

    NewKenaiProjectWizardIterator(Node[] activatedNodes, Kenai kenai) {
        this.activeNodes = activatedNodes != null ? activatedNodes : new Node[]{};
        this.kenai = kenai;
    }

    public Set<CreatedProjectInfo> instantiate(ProgressHandle handle) throws IOException {
        String description;
        String displayName;
        handle.start(6);
        String newPrjName = (String)this.wizard.getProperty(PROP_PRJ_NAME);
        String newPrjTitle = (String)this.wizard.getProperty(PROP_PRJ_TITLE);
        String newPrjDesc = (String)this.wizard.getProperty(PROP_PRJ_DESC);
        String newPrjLicense = (String)this.wizard.getProperty(PROP_PRJ_LICENSE);
        String newPrjScmType = (String)this.wizard.getProperty(PROP_SCM_TYPE);
        String newPrjScmName = (String)this.wizard.getProperty(PROP_SCM_NAME);
        String newPrjScmUrl = (String)this.wizard.getProperty(PROP_SCM_URL);
        String newPrjScmLocal = (String)this.wizard.getProperty(PROP_SCM_LOCAL);
        String newPrjIssues = (String)this.wizard.getProperty(PROP_ISSUES);
        String newPrjIssuesUrl = (String)this.wizard.getProperty(PROP_ISSUES_URL);
        boolean autoCommit = Boolean.valueOf((String)this.wizard.getProperty(PROP_AUTO_COMMIT));
        Boolean createChat = (Boolean)this.wizard.getProperty(PROP_CREATE_CHAT);
        List sharedItems = (List)this.wizard.getProperty(PROP_FOLDERS_TO_SHARE);
        if ("mercurial".equals(newPrjScmType) && !Mercurial.isClientAvailable()) {
            ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.NoHgClient"));
            throw new IOException("Mercurial client is not available");
        }
        if ("subversion".equals(newPrjScmType) && !Subversion.isClientAvailable((boolean)autoCommit)) {
            ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, "SVN client unavailable");
            throw new IOException("SVN client unavailable");
        }
        try {
            handle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.creatingProject"), 1);
            this.logger.log(Level.FINE, "Creating Kenai Project - Name: " + newPrjName + ", Title: " + newPrjTitle + ", Description: " + newPrjDesc + ", License: " + newPrjLicense);
            this.kenai.createProject(newPrjName, newPrjTitle, newPrjDesc, new String[]{newPrjLicense}, null);
        }
        catch (KenaiException kex) {
            String errorMsg = this.getErrorMessage(kex, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.projectCreationFailed"));
            ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, errorMsg);
            throw new IOException(errorMsg);
        }
        boolean repoCreated = false;
        if (!"none".equals(newPrjScmType)) {
            try {
                handle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.creatingRepo"), 2);
                displayName = this.getScmDisplayName(newPrjScmType);
                description = this.getScmDescription(newPrjScmType);
                String extScmUrl = "external_repository".equals(newPrjScmType) ? newPrjScmUrl : null;
                this.logger.log(Level.FINE, "Creating SCM Repository - Name: " + newPrjScmName + ", Type: " + newPrjScmType + ", Ext. URL: " + newPrjScmUrl + ", Local Folder: " + newPrjScmLocal);
                this.kenai.getProject(newPrjName).createProjectFeature(newPrjScmName, displayName, description, newPrjScmType, null, extScmUrl, null);
                repoCreated = "subversion".equals(newPrjScmType) || "mercurial".equals(newPrjScmType);
            }
            catch (KenaiException kex) {
                String errorMsg = this.getErrorMessage(kex, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repoCreationFailed"));
                ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, errorMsg);
                throw new IOException(errorMsg);
            }
        } else {
            this.logger.log(Level.FINE, "SCM Repository creation skipped.");
        }
        if (!"none".equals(newPrjIssues)) {
            try {
                handle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.creatingIssues"), 3);
                displayName = this.getIssuesDisplayName(newPrjIssues);
                description = this.getIssuesDescription(newPrjIssues);
                String extIssuesUrl = "external_issues".equals(newPrjIssues) ? newPrjIssuesUrl : null;
                this.logger.log(Level.FINE, "Creating Issue Tracking - Name: " + newPrjIssues + ", Ext. URL: " + newPrjIssuesUrl);
                this.kenai.getProject(newPrjName).createProjectFeature(newPrjName + newPrjIssues, displayName, description, newPrjIssues, extIssuesUrl, null, null);
            }
            catch (KenaiException kex) {
                String errorMsg = this.getErrorMessage(kex, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.issuesCreationFailed"));
                ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, errorMsg);
                throw new IOException(errorMsg);
            }
        } else {
            this.logger.log(Level.FINE, "Issue Tracking creation skipped.");
        }
        if (repoCreated) {
            try {
                KenaiFeature[] features = this.kenai.getProject(newPrjName).getFeatures(KenaiService.Type.SOURCE);
                String scmLoc = null;
                String featureService = null;
                for (KenaiFeature feature : features) {
                    if (!newPrjScmName.equals(feature.getName())) continue;
                    scmLoc = feature.getLocation();
                    featureService = feature.getService();
                }
                if (scmLoc != null) {
                    handle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repositoryCheckout"), 4);
                    this.logger.log(Level.FINE, "Checking out repository - Location: " + scmLoc + ", Local Folder: " + newPrjScmLocal + ", Service: " + featureService);
                    PasswordAuthentication passwdAuth = this.kenai.getPasswordAuthentication();
                    if (passwdAuth != null) {
                        String initialRevision;
                        File localScmRoot = new File(newPrjScmLocal);
                        boolean inPlaceRepository = NewKenaiProjectWizardIterator.isCommonParent(sharedItems, newPrjScmLocal);
                        if ("subversion".equals(featureService)) {
                            if (!inPlaceRepository) {
                                this.copySharedItems(sharedItems, localScmRoot);
                            }
                            Subversion.checkoutRepositoryFolder((String)scmLoc, (String[])new String[]{"."}, (File)localScmRoot, (String)passwdAuth.getUserName(), (String)new String(passwdAuth.getPassword()), (boolean)true, (boolean)false);
                            if (autoCommit) {
                                initialRevision = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.initialRevision", (Object)newPrjTitle);
                                handle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repositoryCommit"), 5);
                                Subversion.commit((File[])new File[]{localScmRoot}, (String)passwdAuth.getUserName(), (String)new String(passwdAuth.getPassword()), (String)initialRevision);
                            }
                        } else {
                            if (inPlaceRepository) {
                                File tempFolder = NewKenaiProjectWizardIterator.createTempFolder();
                                Mercurial.cloneRepository((String)scmLoc, (File)tempFolder, (String)localScmRoot.getName(), (String)"", (String)"", (String)passwdAuth.getUserName(), (String)new String(passwdAuth.getPassword()), (boolean)false);
                                this.copy(FileUtil.toFileObject((File)new File(tempFolder, localScmRoot.getName())), FileUtil.toFileObject((File)localScmRoot.getParentFile()));
                                FileUtil.toFileObject((File)tempFolder).delete();
                            } else {
                                Mercurial.cloneRepository((String)scmLoc, (File)localScmRoot, (String)"", (String)"", (String)"", (String)passwdAuth.getUserName(), (String)new String(passwdAuth.getPassword()), (boolean)false);
                                this.copySharedItems(sharedItems, localScmRoot);
                            }
                            if (autoCommit) {
                                initialRevision = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.initialRevision", (Object)newPrjTitle);
                                handle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repositoryCommit"), 5);
                                Mercurial.commit((File[])new File[]{localScmRoot}, (String)initialRevision);
                                Mercurial.pushToDefault((File)localScmRoot);
                            }
                        }
                        if (!inPlaceRepository) {
                            Project mainProject = OpenProjects.getDefault().getMainProject();
                            ArrayList<Project> projectsToClose = new ArrayList<Project>();
                            ArrayList<Project> projectsToOpen = new ArrayList<Project>();
                            for (SharedItem item : sharedItems) {
                                Project prj = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)item.getRoot()));
                                if (prj == null) continue;
                                projectsToClose.add(prj);
                                File newRoot = new File(localScmRoot, item.getRoot().getName());
                                Project movedProject = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)newRoot));
                                projectsToOpen.add(movedProject);
                                if (!prj.equals(mainProject)) continue;
                                mainProject = movedProject;
                            }
                            projectsToClose.remove(null);
                            projectsToOpen.remove(null);
                            OpenProjects.getDefault().close(projectsToClose.toArray(new Project[projectsToClose.size()]));
                            OpenProjects.getDefault().open(projectsToOpen.toArray(new Project[projectsToOpen.size()]), false);
                            OpenProjects.getDefault().setMainProject(mainProject);
                        }
                    }
                }
            }
            catch (KenaiException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (createChat.booleanValue()) {
            handle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"CTL_CreatingChatProgress"), 6);
            KenaiProject project = this.kenai.getProject(newPrjName);
            if (project.getFeatures(KenaiService.Type.CHAT).length == 0) {
                KenaiFeature f = project.createProjectFeature(newPrjName, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"CTL_ChatRoomName", (Object)newPrjName), NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"CTL_ChatRoomDescription", (Object)newPrjName), "instant_messenger", null, null, null);
            }
        }
        HashSet<CreatedProjectInfo> set = new HashSet<CreatedProjectInfo>();
        try {
            KenaiProject project = this.kenai.getProject(newPrjName);
            Dashboard.getDefault().addProject(new ProjectHandleImpl(project), true, true);
            set.add(new CreatedProjectInfo(project, newPrjScmLocal));
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        handle.finish();
        return set;
    }

    public static File createTempFolder() {
        File dir;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        while ((dir = new File(tmpDir, "kenai-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
        }
        dir.deleteOnExit();
        return FileUtil.normalizeFile((File)dir);
    }

    private void copySharedItems(List<SharedItem> sharedItems, File localScmRoot) throws IOException {
        localScmRoot.mkdirs();
        FileObject dest = FileUtil.toFileObject((File)localScmRoot);
        for (SharedItem item : sharedItems) {
            FileObject root = FileUtil.toFileObject((File)item.getRoot());
            this.copy(root, dest);
        }
    }

    private void copy(FileObject src, FileObject destFolder) throws IOException {
        if (src.isFolder()) {
            FileObject[] files;
            FileObject srcCopy = destFolder.getFileObject(src.getNameExt());
            if (srcCopy == null) {
                srcCopy = destFolder.createFolder(src.getNameExt());
            }
            for (FileObject file : files = src.getChildren()) {
                this.copy(file, srcCopy);
            }
        } else {
            src.copy(destFolder, src.getName(), src.getExt());
        }
    }

    static File getCommonParent(List<SharedItem> sharedItems) {
        File commonParent = null;
        if (sharedItems.size() > 0) {
            commonParent = sharedItems.get(0).getRoot().getParentFile();
            for (SharedItem item : sharedItems) {
                if (commonParent.equals(item.getRoot().getParentFile())) continue;
                commonParent = null;
                break;
            }
            if (commonParent != null && commonParent.list().length != sharedItems.size()) {
                commonParent = null;
            }
        }
        return commonParent;
    }

    static boolean isCommonParent(List<SharedItem> sharedItems, String newPrjScmLocal) {
        File commonParent = new File(newPrjScmLocal);
        for (SharedItem item : sharedItems) {
            if (commonParent.equals(item.getRoot().getParentFile())) continue;
            return false;
        }
        return commonParent.list() != null && commonParent.list().length == sharedItems.size();
    }

    public Set<?> instantiate() throws IOException {
        assert (false);
        return null;
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.panels = this.getPanels();
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.name");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    Kenai getKenai() {
        return this.kenai;
    }

    public void setKenai(Kenai kenai) {
        this.kenai = kenai;
    }

    private String getErrorMessage(KenaiException kex, String prepend) {
        String errMsg = null;
        if (kex instanceof KenaiException) {
            KenaiException kem = kex;
            Map errMap = kem.getErrors();
            StringBuffer sb = new StringBuffer();
            if (prepend != null) {
                sb.append(prepend + " ");
            }
            boolean sepAdded = false;
            if (errMap != null) {
                for (String fld : errMap.keySet()) {
                    sb.append((String)errMap.get(fld) + ". ");
                    sepAdded = true;
                }
            }
            errMsg = sepAdded ? sb.substring(0, sb.length() - 2) : sb.toString();
        } else {
            errMsg = kex.getLocalizedMessage();
        }
        return errMsg;
    }

    private String getScmDisplayName(String scmName) {
        String displayName = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SourceCodeRepository");
        if ("subversion".equals(scmName)) {
            displayName = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SubversionRepository");
        } else if ("mercurial".equals(scmName)) {
            displayName = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.MercurialRepository");
        } else if ("external_repository".equals(scmName)) {
            displayName = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.ExternalRepository");
        }
        return displayName;
    }

    private String getScmDescription(String scmName) {
        String desc = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SourceCodeRepository");
        if ("subversion".equals(scmName)) {
            desc = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SubversionSourceCodeRepository");
        } else if ("mercurial".equals(scmName)) {
            desc = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.MercurialSourceCodeRepository");
        } else if ("external_repository".equals(scmName)) {
            desc = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.ExternalSourceCodeRepository");
        }
        return desc;
    }

    private String getIssuesDisplayName(String issues) {
        String displayName = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.IssueTracking");
        if ("bugzilla".equals(issues)) {
            displayName = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.Bugzilla");
        } else if ("jira".equals(issues)) {
            displayName = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.JIRA");
        } else if ("external_issues".equals(issues)) {
            displayName = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.External");
        }
        return displayName;
    }

    private String getIssuesDescription(String issues) {
        String desc = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.IssueTracking");
        if ("bugzilla".equals(issues)) {
            desc = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.BugzillaIssueTracking");
        } else if ("jira".equals(issues)) {
            desc = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.JIRAIssueTracking");
        } else if ("external_issues".equals(issues)) {
            desc = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.ExternalIssueTracking");
        }
        return desc;
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    private WizardDescriptor.Panel[] createPanels() {
        List<SharedItem> initialItems = this.getInitialItems(this.activeNodes);
        return new WizardDescriptor.Panel[]{new NameAndLicenseWizardPanel(this, initialItems), new SourceAndIssuesWizardPanel(this, initialItems), new SummaryWizardPanel(this)};
    }

    private List<SharedItem> getInitialItems(Node[] nodes) {
        ArrayList<SharedItem> items = new ArrayList<SharedItem>();
        for (Node node : nodes) {
            File file;
            Project prj = (Project)node.getLookup().lookup(Project.class);
            if (prj == null || VersioningSupport.getOwner((File)(file = FileUtil.toFile((FileObject)prj.getProjectDirectory()))) != null) continue;
            items.add(new SharedItem(file));
        }
        return items;
    }

    public static class SharedItem {
        private final File root;

        public SharedItem(File file) {
            this.root = file;
        }

        public String toString() {
            return this.root.getName();
        }

        public File getRoot() {
            return this.root;
        }
    }

    public static class CreatedProjectInfo {
        public KenaiProject project;
        public String localRepoPath;

        public CreatedProjectInfo(KenaiProject prj, String pth) {
            this.project = prj;
            this.localRepoPath = pth;
        }
    }
}

