/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.treelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.treelist.LeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class AsynchronousLeafNode<T>
extends LeafNode {
    private JComponent inner = null;
    private JPanel panel;
    private JLabel lblTitle;
    private TreeListNode.ProgressLabel lblLoading;
    private JLabel lblError;
    private boolean loaded = false;
    private Loader loader;
    private final Object LOCK = new Object();

    public AsynchronousLeafNode(TreeListNode parent, String title) {
        super(parent);
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setOpaque(false);
        this.lblTitle = new TreeLabel(title);
        this.lblLoading = this.createProgressLabel(NbBundle.getMessage(AsynchronousLeafNode.class, (String)"LBL_LoadingInProgress"));
        this.lblLoading.setForeground(ColorManager.getDefault().getDisabledColor());
        this.lblError = new TreeLabel(NbBundle.getMessage(AsynchronousLeafNode.class, (String)"LBL_NotResponding"));
        this.lblError.setForeground(ColorManager.getDefault().getErrorColor());
        Image img = ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/ui/resources/error.png");
        this.lblError.setIcon(new ImageIcon(img));
        this.panel.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.lblLoading, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.panel.add((Component)this.lblError, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.panel.add((Component)new JLabel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final JComponent getComponent(Color foreground, Color background, boolean isSelected, boolean hasFocus) {
        Object object = this.LOCK;
        synchronized (object) {
            if (null != this.inner) {
                this.configure(this.inner, foreground, background, isSelected, hasFocus);
            } else {
                if (!this.loaded && null == this.loader) {
                    this.startLoading();
                }
                if (isSelected) {
                    this.lblLoading.setForeground(foreground);
                    this.lblError.setForeground(foreground);
                } else {
                    this.lblLoading.setForeground(ColorManager.getDefault().getDisabledColor());
                    this.lblError.setForeground(ColorManager.getDefault().getErrorColor());
                }
                this.lblTitle.setForeground(foreground);
            }
        }
        return this.panel;
    }

    protected abstract void configure(JComponent var1, Color var2, Color var3, boolean var4, boolean var5);

    protected abstract JComponent createComponent(T var1);

    protected abstract T load();

    protected final void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AsynchronousLeafNode.this.LOCK;
                synchronized (object) {
                    AsynchronousLeafNode.this.loaded = false;
                    if (null != AsynchronousLeafNode.this.inner) {
                        AsynchronousLeafNode.this.panel.remove(AsynchronousLeafNode.this.inner);
                    }
                    AsynchronousLeafNode.this.inner = null;
                    AsynchronousLeafNode.this.startLoading();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoading() {
        Object object = this.LOCK;
        synchronized (object) {
            this.loaded = false;
            this.lblLoading.setVisible(true);
            this.lblError.setVisible(false);
        }
        if (null != this.loader) {
            this.loader.cancel();
        }
        this.loader = new Loader();
        AsynchronousLeafNode.post(this.loader);
    }

    private void timedout() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AsynchronousLeafNode.this.LOCK;
                synchronized (object) {
                    AsynchronousLeafNode.this.lblError.setVisible(true);
                    AsynchronousLeafNode.this.lblLoading.setVisible(false);
                    AsynchronousLeafNode.this.loaded = true;
                    AsynchronousLeafNode.this.loader = null;
                }
                AsynchronousLeafNode.this.fireContentChanged();
            }
        });
    }

    private void loaded(final T data) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AsynchronousLeafNode.this.LOCK;
                synchronized (object) {
                    JComponent c = AsynchronousLeafNode.this.createComponent(data);
                    AsynchronousLeafNode.this.loaded = true;
                    if (null == c) {
                        AsynchronousLeafNode.this.lblLoading.setVisible(false);
                        AsynchronousLeafNode.this.lblError.setVisible(true);
                    } else {
                        AsynchronousLeafNode.this.lblLoading.setVisible(false);
                        AsynchronousLeafNode.this.lblError.setVisible(false);
                        if (null != AsynchronousLeafNode.this.inner) {
                            AsynchronousLeafNode.this.panel.remove(AsynchronousLeafNode.this.inner);
                        }
                        AsynchronousLeafNode.this.inner = c;
                        AsynchronousLeafNode.this.panel.remove(AsynchronousLeafNode.this.lblTitle);
                        AsynchronousLeafNode.this.panel.add((Component)AsynchronousLeafNode.this.inner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    }
                    AsynchronousLeafNode.this.panel.invalidate();
                    AsynchronousLeafNode.this.panel.revalidate();
                    AsynchronousLeafNode.this.panel.repaint();
                    AsynchronousLeafNode.this.loader = null;
                }
                AsynchronousLeafNode.this.fireContentChanged();
            }
        });
    }

    private class Loader
    implements Runnable,
    Cancellable {
        private boolean cancelled = false;
        private Thread t = null;

        private Loader() {
        }

        @Override
        public void run() {
            block4: {
                final Object[] res = new Object[1];
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        res[0] = AsynchronousLeafNode.this.load();
                    }
                };
                this.t = new Thread(r);
                this.t.start();
                try {
                    this.t.join(TreeListNode.TIMEOUT_INTERVAL_MILLIS);
                    if (null == res[0]) {
                        AsynchronousLeafNode.this.timedout();
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    AsynchronousLeafNode.this.loaded(res[0]);
                }
                catch (InterruptedException iE) {
                    if (this.cancelled) break block4;
                    AsynchronousLeafNode.this.timedout();
                }
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            if (null != this.t) {
                this.t.interrupt();
            }
            return true;
        }
    }
}

