/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotNode
extends Node {
    private Node beginNode;
    private Node endNode;
    private boolean exclusive;
    private boolean isLiteral;

    public DotNode(SourcePosition position, Node beginNode, Node endNode, boolean exclusive, boolean isLiteral) {
        super(position);
        assert (beginNode != null) : "beginNode is not null";
        assert (endNode != null) : "endNode is not null";
        this.beginNode = beginNode;
        this.endNode = endNode;
        this.exclusive = exclusive;
        this.isLiteral = isLiteral;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.DOTNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDotNode(this);
    }

    public Node getBeginNode() {
        return this.beginNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.beginNode, this.endNode);
    }
}

