/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhileNode
extends Node {
    private Node conditionNode;
    private Node bodyNode;
    private boolean evaluateAtStart;
    public boolean containsNonlocalFlow = false;

    public WhileNode(SourcePosition position, Node conditionNode, Node bodyNode) {
        this(position, conditionNode, bodyNode, true);
    }

    public WhileNode(SourcePosition position, Node conditionNode, Node bodyNode, boolean evalAtStart) {
        super(position);
        assert (conditionNode != null) : "conditionNode is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.conditionNode = conditionNode;
        this.bodyNode = bodyNode;
        this.evaluateAtStart = evalAtStart;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WHILENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitWhileNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getConditionNode() {
        return this.conditionNode;
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.conditionNode, this.bodyNode);
    }
}

