/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.parser;

import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsPushNode;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.BlockPassNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.NilImplicitNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SplatNode;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.lexer.Token;
import org.jrubyparser.parser.ParserSupport;

public class ParserSupport19
extends ParserSupport {
    public AssignableNode assignable(Token lhs, Node value) {
        this.checkExpression(value);
        switch (lhs.getType()) {
            case 286: {
                throw new SyntaxException(SyntaxException.PID.CANNOT_CHANGE_SELF, lhs.getPosition(), "Can't change the value of self", new Object[0]);
            }
            case 287: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to nil", "nil");
            }
            case 288: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to true", "true");
            }
            case 289: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to false", "false");
            }
            case 303: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to __FILE__", "__FILE__");
            }
            case 302: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to __LINE__", "__LINE__");
            }
            case 304: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to __ENCODING__", "__ENCODING__");
            }
            case 306: {
                return this.currentScope.assign(value != NilImplicitNode.NIL ? this.union(lhs, value) : lhs.getPosition(), (String)lhs.getValue(), this.makeNullNil(value));
            }
            case 310: {
                if (this.isInDef() || this.isInSingle()) {
                    throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, lhs.getPosition(), "dynamic constant assignment", new Object[0]);
                }
                return new ConstDeclNode(lhs.getPosition(), (String)lhs.getValue(), null, value);
            }
            case 309: {
                return new InstAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value);
            }
            case 311: {
                return new ClassVarAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value);
            }
            case 308: {
                return new GlobalAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value);
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, lhs.getPosition(), "identifier " + (String)lhs.getValue() + " is not valid to set", lhs.getValue());
    }

    protected void getterIdentifierError(SourcePosition position, String identifier) {
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, position, "identifier " + identifier + " is not valid to get", identifier);
    }

    public Node splat_array(Node node) {
        if (node instanceof SplatNode) {
            node = ((SplatNode)node).getValue();
        }
        if (node instanceof ArrayNode) {
            return node;
        }
        return null;
    }

    public Node arg_append(Node node1, Node node2) {
        if (node1 == null) {
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ListNode) {
            return ((ListNode)node1).add(node2);
        }
        if (node1 instanceof BlockPassNode) {
            return this.arg_append(((BlockPassNode)node1).getBodyNode(), node2);
        }
        if (node1 instanceof ArgsPushNode) {
            ArgsPushNode pushNode = (ArgsPushNode)node1;
            Node body = pushNode.getSecondNode();
            return new ArgsCatNode(pushNode.getPosition(), pushNode.getFirstNode(), new ArrayNode(body.getPosition(), body).add(node2));
        }
        return new ArgsPushNode(this.union(node1, node2), node1, node2);
    }

    public boolean is_local_id(Token identifier) {
        String name = (String)identifier.getValue();
        return this.getCurrentScope().getLocalScope().isDefined(name) < 0;
    }

    public ListNode list_append(Node list, Node item) {
        if (list == null) {
            return new ArrayNode(item.getPosition(), item);
        }
        if (!(list instanceof ListNode)) {
            return new ArrayNode(list.getPosition(), list).add(item);
        }
        return ((ListNode)list).add(item);
    }

    public Node new_bv(Token identifier) {
        if (!this.is_local_id(identifier)) {
            this.getterIdentifierError(identifier.getPosition(), (String)identifier.getValue());
        }
        this.shadowing_lvar(identifier);
        this.arg_var(identifier);
        return null;
    }

    public int arg_var(Token identifier) {
        return this.getCurrentScope().addVariable((String)identifier.getValue());
    }

    public void shadowing_lvar(Token identifier) {
        String name = (String)identifier.getValue();
        if (this.getCurrentScope().isDefined(name) > 0 && this.warnings.isVerbose()) {
            this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, identifier.getPosition(), "shadowing outer local variable - " + name, new Object[0]);
        }
    }

    public ListNode list_concat(Node first, Node second) {
        if (first instanceof ListNode) {
            if (second instanceof ListNode) {
                return ((ListNode)first).addAll((ListNode)second);
            }
            return ((ListNode)first).addAll(second);
        }
        return new ArrayNode(first.getPosition(), first).add(second);
    }
}

