/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.glassfish.spi.ExecSupport;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Appclient;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Application;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Connector;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Ejb;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Error;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Failed;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.NotApplicable;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Passed;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.StaticVerification;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Test;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Warning;
import org.netbeans.modules.j2ee.sun.dd.impl.verifier.Web;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class VerifierSupport
extends TopComponent {
    String _archiveName;
    static final int FAIL = 0;
    static final int WARN = 1;
    static final int ALL = 2;
    static String allString = NbBundle.getMessage(VerifierSupport.class, (String)"All_Results");
    static String failString = NbBundle.getMessage(VerifierSupport.class, (String)"Failures_Only");
    static String warnString = NbBundle.getMessage(VerifierSupport.class, (String)"Failures_and_Warnings_only");
    static String radioButtonName = NbBundle.getMessage(VerifierSupport.class, (String)"Radio_Button");
    static String radioButtonDesc = NbBundle.getMessage(VerifierSupport.class, (String)"RadioButtonToSelect");
    static String panelName = NbBundle.getMessage(VerifierSupport.class, (String)"Panel");
    static String panelDesc = NbBundle.getMessage(VerifierSupport.class, (String)"VerifierPanel");
    JRadioButton allButton;
    JRadioButton failButton;
    JRadioButton warnButton;
    RadioListener myListener;
    int statusLeveltoDisplay = 2;
    boolean verifierIsStillRunning = true;
    JPanel controlPanel;
    JPanel resultPanel;
    JTable table;
    DefaultTableModel tableModel;
    ListSelectionListener tableSelectionListener;
    JScrollPane tableScrollPane;
    JScrollPane textScrollPane;
    JTextArea detailText;
    private static String STATUS_LIT = "Status";
    final String[] columnNames = new String[]{NbBundle.getMessage(VerifierSupport.class, (String)STATUS_LIT), NbBundle.getMessage(VerifierSupport.class, (String)"Test_Description"), NbBundle.getMessage(VerifierSupport.class, (String)"Result")};
    private Vector passResults = new Vector();
    private Vector failResults = new Vector();
    private Vector errorResults = new Vector();
    private Vector warnResults = new Vector();
    private Vector naResults = new Vector();
    private Vector notImplementedResults = new Vector();
    private Vector notRunResults = new Vector();
    private Vector defaultResults = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launchVerifier(String fileName, OutputStream outs, File irf) {
        File f = new File(fileName);
        File dir = f.getParentFile();
        final VerifierSupport verifierSupport = new VerifierSupport(fileName);
        if (null == irf || !irf.exists()) {
            return;
        }
        String installRoot = irf.getAbsolutePath();
        try {
            File verifierFile;
            String cmd = installRoot + File.separator + "bin" + File.separator + "verifier";
            if (File.separatorChar != '/') {
                cmd = cmd + ".bat";
            }
            if (!(verifierFile = new File(cmd)).exists()) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(VerifierSupport.class, (String)"MSG_INSTALL_VERIFIER"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    verifierSupport.initUI();
                    verifierSupport.showInMode();
                }
            });
            Runtime rt = Runtime.getRuntime();
            String[] arr = new String[]{cmd, "-ra", "-d", dir.getAbsolutePath(), fileName};
            String cmdName = "";
            for (int j = 0; j < arr.length; ++j) {
                cmdName = cmdName + arr[j] + " ";
            }
            System.out.println(NbBundle.getMessage(VerifierSupport.class, (String)"running_", (Object)cmdName));
            Process child = rt.exec(arr);
            Thread[] copyMakers = new Thread[2];
            OutputStreamWriter oss = null;
            if (outs != null) {
                oss = new OutputStreamWriter(outs);
            }
            copyMakers[0] = new ExecSupport.OutputCopier((Reader)new InputStreamReader(child.getInputStream()), (Writer)oss, true);
            copyMakers[0].start();
            copyMakers[1] = new ExecSupport.OutputCopier((Reader)new InputStreamReader(child.getErrorStream()), (Writer)oss, true);
            copyMakers[1].start();
            try {
                child.waitFor();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
            }
            finally {
                try {
                    copyMakers[0].interrupt();
                    copyMakers[1].interrupt();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String onlyJarFile = f.getName();
        File ff = new File(dir, onlyJarFile + ".xml");
        Error err = null;
        if (!ff.exists()) {
            err = StaticVerification.createGraph().newError();
            err.setErrorName(NbBundle.getMessage(VerifierSupport.class, (String)"ERR_PARSING_OUTPUT"));
            err.setErrorDescription(NbBundle.getMessage(VerifierSupport.class, (String)"ERR_NO_OUTPUT_TO_PARSE", (Object)ff));
            verifierSupport.saveErrorResultsForDisplay(err);
            verifierSupport.verifierIsStillRunning = false;
            verifierSupport.updateDisplay();
            return;
        }
        FileInputStream in = null;
        StaticVerification sv = null;
        try {
            Connector rar;
            int i;
            Application app;
            int i2;
            Appclient ac;
            int i3;
            Web we;
            int i4;
            Ejb e;
            in = new FileInputStream(ff);
            sv = StaticVerification.createGraph((InputStream)in);
            err = sv.getError();
            if (err != null) {
                verifierSupport.saveErrorResultsForDisplay(err);
            }
            if ((e = sv.getEjb()) != null) {
                NotApplicable na;
                Passed p;
                Warning w;
                Failed fail = e.getFailed();
                if (fail != null) {
                    Test[] t = fail.getTest();
                    for (int i5 = 0; i5 < t.length; ++i5) {
                        verifierSupport.saveFailResultsForDisplay(t[i5]);
                    }
                }
                if ((w = e.getWarning()) != null) {
                    Test[] t = w.getTest();
                    for (int i6 = 0; i6 < t.length; ++i6) {
                        verifierSupport.saveWarnResultsForDisplay(t[i6]);
                    }
                }
                if ((p = e.getPassed()) != null) {
                    Test[] t = p.getTest();
                    for (int i7 = 0; i7 < t.length; ++i7) {
                        verifierSupport.savePassResultsForDisplay(t[i7]);
                    }
                }
                if ((na = e.getNotApplicable()) != null) {
                    Test[] t = na.getTest();
                    for (i4 = 0; i4 < t.length; ++i4) {
                        verifierSupport.saveNaResultsForDisplay(t[i4]);
                    }
                }
            }
            if ((we = sv.getWeb()) != null) {
                NotApplicable na;
                Passed p;
                Warning w;
                Failed fail = we.getFailed();
                if (fail != null) {
                    Test[] t = fail.getTest();
                    for (int i8 = 0; i8 < t.length; ++i8) {
                        verifierSupport.saveFailResultsForDisplay(t[i8]);
                    }
                }
                if ((w = we.getWarning()) != null) {
                    Test[] t = w.getTest();
                    for (int i9 = 0; i9 < t.length; ++i9) {
                        verifierSupport.saveWarnResultsForDisplay(t[i9]);
                    }
                }
                if ((p = we.getPassed()) != null) {
                    Test[] t = p.getTest();
                    for (i4 = 0; i4 < t.length; ++i4) {
                        verifierSupport.savePassResultsForDisplay(t[i4]);
                    }
                }
                if ((na = we.getNotApplicable()) != null) {
                    Test[] t = na.getTest();
                    for (i3 = 0; i3 < t.length; ++i3) {
                        verifierSupport.saveNaResultsForDisplay(t[i3]);
                    }
                }
            }
            if ((ac = sv.getAppclient()) != null) {
                NotApplicable na;
                Passed p;
                Warning w;
                Failed fail = ac.getFailed();
                if (fail != null) {
                    Test[] t = fail.getTest();
                    for (int i10 = 0; i10 < t.length; ++i10) {
                        verifierSupport.saveFailResultsForDisplay(t[i10]);
                    }
                }
                if ((w = ac.getWarning()) != null) {
                    Test[] t = w.getTest();
                    for (int i11 = 0; i11 < t.length; ++i11) {
                        verifierSupport.saveWarnResultsForDisplay(t[i11]);
                    }
                }
                if ((p = ac.getPassed()) != null) {
                    Test[] t = p.getTest();
                    for (i3 = 0; i3 < t.length; ++i3) {
                        verifierSupport.savePassResultsForDisplay(t[i3]);
                    }
                }
                if ((na = ac.getNotApplicable()) != null) {
                    Test[] t = na.getTest();
                    for (i2 = 0; i2 < t.length; ++i2) {
                        verifierSupport.saveNaResultsForDisplay(t[i2]);
                    }
                }
            }
            if ((app = sv.getApplication()) != null) {
                NotApplicable na;
                Passed p;
                Warning w;
                Failed fail = app.getFailed();
                if (fail != null) {
                    Test[] t = fail.getTest();
                    for (int i12 = 0; i12 < t.length; ++i12) {
                        verifierSupport.saveFailResultsForDisplay(t[i12]);
                    }
                }
                if ((w = app.getWarning()) != null) {
                    Test[] t = w.getTest();
                    for (int i13 = 0; i13 < t.length; ++i13) {
                        verifierSupport.saveWarnResultsForDisplay(t[i13]);
                    }
                }
                if ((p = app.getPassed()) != null) {
                    Test[] t = p.getTest();
                    for (i2 = 0; i2 < t.length; ++i2) {
                        verifierSupport.savePassResultsForDisplay(t[i2]);
                    }
                }
                if ((na = app.getNotApplicable()) != null) {
                    Test[] t = na.getTest();
                    for (i = 0; i < t.length; ++i) {
                        verifierSupport.saveNaResultsForDisplay(t[i]);
                    }
                }
            }
            if ((rar = sv.getConnector()) != null) {
                NotApplicable na;
                Passed p;
                Warning w;
                Failed fail = rar.getFailed();
                if (fail != null) {
                    Test[] t = fail.getTest();
                    for (int i14 = 0; i14 < t.length; ++i14) {
                        verifierSupport.saveFailResultsForDisplay(t[i14]);
                    }
                }
                if ((w = rar.getWarning()) != null) {
                    Test[] t = w.getTest();
                    for (int i15 = 0; i15 < t.length; ++i15) {
                        verifierSupport.saveWarnResultsForDisplay(t[i15]);
                    }
                }
                if ((p = rar.getPassed()) != null) {
                    Test[] t = p.getTest();
                    for (i = 0; i < t.length; ++i) {
                        verifierSupport.savePassResultsForDisplay(t[i]);
                    }
                }
                if ((na = rar.getNotApplicable()) != null) {
                    Test[] t = na.getTest();
                    for (int i16 = 0; i16 < t.length; ++i16) {
                        verifierSupport.saveNaResultsForDisplay(t[i16]);
                    }
                }
            }
        }
        catch (RuntimeException rte) {
            err = StaticVerification.createGraph().newError();
            err.setErrorName(NbBundle.getMessage(VerifierSupport.class, (String)"ERR_PARSING_OUTPUT"));
            err.setErrorDescription(rte.getMessage());
            if (rte.getMessage().indexOf("error-name") > -1) {
                err.setErrorDescription(NbBundle.getMessage(VerifierSupport.class, (String)"READ_OUTPUT_WINDOW"));
            }
            verifierSupport.saveErrorResultsForDisplay(err);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            err = StaticVerification.createGraph().newError();
            err.setErrorName(NbBundle.getMessage(VerifierSupport.class, (String)"ERR_PARSING_OUTPUT"));
            err.setErrorDescription(ioe.getMessage());
            verifierSupport.saveErrorResultsForDisplay(err);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
        }
        verifierSupport.verifierIsStillRunning = false;
        verifierSupport.updateDisplay();
    }

    public VerifierSupport(String archiveName) {
        this._archiveName = archiveName;
    }

    public void initUI() {
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getMessage(VerifierSupport.class, (String)"LBL_Verifier", (Object)new File(this._archiveName).getName()));
        this.createResultsPanel();
        this.add(this.resultPanel);
    }

    protected void componentOpened() {
    }

    protected void componentClosed() {
        this.clearResults();
        this.table.getSelectionModel().removeListSelectionListener(this.tableSelectionListener);
        this.allButton.removeActionListener(this.myListener);
        this.failButton.removeActionListener(this.myListener);
        this.warnButton.removeActionListener(this.myListener);
        this.remove(this.resultPanel);
        this.resultPanel = null;
        this.table = null;
        this.allButton = null;
        this.failButton = null;
        this.warnButton = null;
        this.myListener = null;
        this.tableSelectionListener = null;
    }

    public int getPersistenceType() {
        return 2;
    }

    public void showInMode() {
        Mode mode;
        if (!this.isOpened() && (mode = WindowManager.getDefault().findMode("output")) != null) {
            mode.dockInto((TopComponent)this);
        }
        this.open();
        this.requestVisible();
        this.requestActive();
    }

    protected String preferredID() {
        return NbBundle.getMessage(VerifierSupport.class, (String)"verifierID");
    }

    private void createResultsPanel() {
        this.resultPanel = new JPanel();
        this.resultPanel.setLayout(new BorderLayout());
        this.resultPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), this._archiveName));
        this.resultPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VerifierSupport.class, (String)"Panel"));
        this.resultPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VerifierSupport.class, (String)"This_is_a_panel"));
        this.tableModel = new DefaultTableModel(this.columnNames, 0);
        this.table = new JTable(this.tableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText((String)this.getValueAt(rowIndex, vColIndex));
                }
                return c;
            }
        };
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VerifierSupport.class, (String)"Table"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VerifierSupport.class, (String)"This_is_a_table_of_items"));
        this.table.setSelectionMode(0);
        this.tableScrollPane = new JScrollPane(this.table);
        Object[] row = new Object[]{NbBundle.getMessage(VerifierSupport.class, (String)"Wait"), NbBundle.getMessage(VerifierSupport.class, (String)"Running_Verifier_Tool..."), NbBundle.getMessage(VerifierSupport.class, (String)"Running...")};
        this.tableModel.addRow(row);
        this.tableScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VerifierSupport.class, (String)"Scroll_Pane"));
        this.tableScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VerifierSupport.class, (String)"ScrollArea"));
        this.sizeTableColumns();
        JTextField field = new JTextField();
        field.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VerifierSupport.class, (String)"Text_Field"));
        field.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VerifierSupport.class, (String)"This_is_a_text_field"));
        this.table.setDefaultEditor(Object.class, new DefaultCellEditor(field){

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return false;
            }
        });
        this.tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (VerifierSupport.this.table.getSelectionModel().isSelectedIndex(e.getLastIndex())) {
                        VerifierSupport.this.setDetailText(VerifierSupport.this.table.getModel().getValueAt(e.getLastIndex(), 1) + "\n" + VerifierSupport.this.table.getModel().getValueAt(e.getLastIndex(), 2));
                    } else if (VerifierSupport.this.table.getSelectionModel().isSelectedIndex(e.getFirstIndex())) {
                        VerifierSupport.this.setDetailText(VerifierSupport.this.table.getModel().getValueAt(e.getFirstIndex(), 1) + "\n" + VerifierSupport.this.table.getModel().getValueAt(e.getFirstIndex(), 2));
                    }
                }
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        this.detailText = new JTextArea(4, 50);
        this.detailText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VerifierSupport.class, (String)"Text_Area"));
        this.detailText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VerifierSupport.class, (String)"This_is_a_text_area"));
        this.detailText.setEditable(false);
        this.textScrollPane = new JScrollPane(this.detailText);
        this.textScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VerifierSupport.class, (String)"Scroll_Pane"));
        this.textScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VerifierSupport.class, (String)"ScrollListPane"));
        this.textScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), NbBundle.getMessage(VerifierSupport.class, (String)"Detail:")));
        this.createControlPanel();
        JSplitPane splitPane = new JSplitPane(0, this.tableScrollPane, this.textScrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(150);
        Dimension minimumSize = new Dimension(100, 50);
        this.tableScrollPane.setMinimumSize(minimumSize);
        this.textScrollPane.setMinimumSize(minimumSize);
        this.resultPanel.add("North", this.controlPanel);
        this.resultPanel.add("Center", splitPane);
    }

    public void setDetailText(String details) {
        this.detailText.setText(details);
        JScrollBar scrollBar = this.textScrollPane.getVerticalScrollBar();
        if (scrollBar != null) {
            scrollBar.setValue(0);
        }
    }

    public void clearResults() {
        this.tableModel = new DefaultTableModel(this.columnNames, 0);
        this.table.setModel(this.tableModel);
        this.sizeTableColumns();
        this.setDetailText("");
    }

    void sizeTableColumns() {
        this.table.getColumn(NbBundle.getMessage(VerifierSupport.class, (String)STATUS_LIT)).setPreferredWidth(40);
        this.table.getColumn(NbBundle.getMessage(VerifierSupport.class, (String)"Test_Description")).setPreferredWidth(300);
        this.table.getColumn(NbBundle.getMessage(VerifierSupport.class, (String)"Result")).setPreferredWidth(300);
        this.table.setAutoResizeMode(4);
    }

    private void createControlPanel() {
        this.allButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.allButton, (String)allString);
        this.failButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.failButton, (String)failString);
        this.warnButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.warnButton, (String)warnString);
        this.controlPanel = new JPanel();
        this.controlPanel.getAccessibleContext().setAccessibleName(panelName);
        this.controlPanel.getAccessibleContext().setAccessibleDescription(panelDesc);
        this.allButton.getAccessibleContext().setAccessibleName(radioButtonName);
        this.allButton.getAccessibleContext().setAccessibleDescription(radioButtonDesc);
        this.failButton.getAccessibleContext().setAccessibleName(radioButtonName);
        this.failButton.getAccessibleContext().setAccessibleDescription(radioButtonDesc);
        this.warnButton.getAccessibleContext().setAccessibleName(radioButtonName);
        this.warnButton.getAccessibleContext().setAccessibleDescription(radioButtonDesc);
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 1));
        this.allButton.setActionCommand(allString);
        this.allButton.setSelected(true);
        this.failButton.setActionCommand(failString);
        this.warnButton.setActionCommand(warnString);
        ButtonGroup group = new ButtonGroup();
        group.add(this.allButton);
        group.add(this.failButton);
        group.add(this.warnButton);
        JPanel radioPanel = new JPanel();
        radioPanel.getAccessibleContext().setAccessibleName(panelName);
        radioPanel.getAccessibleContext().setAccessibleDescription(panelDesc);
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        JLabel d = new JLabel(NbBundle.getMessage(VerifierSupport.class, (String)"DisplayLabel"));
        d.setVerticalAlignment(3);
        d.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VerifierSupport.class, (String)"Label"));
        d.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VerifierSupport.class, (String)"This_is_a_label"));
        radioPanel.add(d);
        radioPanel.add(this.allButton);
        radioPanel.add(this.failButton);
        radioPanel.add(this.warnButton);
        this.controlPanel.add(radioPanel);
        this.myListener = new RadioListener();
        this.allButton.addActionListener(this.myListener);
        this.failButton.addActionListener(this.myListener);
        this.warnButton.addActionListener(this.myListener);
    }

    private void updateTableRows(String type, Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            Test t = (Test)results.elementAt(i);
            Object[] row = new Object[]{type, t.getTestAssertion(), t.getTestDescription()};
            this.tableModel.addRow(row);
        }
    }

    private void updateDisplayAll() {
        this.updateDisplayFail();
        this.updateDisplayWarn();
        this.updateDisplayPass();
        this.updateDisplayNa();
        this.updateDisplayNotImplemented();
        this.updateDisplayNotRun();
        this.updateDisplayDefault();
        this.updateDisplayError();
    }

    private void updateDisplayPass() {
        this.updateTableRows(NbBundle.getMessage(VerifierSupport.class, (String)"Pass"), this.getPassResultsForDisplay());
    }

    private void updateDisplayFail() {
        this.updateTableRows(NbBundle.getMessage(VerifierSupport.class, (String)"Fail"), this.getFailResultsForDisplay());
    }

    private void updateDisplayError() {
        Vector errors = this.getErrorResultsForDisplay();
        for (int i = 0; i < errors.size(); ++i) {
            Error t = (Error)errors.elementAt(i);
            Object[] row = new Object[]{NbBundle.getMessage(VerifierSupport.class, (String)"Error"), t.getErrorName(), t.getErrorDescription()};
            this.tableModel.addRow(row);
        }
    }

    private void updateDisplayWarn() {
        this.updateTableRows(NbBundle.getMessage(VerifierSupport.class, (String)"Warning"), this.getWarnResultsForDisplay());
    }

    private void updateDisplayNa() {
        this.updateTableRows(NbBundle.getMessage(VerifierSupport.class, (String)"Not_Applicable"), this.getNaResultsForDisplay());
    }

    private void updateDisplayNotImplemented() {
        this.updateTableRows(NbBundle.getMessage(VerifierSupport.class, (String)"Not_Implemented"), this.getNotImplementedResultsForDisplay());
    }

    private void updateDisplayNotRun() {
        this.updateTableRows(NbBundle.getMessage(VerifierSupport.class, (String)"Not_Run"), this.getNotRunResultsForDisplay());
    }

    private void updateDisplayDefault() {
        this.updateTableRows("???", this.getDefaultResultsForDisplay());
    }

    public void updateDisplay() {
        this.clearResults();
        if (this.statusLeveltoDisplay == 2) {
            this.updateDisplayAll();
        }
        if (this.statusLeveltoDisplay == 0) {
            this.updateDisplayError();
            this.updateDisplayFail();
        }
        if (this.statusLeveltoDisplay == 1) {
            this.updateDisplayError();
            this.updateDisplayFail();
            this.updateDisplayWarn();
        }
    }

    private void savePassResultsForDisplay(Test r) {
        this.passResults.addElement(r);
    }

    private void saveWarnResultsForDisplay(Test r) {
        this.warnResults.addElement(r);
    }

    private void saveFailResultsForDisplay(Test r) {
        this.failResults.addElement(r);
    }

    public void saveErrorResultsForDisplay(Error r) {
        this.errorResults.addElement(r);
    }

    private void saveNaResultsForDisplay(Test r) {
        this.naResults.addElement(r);
    }

    private Vector getPassResultsForDisplay() {
        return this.passResults;
    }

    private Vector getWarnResultsForDisplay() {
        return this.warnResults;
    }

    private Vector getFailResultsForDisplay() {
        return this.failResults;
    }

    private Vector getErrorResultsForDisplay() {
        return this.errorResults;
    }

    private Vector getNaResultsForDisplay() {
        return this.naResults;
    }

    private Vector getNotImplementedResultsForDisplay() {
        return this.notImplementedResults;
    }

    private Vector getNotRunResultsForDisplay() {
        return this.notRunResults;
    }

    private Vector getDefaultResultsForDisplay() {
        return this.defaultResults;
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (VerifierSupport.this.verifierIsStillRunning) {
                if (e.getSource() == VerifierSupport.this.allButton) {
                    VerifierSupport.this.statusLeveltoDisplay = 2;
                }
                if (e.getSource() == VerifierSupport.this.failButton) {
                    VerifierSupport.this.statusLeveltoDisplay = 0;
                }
                if (e.getSource() == VerifierSupport.this.warnButton) {
                    VerifierSupport.this.statusLeveltoDisplay = 1;
                }
                return;
            }
            if (e.getSource() == VerifierSupport.this.allButton) {
                VerifierSupport.this.statusLeveltoDisplay = 2;
                if (VerifierSupport.this.getPassResultsForDisplay().size() > 0 || VerifierSupport.this.getFailResultsForDisplay().size() > 0 || VerifierSupport.this.getErrorResultsForDisplay().size() > 0 || VerifierSupport.this.getWarnResultsForDisplay().size() > 0 || VerifierSupport.this.getNaResultsForDisplay().size() > 0 || VerifierSupport.this.getNotImplementedResultsForDisplay().size() > 0 || VerifierSupport.this.getNotRunResultsForDisplay().size() > 0 || VerifierSupport.this.getDefaultResultsForDisplay().size() > 0) {
                    VerifierSupport.this.updateDisplay();
                } else {
                    VerifierSupport.this.clearResults();
                }
            }
            if (e.getSource() == VerifierSupport.this.failButton) {
                VerifierSupport.this.statusLeveltoDisplay = 0;
                if (VerifierSupport.this.getFailResultsForDisplay().size() > 0 || VerifierSupport.this.getErrorResultsForDisplay().size() > 0) {
                    VerifierSupport.this.updateDisplay();
                } else {
                    VerifierSupport.this.clearResults();
                }
            }
            if (e.getSource() == VerifierSupport.this.warnButton) {
                VerifierSupport.this.statusLeveltoDisplay = 1;
                if (VerifierSupport.this.getFailResultsForDisplay().size() > 0 || VerifierSupport.this.getErrorResultsForDisplay().size() > 0 || VerifierSupport.this.getWarnResultsForDisplay().size() > 0) {
                    VerifierSupport.this.updateDisplay();
                } else {
                    VerifierSupport.this.clearResults();
                }
            }
        }
    }
}

