/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.bridge.J2MEProjectUtilitiesProvider;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class J2MEProjectUtils {
    public static final Set<String> ILEGAL_CONFIGURATION_NAMES = new HashSet<String>(Arrays.asList("preprocessed", "compiled", "obfuscated", "preverified"));

    private J2MEProjectUtils() {
    }

    public static Project getActiveProject(TopComponent tc) {
        Node[] nodes = tc == null ? TopComponent.getRegistry().getActivatedNodes() : tc.getActivatedNodes();
        Project p = null;
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                DataObject dobj = (DataObject)nodes[i].getCookie(DataObject.class);
                if (dobj == null) continue;
                Project np = FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile());
                if (p != null && np != null && !p.equals(np)) {
                    return null;
                }
                p = np;
            }
        }
        return p;
    }

    public static Project getActiveProject() {
        return J2MEProjectUtils.getActiveProject(null);
    }

    public static Project getProjectForDocument(Document doc) {
        J2MEProjectUtilitiesProvider utils = (J2MEProjectUtilitiesProvider)Lookup.getDefault().lookup(J2MEProjectUtilitiesProvider.class);
        if (utils == null) {
            return null;
        }
        FileObject fo = utils.getFileObjectForDocument(doc);
        if (fo != null) {
            return FileOwnerQuery.getOwner((FileObject)fo);
        }
        return null;
    }

    public static ProjectConfigurationProvider getConfigProviderForDoc(Document doc) {
        Project p = J2MEProjectUtils.getProjectForDocument(doc);
        if (p != null) {
            return (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class);
        }
        return null;
    }

    public static ProjectConfigurationsHelper getCfgHelperForDoc(Document doc) {
        Project p = J2MEProjectUtils.getProjectForDocument(doc);
        if (p != null) {
            return (ProjectConfigurationsHelper)p.getLookup().lookup(ProjectConfigurationsHelper.class);
        }
        return null;
    }

    public static String evaluateProperty(AntProjectHelper helper, String propertyName, String configuration) {
        String val;
        PropertyEvaluator ev = helper.getStandardPropertyEvaluator();
        if (configuration != null && configuration.length() > 0 && (val = ev.getProperty("configs." + configuration + "." + propertyName)) != null) {
            return val;
        }
        return ev.getProperty(propertyName);
    }

    public static String evaluateProperty(AntProjectHelper helper, String propertyName) {
        PropertyEvaluator ev = helper.getStandardPropertyEvaluator();
        String config = ev.getProperty("config.active");
        return J2MEProjectUtils.evaluateProperty(helper, propertyName, config);
    }

    public static URL deJar(URL url) {
        if (url == null) {
            return null;
        }
        URL u = FileUtil.getArchiveFile((URL)url);
        return u == null ? url : u;
    }

    public static URL wrapJar(URL url) {
        if (url == null) {
            return null;
        }
        String name = url.toExternalForm().toLowerCase();
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            return FileUtil.getArchiveRoot((URL)url);
        }
        if (!name.endsWith("/")) {
            try {
                return new URL(url.toExternalForm() + "/");
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return url;
    }

    public static boolean isParentOf(URL root, URL file) {
        if (root == null || file == null) {
            return false;
        }
        return J2MEProjectUtils.deJar(file).toExternalForm().startsWith(J2MEProjectUtils.deJar(root).toExternalForm());
    }

    public static String detectConfiguration(URL projectRoot, URL url) {
        if (projectRoot == null || url == null) {
            return null;
        }
        String r = J2MEProjectUtils.deJar(projectRoot).toExternalForm();
        String u = J2MEProjectUtils.deJar(url).toExternalForm();
        if (!u.startsWith(r)) {
            return null;
        }
        if ((u = u.substring(r.length())).startsWith("/")) {
            u = u.substring(1);
        }
        int i = u.indexOf(47);
        int j = u.indexOf(47, i + 1);
        if (i < 0 || j < 0) {
            return null;
        }
        String cfg = u.substring(i + 1, j);
        return (u.startsWith("build") || u.startsWith("dist")) && !ILEGAL_CONFIGURATION_NAMES.contains(cfg) ? cfg : null;
    }
}

