/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.mobility.project.ui.FileMonitor;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

class MissingFileDetector {
    static int INTERVAL = 15000;
    static MissingFileDetector INSTANCE = new MissingFileDetector();
    private final Map<File, OneFileItem> monitorsToFiles = new ConcurrentHashMap<File, OneFileItem>();
    static boolean unitTest;
    volatile boolean firstRun;
    private volatile boolean listeningToMainWindow;
    private final RunnerAndWindowHandler windowRunner = new RunnerAndWindowHandler();
    private final RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this.windowRunner);
    volatile boolean active;
    private Window mainWindow;
    private volatile boolean shouldBeListening;

    private MissingFileDetector() {
        assert (unitTest || INSTANCE == null);
        this.task.setPriority(1);
        if (!unitTest) {
            this.findMainWindow();
        }
    }

    static void reset() {
        INSTANCE = new MissingFileDetector();
    }

    private void scheduleTask() {
        this.active = true;
        this.task.schedule(INTERVAL);
    }

    private void cancelTask() {
        this.active = false;
        this.task.cancel();
    }

    private boolean mainWindowIsActive() {
        return unitTest ? true : (this.mainWindow == null ? false : this.mainWindow.isActive());
    }

    private synchronized Window getMainWindow() {
        return this.mainWindow;
    }

    private synchronized void setMainWindow(Window w) {
        this.mainWindow = w;
    }

    private void findMainWindow() {
        this.firstRun = false;
        if (!unitTest) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Frame w = WindowManager.getDefault().getMainWindow();
                    MissingFileDetector.this.setMainWindow(w);
                    if (MissingFileDetector.this.shouldBeListening) {
                        w.addWindowListener(MissingFileDetector.this.windowRunner);
                        MissingFileDetector.this.scheduleTask();
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeLater(r);
            }
        }
    }

    public static void register(File file, FileMonitor monitor) {
        if (file == null) {
            throw new NullPointerException("null file");
        }
        if (monitor == null) {
            throw new NullPointerException("Null monitor");
        }
        INSTANCE._register(file, monitor);
    }

    public static void unregister(File file, FileMonitor monitor) {
        if (file == null) {
            throw new NullPointerException("null file");
        }
        if (monitor == null) {
            throw new NullPointerException("Null monitor");
        }
        INSTANCE._unregister(file, monitor);
    }

    private void remove(File file) {
        this.monitorsToFiles.remove(file);
        this.prune();
    }

    void _register(File file, FileMonitor monitor) {
        if (this.firstRun) {
            this.findMainWindow();
        }
        if (!unitTest && !this.listeningToMainWindow) {
            this.startListening();
        }
        this.scheduleTask();
        OneFileItem item = this.monitorsToFiles.get(file);
        if (item == null) {
            item = new OneFileItem(file);
            this.monitorsToFiles.put(file, item);
        }
        item.add(monitor);
    }

    void _unregister(File file, FileMonitor monitor) {
        OneFileItem item = this.monitorsToFiles.get(file);
        if (item != null) {
            item.remove(monitor);
            if (item.notifyMonitorsAndCleanUpReferences(null)) {
                this.monitorsToFiles.remove(file);
            }
        }
        this.prune();
    }

    private void startListening() {
        this.shouldBeListening = true;
        if (!this.listeningToMainWindow && !unitTest) {
            this.listeningToMainWindow = true;
            Window w = this.getMainWindow();
            if (w != null) {
                w.addWindowListener(this.windowRunner);
            }
        }
        this.scheduleTask();
    }

    private void stopListening() {
        this.shouldBeListening = false;
        if (!unitTest && !this.listeningToMainWindow) {
            this.listeningToMainWindow = false;
            Window w = this.getMainWindow();
            if (w != null) {
                w.removeWindowListener(this.windowRunner);
            }
        }
        this.cancelTask();
    }

    private boolean isEmpty() {
        return this.monitorsToFiles.isEmpty();
    }

    private void prune() {
        for (File file : new HashSet<File>(this.monitorsToFiles.keySet())) {
            OneFileItem c = this.monitorsToFiles.get(file);
            if (!c.notifyMonitorsAndCleanUpReferences(null)) continue;
            this.monitorsToFiles.remove(file);
        }
        if (this.isEmpty()) {
            this.cancelTask();
            this.stopListening();
        }
    }

    private static final class OneMonitorItem
    extends WeakReference<FileMonitor> {
        private final Exception exception;

        OneMonitorItem(FileMonitor monitor) {
            super(monitor);
            boolean assertions = false;
            if (!$assertionsDisabled) {
                assertions = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            this.exception = assertions ? new Exception() : null;
        }
    }

    private static final class MonitorRunnableImpl
    implements MonitorRunnable {
        private final RunnableKinds kind;

        private MonitorRunnableImpl(RunnableKinds kind) {
            this.kind = kind;
        }

        @Override
        public void run(FileMonitor monitor) {
            switch (this.kind) {
                case CHANGED: {
                    monitor.fileChanged();
                    break;
                }
                case CREATED: {
                    monitor.fileCreated();
                    break;
                }
                case DELETED: {
                    monitor.fileDeleted();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private static enum RunnableKinds {
        CREATED,
        CHANGED,
        DELETED;

    }

    private static interface MonitorRunnable {
        public void run(FileMonitor var1);
    }

    private static final class Notifier
    implements Runnable {
        private final List<? extends FileMonitor> monitors;
        private final MonitorRunnable notifier;

        private Notifier(List<? extends FileMonitor> monitors, MonitorRunnable notifier) {
            this.monitors = monitors;
            this.notifier = notifier;
        }

        @Override
        public void run() {
            for (FileMonitor fileMonitor : this.monitors) {
                this.notifier.run(fileMonitor);
            }
        }
    }

    private final class OneFileItem {
        private final File file;
        private final List<OneMonitorItem> monitors = Collections.synchronizedList(new LinkedList());
        private boolean exists;
        private long timestamp;

        OneFileItem(File file) {
            if (file == null) {
                throw new NullPointerException("Null file");
            }
            this.file = FileUtil.normalizeFile((File)file);
            this.timestamp = file.exists() ? file.lastModified() : 0L;
            this.exists = file.exists();
            MissingFileDetector.this.startListening();
        }

        private void notifyFileChanged() {
            if (this.notifyMonitorsAndCleanUpReferences(new MonitorRunnableImpl(RunnableKinds.CHANGED))) {
                MissingFileDetector.this.remove(this.file);
            }
        }

        private void notifyFileCreated() {
            if (this.notifyMonitorsAndCleanUpReferences(new MonitorRunnableImpl(RunnableKinds.CREATED))) {
                MissingFileDetector.this.remove(this.file);
            }
        }

        private void notifyFileDeleted() {
            if (this.notifyMonitorsAndCleanUpReferences(new MonitorRunnableImpl(RunnableKinds.DELETED))) {
                MissingFileDetector.this.remove(this.file);
            }
        }

        public boolean exists() {
            return this.file.exists();
        }

        public void add(FileMonitor monitor) {
            OneMonitorItem other;
            assert (monitor != null) : "Monitor null";
            boolean assertions = false;
            if (!$assertionsDisabled) {
                assertions = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            this.notifyMonitorsAndCleanUpReferences(null);
            if (assertions && (other = this.checkDuplicate(monitor)) != null) {
                throw new IllegalArgumentException("File monitor added twice: " + monitor + "\nStack trace for when first added " + "listed below as cause", other.exception);
            }
            this.monitors.add(new OneMonitorItem(monitor));
        }

        public boolean remove(FileMonitor monitor) {
            assert (monitor != null) : "Null monitor";
            Iterator<OneMonitorItem> it = this.monitors.iterator();
            while (it.hasNext()) {
                OneMonitorItem item = it.next();
                FileMonitor other = (FileMonitor)item.get();
                if (other != null && !monitor.equals(other)) continue;
                it.remove();
            }
            return this.monitors.isEmpty();
        }

        private OneMonitorItem checkDuplicate(FileMonitor monitor) {
            Iterator<OneMonitorItem> it = this.monitors.iterator();
            while (it.hasNext()) {
                OneMonitorItem item = it.next();
                FileMonitor other = (FileMonitor)item.get();
                if (other == null) {
                    it.remove();
                    continue;
                }
                if (!monitor.equals(other)) continue;
                return item;
            }
            return null;
        }

        private boolean notifyMonitorsAndCleanUpReferences(MonitorRunnable toRun) {
            LinkedList<FileMonitor> toNotify = null;
            Iterator<OneMonitorItem> it = this.monitors.iterator();
            while (it.hasNext()) {
                OneMonitorItem item = it.next();
                FileMonitor monitor = (FileMonitor)item.get();
                if (monitor == null) {
                    it.remove();
                    continue;
                }
                if (toRun == null) continue;
                if (toNotify == null) {
                    toNotify = new LinkedList<FileMonitor>();
                }
                toNotify.add(monitor);
            }
            if (toRun != null && !toNotify.isEmpty()) {
                EventQueue.invokeLater(new Notifier(toNotify, toRun));
            }
            return this.monitors.isEmpty();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OneFileItem other = (OneFileItem)obj;
            return this.file == other.file || this.file.equals(other.file);
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.file != null ? this.file.hashCode() : 0);
            return hash;
        }

        private void poll() {
            boolean oldExists = this.exists;
            long oldTimestamp = this.timestamp;
            this.exists = this.file.exists();
            if (oldExists != this.exists) {
                if (this.exists) {
                    this.notifyFileCreated();
                } else {
                    this.timestamp = 0L;
                    this.notifyFileDeleted();
                }
            } else {
                this.timestamp = this.file.lastModified();
                if (oldTimestamp != this.timestamp) {
                    this.notifyFileChanged();
                }
            }
            this.exists = this.file.exists();
        }
    }

    private class RunnerAndWindowHandler
    extends WindowAdapter
    implements Runnable {
        private RunnerAndWindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            MissingFileDetector.this.scheduleTask();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            MissingFileDetector.this.cancelTask();
        }

        @Override
        public void run() {
            MissingFileDetector.this.prune();
            if (!MissingFileDetector.this.isEmpty() && MissingFileDetector.this.mainWindowIsActive()) {
                MissingFileDetector.this.scheduleTask();
            }
            for (File file : MissingFileDetector.this.monitorsToFiles.keySet()) {
                OneFileItem item = (OneFileItem)MissingFileDetector.this.monitorsToFiles.get(file);
                item.poll();
            }
        }
    }
}

