/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.project.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.spi.WebServiceDataProvider;
import org.netbeans.spi.project.LookupMerger;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class LookupMergerSupport {
    public static LookupMerger<WebServiceDataProvider> createWebServiceDataProviderMerger() {
        return new WebServiceDataProviderMerger();
    }

    private static class WebServiceDataProviderImpl
    implements WebServiceDataProvider,
    LookupListener {
        private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        private Lookup.Result<WebServiceDataProvider> delegates;
        private Collection<WebServiceDataProvider> wsDataProviders = new ArrayList<WebServiceDataProvider>();

        private WebServiceDataProviderImpl() {
        }

        private void setLookup(Lookup lookup) {
            if (this.wsDataProviders.size() > 0) {
                for (WebServiceDataProvider old : this.wsDataProviders) {
                    for (PropertyChangeListener pcl : this.changeSupport.getPropertyChangeListeners()) {
                        old.removePropertyChangeListener(pcl);
                    }
                }
                this.wsDataProviders.clear();
            }
            if (this.delegates != null) {
                this.delegates.removeLookupListener((LookupListener)this);
            }
            Lookup.Result srcs = lookup.lookupResult(WebServiceDataProvider.class);
            for (WebServiceDataProvider ns : srcs.allInstances()) {
                for (PropertyChangeListener pcl : this.changeSupport.getPropertyChangeListeners()) {
                    ns.addPropertyChangeListener(pcl);
                }
                this.wsDataProviders.add(ns);
            }
            srcs.addLookupListener((LookupListener)this);
            this.delegates = srcs;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            for (WebServiceDataProvider provider : this.wsDataProviders) {
                provider.addPropertyChangeListener(listener);
            }
            this.changeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
            for (WebServiceDataProvider provider : this.wsDataProviders) {
                provider.removePropertyChangeListener(listener);
            }
        }

        public void resultChanged(LookupEvent ev) {
            if (this.wsDataProviders.size() > 0) {
                for (WebServiceDataProvider old : this.wsDataProviders) {
                    for (PropertyChangeListener pcl : this.changeSupport.getPropertyChangeListeners()) {
                        old.removePropertyChangeListener(pcl);
                    }
                }
                this.wsDataProviders.clear();
            }
            for (WebServiceDataProvider ns : this.delegates.allInstances()) {
                for (PropertyChangeListener pcl : this.changeSupport.getPropertyChangeListeners()) {
                    ns.addPropertyChangeListener(pcl);
                }
                this.wsDataProviders.add(ns);
            }
        }

        @Override
        public List<WebService> getServiceProviders() {
            assert (this.delegates != null);
            ArrayList<WebService> result = new ArrayList<WebService>();
            for (WebServiceDataProvider ns : this.delegates.allInstances()) {
                List<WebService> providers = ns.getServiceProviders();
                if (providers == null) continue;
                result.addAll(providers);
            }
            return result;
        }

        @Override
        public List<WebService> getServiceConsumers() {
            assert (this.delegates != null);
            ArrayList<WebService> result = new ArrayList<WebService>();
            for (WebServiceDataProvider ns : this.delegates.allInstances()) {
                List<WebService> providers = ns.getServiceConsumers();
                if (providers == null) continue;
                result.addAll(providers);
            }
            return result;
        }
    }

    private static class WebServiceDataProviderMerger
    implements LookupMerger<WebServiceDataProvider> {
        private WebServiceDataProviderImpl merger;

        private WebServiceDataProviderMerger() {
        }

        public Class<WebServiceDataProvider> getMergeableClass() {
            return WebServiceDataProvider.class;
        }

        public WebServiceDataProvider merge(Lookup lookup) {
            if (this.merger == null) {
                this.merger = new WebServiceDataProviderImpl();
            }
            this.merger.setLookup(lookup);
            return this.merger;
        }
    }
}

