/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.installer.downloader.impl.SectionImpl;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.helper.MutualHashMap;
import org.netbeans.installer.utils.helper.MutualMap;

public class ChannelUtil {
    public static final int BUFFER_SIZE = 65536;
    private static final Map<FileChannel, Integer> channel2ClientsCount = new HashMap<FileChannel, Integer>();
    private static final MutualMap<File, FileChannel> file2Channel = new MutualHashMap<File, FileChannel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream channelFragmentAsStream(final File file, final SectionImpl pumpSection) throws FileNotFoundException {
        if (file == null || pumpSection == null) {
            throw new IllegalArgumentException();
        }
        File file2 = file;
        synchronized (file2) {
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            if (!file2Channel.containsKey(file)) {
                FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                file2Channel.put(file, channel);
                channel2ClientsCount.put(channel, 1);
            } else {
                FileChannel channel = (FileChannel)file2Channel.get(file);
                int count = channel2ClientsCount.get(channel);
                channel2ClientsCount.put(channel, ++count);
            }
        }
        return new OutputStream(){
            final FileChannel channel;
            final SectionImpl section;
            long position;
            long barier;
            ByteBuffer buffer;
            {
                this.channel = (FileChannel)file2Channel.get(file);
                this.section = pumpSection;
                this.position = pumpSection.offset();
                this.barier = this.section.length() > 0L ? this.section.offset() + this.section.length() : Long.MAX_VALUE;
                this.buffer = ByteBuffer.allocate(65536);
            }

            public synchronized void write(int b) throws IOException {
                if (this.position + (long)this.buffer.position() >= this.barier) {
                    return;
                }
                if (this.buffer.remaining() == 0) {
                    this.flush();
                }
                this.buffer.put((byte)b);
            }

            public synchronized void write(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || off > b.length || off + len > b.length) {
                    throw new IndexOutOfBoundsException();
                }
                while (len > 0) {
                    int length = len <= this.buffer.remaining() ? len : this.buffer.remaining();
                    long remaining = this.barier - this.position - (long)this.buffer.position();
                    if (remaining == 0L) break;
                    length = (long)length <= remaining ? length : (int)remaining;
                    this.buffer.put(b, off, length);
                    if (this.buffer.remaining() == 0) {
                        this.flush();
                    }
                    len -= length;
                    off += length;
                }
            }

            public synchronized void flush() throws IOException {
                int written = this.channel.write((ByteBuffer)this.buffer.flip(), this.position);
                this.position += (long)written;
                if (written > 0) {
                    this.section.shiftOffset(written);
                }
                this.buffer.rewind();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    if (!this.channel.isOpen()) {
                        return;
                    }
                    this.flush();
                }
                finally {
                    ChannelUtil.releaseFile(this.channel);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseFile(FileChannel channel) {
        File file = file2Channel.reversedGet(channel);
        if (file == null) {
            return;
        }
        File file2 = file;
        synchronized (file2) {
            Integer count = channel2ClientsCount.get(channel);
            if (count == null) {
                return;
            }
            if (count > 1) {
                count = count - 1;
                channel2ClientsCount.put(channel, count);
            } else {
                channel2ClientsCount.remove(channel);
                file2Channel.reversedRemove(channel);
                try {
                    channel.close();
                }
                catch (IOException ex) {
                    LogManager.log("can't close channel", (Throwable)ex);
                }
            }
        }
    }
}

