/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.ui.actions.AddGroupAction;
import org.netbeans.modules.websvc.saas.ui.actions.AddServiceAction;
import org.netbeans.modules.websvc.saas.ui.actions.DeleteGroupAction;
import org.netbeans.modules.websvc.saas.ui.actions.RenameGroupAction;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasGroupNodeChildren;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class SaasGroupNode
extends AbstractNode {
    private final SaasGroup group;
    private Image vendorIcon = null;

    public SaasGroupNode(SaasGroup group) {
        this(group, new InstanceContent());
    }

    protected SaasGroupNode(SaasGroup group, InstanceContent content) {
        super((Children)new SaasGroupNodeChildren(group), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.group = group;
        content.add((Object)group);
    }

    public String getName() {
        return this.group.getName();
    }

    public void setName(String name) {
        if (this.group.isUserDefined()) {
            super.setName(name);
            this.group.setName(name);
        }
    }

    public boolean canRename() {
        return this.group.isUserDefined();
    }

    private Image getUserDirFolderImage(int type, boolean openIcon) {
        DataFolder df;
        FileObject folder = FileUtil.toFileObject((File)new File(System.getProperty("netbeans.user")));
        if (folder != null && (df = DataFolder.findFolder((FileObject)folder)) != null) {
            return openIcon ? df.getNodeDelegate().getOpenedIcon(type) : df.getNodeDelegate().getIcon(type);
        }
        return null;
    }

    private Image getVendorIcon(int type) {
        if (this.vendorIcon == null && this.group.getServices().size() > 0) {
            this.vendorIcon = SaasUtil.loadIcon((SaasGroup)this.group, (int)type);
        }
        return this.vendorIcon;
    }

    public Image getIcon(int type) {
        Image icon = this.getVendorIcon(type);
        if (icon != null) {
            return icon;
        }
        Image standardFolderImage = this.getUserDirFolderImage(type, false);
        if (standardFolderImage != null) {
            return standardFolderImage;
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/resources/folder-closed.png");
    }

    public Image getOpenedIcon(int type) {
        Image icon = this.getVendorIcon(type);
        if (icon != null) {
            return icon;
        }
        Image standardFolderImage = this.getUserDirFolderImage(type, true);
        if (standardFolderImage != null) {
            return standardFolderImage;
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/resources/folder-open.png");
    }

    public Action[] getActions(boolean context) {
        List<Action> actions = SaasNode.getActions(this.getLookup());
        actions.add((Action)SystemAction.get(AddServiceAction.class));
        actions.add((Action)SystemAction.get(AddGroupAction.class));
        actions.add((Action)SystemAction.get(DeleteGroupAction.class));
        actions.add((Action)SystemAction.get(RenameGroupAction.class));
        return actions.toArray(new Action[actions.size()]);
    }

    public boolean canDestroy() {
        return this.group.isUserDefined();
    }

    public void destroy() throws IOException {
        SaasServicesModel.getInstance().removeGroup(this.group);
        super.destroy();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("websvcGroupNode");
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
    }
}

