/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.web.beans.api.model.AbstractModelImplementation;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.impl.model.AbstractObjectProvider;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.MemberCheckerFilter;
import org.netbeans.modules.web.beans.impl.model.ParameterInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.StereotypeChecker;
import org.netbeans.modules.web.beans.impl.model.StereotypedObject;
import org.netbeans.modules.web.beans.impl.model.StereotypedObjectProvider;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.model.spi.WebBeansModelProvider;
import org.openide.util.NbBundle;

public class WebBeansModelProviderImpl
extends ParameterInjectionPointLogic
implements WebBeansModelProvider {
    @Override
    public Result getInjectable(VariableElement variableElement, DeclaredType declaredType, AbstractModelImplementation abstractModelImplementation) {
        WebBeansModelImplementation webBeansModelImplementation = WebBeansModelProviderImpl.getImplementation(abstractModelImplementation);
        if (webBeansModelImplementation == null) {
            return null;
        }
        Element element = variableElement.getEnclosingElement();
        if (element instanceof TypeElement) {
            return this.findVariableInjectable(variableElement, declaredType, webBeansModelImplementation);
        }
        if (element instanceof ExecutableElement) {
            return this.findParameterInjectable(variableElement, declaredType, webBeansModelImplementation);
        }
        return null;
    }

    @Override
    public Result lookupInjectables(VariableElement variableElement, DeclaredType declaredType, AbstractModelImplementation abstractModelImplementation) {
        return null;
    }

    @Override
    public boolean isDynamicInjectionPoint(VariableElement variableElement, AbstractModelImplementation abstractModelImplementation) {
        return false;
    }

    @Override
    public boolean isInjectionPoint(VariableElement variableElement, AbstractModelImplementation abstractModelImplementation) throws InjectionPointDefinitionError {
        WebBeansModelImplementation webBeansModelImplementation = WebBeansModelProviderImpl.getImplementation(abstractModelImplementation);
        if (webBeansModelImplementation == null) {
            return false;
        }
        Element element = variableElement.getEnclosingElement();
        if (element instanceof TypeElement) {
            List<? extends AnnotationMirror> list = webBeansModelImplementation.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(variableElement);
            return webBeansModelImplementation.getHelper().hasAnnotation(list, "javax.inject.Inject");
        }
        if (element instanceof ExecutableElement) {
            return this.isMethodParameterInjection(variableElement, webBeansModelImplementation, (ExecutableElement)element);
        }
        return false;
    }

    private boolean isMethodParameterInjection(VariableElement variableElement, WebBeansModelImplementation webBeansModelImplementation, ExecutableElement executableElement) throws InjectionPointDefinitionError {
        List<? extends AnnotationMirror> list = webBeansModelImplementation.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(executableElement);
        if (this.isDisposeParameter(variableElement, executableElement, list, webBeansModelImplementation)) {
            return true;
        }
        if (this.isObservesParameter(variableElement, executableElement, list, webBeansModelImplementation)) {
            return true;
        }
        return webBeansModelImplementation.getHelper().hasAnnotation(list, "javax.inject.Inject") || webBeansModelImplementation.getHelper().hasAnnotation(list, "javax.enterprise.inject.Produces");
    }

    @Override
    public List<AnnotationMirror> getQualifiers(Element element, AbstractModelImplementation abstractModelImplementation) {
        WebBeansModelImplementation webBeansModelImplementation = WebBeansModelProviderImpl.getImplementation(abstractModelImplementation);
        if (webBeansModelImplementation == null) {
            return Collections.emptyList();
        }
        LinkedList<AnnotationMirror> linkedList = new LinkedList<AnnotationMirror>();
        List<? extends AnnotationMirror> list = webBeansModelImplementation.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : list) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            if (!this.isQualifier(typeElement, webBeansModelImplementation.getHelper())) continue;
            linkedList.add(annotationMirror);
        }
        return linkedList;
    }

    @Override
    public String getName(Element element, AbstractModelImplementation abstractModelImplementation) {
        WebBeansModelImplementation webBeansModelImplementation = WebBeansModelProviderImpl.getImplementation(abstractModelImplementation);
        if (webBeansModelImplementation == null) {
            return null;
        }
        String string = this.inspectSpecializes(element, webBeansModelImplementation);
        if (string != null) {
            return string;
        }
        List<AnnotationMirror> list = WebBeansModelProviderImpl.getAllStereotypes(element, webBeansModelImplementation.getHelper());
        for (AnnotationMirror annotationMirror : list) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            if (!AnnotationObjectProvider.hasAnnotation(typeElement, "javax.inject.Named", webBeansModelImplementation.getHelper())) continue;
            return this.getNamedName(element, null, webBeansModelImplementation.getHelper());
        }
        return null;
    }

    @Override
    public List<Element> getNamedElements(AbstractModelImplementation abstractModelImplementation) {
        Object object;
        Object object2;
        Object object32;
        WebBeansModelImplementation webBeansModelImplementation = WebBeansModelProviderImpl.getImplementation(abstractModelImplementation);
        if (webBeansModelImplementation == null) {
            return Collections.emptyList();
        }
        LinkedList<Element> linkedList = new LinkedList<Element>();
        Collection collection = webBeansModelImplementation.getNamedManager().getObjects();
        for (Object object32 : collection) {
            linkedList.add(object32.getTypeElement());
        }
        List<Element> list = AbstractObjectProvider.getNamedMembers(webBeansModelImplementation.getHelper());
        object32 = list.iterator();
        while (object32.hasNext()) {
            object2 = (Element)object32.next();
            if (object2.getKind() != ElementKind.METHOD) continue;
            object = this.getChildSpecializes((Element)object2, webBeansModelImplementation);
            linkedList.addAll((Collection<Element>)object);
        }
        linkedList.addAll(list);
        object32 = webBeansModelImplementation.adjustStereotypesManagers();
        object2 = object32.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            PersistentObjectManager<StereotypedObject> persistentObjectManager = webBeansModelImplementation.getStereotypedManager((String)object);
            Collection collection2 = persistentObjectManager.getObjects();
            for (StereotypedObject stereotypedObject : collection2) {
                linkedList.add(stereotypedObject.getTypeElement());
            }
            List<Element> list2 = StereotypedObjectProvider.getAnnotatedMembers((String)object, webBeansModelImplementation.getHelper());
            linkedList.addAll((Collection<Element>)list2);
        }
        return linkedList;
    }

    public static List<AnnotationMirror> getAllStereotypes(Element element, AnnotationModelHelper annotationModelHelper) {
        LinkedList<AnnotationMirror> linkedList = new LinkedList<AnnotationMirror>();
        HashSet<Element> hashSet = new HashSet<Element>();
        StereotypeChecker stereotypeChecker = new StereotypeChecker(annotationModelHelper);
        WebBeansModelProviderImpl.doGetStereotypes(element, linkedList, hashSet, stereotypeChecker, annotationModelHelper);
        return linkedList;
    }

    public static boolean isStereotype(TypeElement typeElement, StereotypeChecker stereotypeChecker) {
        stereotypeChecker.init(typeElement);
        boolean bl = stereotypeChecker.check();
        stereotypeChecker.clean();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String inspectSpecializes(Element element, WebBeansModelImplementation webBeansModelImplementation) {
        if (element instanceof TypeElement) {
            String string = this.doGetName(element, element, webBeansModelImplementation);
            if (string != null) {
                return string;
            }
            TypeElement typeElement = AnnotationObjectProvider.checkSuper((TypeElement)element, "javax.inject.Named", webBeansModelImplementation.getHelper());
            if (typeElement == null) return null;
            return this.doGetName(element, typeElement, webBeansModelImplementation);
        }
        if (!(element instanceof ExecutableElement)) return this.doGetName(element, element, webBeansModelImplementation);
        String string = this.doGetName(element, element, webBeansModelImplementation);
        if (string != null) return string;
        Element element2 = MemberCheckerFilter.getSpecialized(element, webBeansModelImplementation, "javax.inject.Named");
        if (element2 == null) return null;
        return this.doGetName(element, element2, webBeansModelImplementation);
    }

    private String doGetName(Element element, Element element2, WebBeansModelImplementation webBeansModelImplementation) {
        List<? extends AnnotationMirror> list = webBeansModelImplementation.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element2);
        for (AnnotationMirror annotationMirror : list) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            if (!"javax.inject.Named".contentEquals(typeElement.getQualifiedName())) continue;
            return this.getNamedName(element, annotationMirror, webBeansModelImplementation.getHelper());
        }
        return null;
    }

    private static void doGetStereotypes(Element element, List<AnnotationMirror> list, Set<Element> set, StereotypeChecker stereotypeChecker, AnnotationModelHelper annotationModelHelper) {
        List<? extends AnnotationMirror> list2 = annotationModelHelper.getCompilationController().getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : list2) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (set.contains(typeElement) || !WebBeansModelProviderImpl.isStereotype(typeElement, stereotypeChecker)) continue;
            set.add(typeElement);
            list.add(annotationMirror);
            WebBeansModelProviderImpl.doGetStereotypes(typeElement, list, set, stereotypeChecker, annotationModelHelper);
        }
    }

    private String getNamedName(Element element, AnnotationMirror annotationMirror, AnnotationModelHelper annotationModelHelper) {
        Object object;
        if (annotationMirror != null) {
            object = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
            object.expectString("value", null);
            ParseResult parseResult = object.parse(annotationMirror);
            String string = (String)parseResult.get("value", String.class);
            if (string != null) {
                return string;
            }
        }
        if (element instanceof TypeElement) {
            object = element.getSimpleName().toString();
            if (((String)object).length() > 0) {
                return Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            }
            return object;
        }
        if (element instanceof VariableElement) {
            return element.getSimpleName().toString();
        }
        if (element instanceof ExecutableElement) {
            object = element.getSimpleName().toString();
            if (((String)object).startsWith("get") && ((String)object).length() > 3) {
                return this.getPropertyName((String)object, 3);
            }
            if (((String)object).startsWith("is") && ((String)object).length() > 2) {
                return this.getPropertyName((String)object, 2);
            }
            return object;
        }
        return null;
    }

    private String getPropertyName(String string, int n) {
        String string2 = string.substring(n);
        String string3 = string2.substring(1);
        if (string3.length() > 0 && string3.equals(string3.toUpperCase())) {
            return string2;
        }
        return Character.toLowerCase(string2.charAt(0)) + string3;
    }

    private static WebBeansModelImplementation getImplementation(AbstractModelImplementation abstractModelImplementation) {
        WebBeansModelImplementation webBeansModelImplementation = null;
        try {
            webBeansModelImplementation = (WebBeansModelImplementation)abstractModelImplementation;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return webBeansModelImplementation;
    }

    private boolean isObservesParameter(VariableElement variableElement, ExecutableElement executableElement, List<? extends AnnotationMirror> list, AbstractModelImplementation abstractModelImplementation) throws InjectionPointDefinitionError {
        List<? extends VariableElement> list2 = executableElement.getParameters();
        boolean bl = false;
        for (VariableElement variableElement2 : list2) {
            if (!AnnotationObjectProvider.hasAnnotation(variableElement2, "javax.enterprise.event.Observes", WebBeansModelProviderImpl.getImplementation(abstractModelImplementation).getHelper())) continue;
            if (bl) {
                throw new InjectionPointDefinitionError(executableElement, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_MultipleObserves", (Object)executableElement.getSimpleName()));
            }
            bl = true;
        }
        if (!bl) {
            return false;
        }
        String string = this.checkInjectProducers(list, abstractModelImplementation);
        if (string != null) {
            throw new InjectionPointDefinitionError(executableElement, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_ObserverHasInjectOrProduces", (Object)executableElement.getSimpleName(), (Object)string));
        }
        return bl;
    }

    private boolean isDisposeParameter(VariableElement variableElement, ExecutableElement executableElement, List<? extends AnnotationMirror> list, AbstractModelImplementation abstractModelImplementation) throws InjectionPointDefinitionError {
        List<? extends VariableElement> list2 = executableElement.getParameters();
        boolean bl = false;
        boolean bl2 = false;
        for (VariableElement variableElement2 : list2) {
            if (AnnotationObjectProvider.hasAnnotation(variableElement2, "javax.enterprise.inject.Disposes", WebBeansModelProviderImpl.getImplementation(abstractModelImplementation).getHelper())) {
                if (bl) {
                    throw new InjectionPointDefinitionError(executableElement, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_MultipleDisposes", (Object)executableElement.getSimpleName()));
                }
                bl = true;
            }
            if (!AnnotationObjectProvider.hasAnnotation(variableElement2, "javax.enterprise.event.Observes", WebBeansModelProviderImpl.getImplementation(abstractModelImplementation).getHelper())) continue;
            bl2 = true;
        }
        if (!bl) {
            return false;
        }
        if (bl2) {
            throw new InjectionPointDefinitionError(executableElement, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_DisposesHasObserves", (Object)executableElement.getSimpleName()));
        }
        String string = this.checkInjectProducers(list, abstractModelImplementation);
        if (string != null) {
            throw new InjectionPointDefinitionError(executableElement, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_DisposesHasInjectOrProduces", (Object)executableElement.getSimpleName(), (Object)string));
        }
        return bl;
    }

    private String checkInjectProducers(List<? extends AnnotationMirror> list, AbstractModelImplementation abstractModelImplementation) {
        if (WebBeansModelProviderImpl.getImplementation(abstractModelImplementation).getHelper().hasAnnotation(list, "javax.inject.Inject")) {
            return "javax.inject.Inject";
        }
        if (WebBeansModelProviderImpl.getImplementation(abstractModelImplementation).getHelper().hasAnnotation(list, "javax.enterprise.inject.Produces")) {
            return "javax.enterprise.inject.Produces";
        }
        return null;
    }
}

