/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public final class TemplateDescriptor {
    private final Collection<CsmUID<CsmTemplateParameter>> templateParams;
    private final CharSequence templateSuffix;
    private final int inheritedTemplateParametersNumber;

    public TemplateDescriptor(List<CsmTemplateParameter> list, CharSequence charSequence, boolean bl) {
        this(list, charSequence, 0, bl);
    }

    public TemplateDescriptor(List<CsmTemplateParameter> list, CharSequence charSequence, int n, boolean bl) {
        this.register(list, bl);
        this.templateParams = UIDCsmConverter.objectsToUIDs(list);
        this.templateSuffix = NameCache.getManager().getString(charSequence);
        this.inheritedTemplateParametersNumber = n;
    }

    private void register(List<CsmTemplateParameter> list, boolean bl) {
        for (CsmTemplateParameter csmTemplateParameter : list) {
            if (bl) {
                RepositoryUtils.put(csmTemplateParameter);
                continue;
            }
            Utils.setSelfUID((CsmObject)csmTemplateParameter);
        }
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        if (this.templateParams != null) {
            ArrayList<CsmTemplateParameter> arrayList = new ArrayList<CsmTemplateParameter>();
            for (CsmTemplateParameter csmTemplateParameter : UIDCsmConverter.UIDsToCsmObjects(this.templateParams)) {
                arrayList.add(csmTemplateParameter);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public CharSequence getTemplateSuffix() {
        return this.templateSuffix;
    }

    public int getInheritedTemplateParametersNumber() {
        return this.inheritedTemplateParametersNumber;
    }

    public static TemplateDescriptor createIfNeeded(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl) {
        AST aST2;
        if (aST == null) {
            return null;
        }
        for (AST aST3 = aST2 = TemplateUtils.getTemplateStart(aST.getFirstChild()); aST3 != null; aST3 = aST3.getNextSibling()) {
            if (aST3.getType() != 114) continue;
            return new TemplateDescriptor(TemplateUtils.getTemplateParameters(aST3, csmFile, csmScope, bl), '<' + TemplateUtils.getClassSpecializationSuffix(aST3, null) + '>', bl);
        }
        return null;
    }

    public String toString() {
        return ((Object)this.getTemplateSuffix()).toString();
    }

    public TemplateDescriptor(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        this.templateParams = n < 0 ? null : UIDObjectFactory.getDefaultFactory().readUIDCollection(new ArrayList(n), dataInput, n);
        this.templateSuffix = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        this.inheritedTemplateParametersNumber = dataInput.readInt();
    }

    public void write(DataOutput dataOutput) throws IOException {
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.templateParams, dataOutput, false);
        PersistentUtils.writeUTF(this.templateSuffix, dataOutput);
        dataOutput.writeInt(this.inheritedTemplateParametersNumber);
    }
}

