/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints;

import java.io.IOException;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public final class ErrorDescription {
    private final String description;
    private final Severity severity;
    private final LazyFixList fixes;
    private final PositionBounds span;
    private final FileObject file;

    ErrorDescription(FileObject file, String description, Severity severity, LazyFixList fixes, PositionBounds span) {
        this.description = description;
        this.severity = severity;
        this.fixes = fixes;
        this.span = span;
        this.file = file;
    }

    public String getDescription() {
        return this.description;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public LazyFixList getFixes() {
        return this.fixes;
    }

    public PositionBounds getRange() {
        return this.span;
    }

    public FileObject getFile() {
        return this.file;
    }

    public String toString() {
        try {
            return this.span.getBegin().getLine() + ":" + this.span.getBegin().getColumn() + "-" + this.span.getEnd().getLine() + ":" + this.span.getEnd().getColumn() + ":" + this.severity.getDisplayName() + ":" + this.description;
        }
        catch (IOException ex) {
            throw (IllegalStateException)new IllegalStateException().initCause(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorDescription other = (ErrorDescription)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (!(this.severity == other.severity || this.severity != null && this.severity.equals((Object)other.severity))) {
            return false;
        }
        if (this.span.getBegin().getOffset() != other.span.getBegin().getOffset()) {
            return false;
        }
        if (this.span.getEnd().getOffset() != other.span.getEnd().getOffset()) {
            return false;
        }
        return this.file == other.file || this.file != null && this.file.equals(other.file);
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 17 * hash + (this.severity != null ? this.severity.hashCode() : 0);
        hash = 17 * hash + this.span.getBegin().getOffset();
        hash = 17 * hash + this.span.getEnd().getOffset();
        hash = 17 * hash + (this.file != null ? this.file.hashCode() : 0);
        return hash;
    }
}

