/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEjbGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableProvider;

public class DBSchemaTableProvider
implements TableProvider {
    private final SchemaElement schemaElement;
    private final PersistenceGenerator persistenceGen;
    private final Set<Table> tables;
    private Set<String> tablesReferecedByOtherTables;

    public DBSchemaTableProvider(SchemaElement schemaElement, PersistenceGenerator persistenceGenerator) {
        this.schemaElement = schemaElement;
        this.persistenceGen = persistenceGenerator;
        this.tablesReferecedByOtherTables = DbSchemaEjbGenerator.getTablesReferecedByOtherTables(schemaElement);
        this.tables = this.buildTables();
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    private Set<Table> buildTables() {
        Object object;
        Object object2;
        HashMap<String, DBSchemaTable> hashMap = new HashMap<String, DBSchemaTable>();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        TableElement[] tableElementArray = this.schemaElement.getTables();
        for (Object object3 : tableElementArray) {
            Object object4;
            boolean bl = DbSchemaEjbGenerator.isJoinTable(object3, this.tablesReferecedByOtherTables);
            object2 = DBSchemaTableProvider.getDisabledReasons(object3, this.persistenceGen);
            object = null;
            Iterator<Table.DisabledReason> iterator = object2.iterator();
            while (iterator.hasNext()) {
                object4 = iterator.next();
                if (bl && object4 instanceof Table.NoPrimaryKeyDisabledReason) continue;
                object = object4;
                break;
            }
            String object5 = object3.getDeclaringSchema().getCatalog().getName();
            object4 = object3.getDeclaringSchema().getSchema().getName();
            String string = object3.getName().getName();
            DBSchemaTable dBSchemaTable = new DBSchemaTable(object5, (String)object4, string, bl, (Table.DisabledReason)object, this.persistenceGen, object3.isTable());
            dBSchemaTable.setUniqueConstraints(this.getUniqueConstraints((TableElement)object3));
            hashMap.put(string, dBSchemaTable);
            hashMap2.put(string, new HashSet());
            hashMap3.put(string, new HashSet());
            hashMap4.put(string, new HashSet());
        }
        for (Object object3 : tableElementArray) {
            if (!object3.isTable()) continue;
            String string = object3.getName().getName();
            object2 = (Table)hashMap.get(string);
            object = object3.getForeignKeys();
            if (object == null) continue;
            for (ForeignKeyElement foreignKeyElement : object) {
                TableElement tableElement = foreignKeyElement.getReferencedTable();
                String string2 = tableElement.getName().getName();
                Table table = (Table)hashMap.get(string2);
                ((Set)hashMap2.get(string)).add(table);
                ((Set)hashMap3.get(string2)).add(object2);
                if (!((Table)object2).isJoin()) continue;
                ((Set)hashMap4.get(string2)).add(object2);
            }
        }
        HashSet hashSet = new HashSet();
        for (DBSchemaTable dBSchemaTable : hashMap.values()) {
            Object object3;
            object3 = dBSchemaTable.getName();
            dBSchemaTable.setReferencedTables(Collections.unmodifiableSet((Set)hashMap2.get(object3)));
            dBSchemaTable.setReferencedByTables(Collections.unmodifiableSet((Set)hashMap3.get(object3)));
            dBSchemaTable.setJoinTables(Collections.unmodifiableSet((Set)hashMap4.get(object3)));
            hashSet.add(dBSchemaTable);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private Set<List<String>> getUniqueConstraints(TableElement tableElement) {
        HashSet<List<String>> hashSet = new HashSet<List<String>>();
        UniqueKeyElement[] uniqueKeyElementArray = tableElement.getUniqueKeys();
        for (int i = 0; i < uniqueKeyElementArray.length; ++i) {
            ColumnElement[] columnElementArray;
            if (uniqueKeyElementArray[i].isPrimaryKey() || (columnElementArray = uniqueKeyElementArray[i].getColumns()) == null || columnElementArray.length == 0) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int j = 0; j < columnElementArray.length; ++j) {
                arrayList.add(columnElementArray[j].getName().getName());
            }
            hashSet.add(arrayList);
        }
        return hashSet;
    }

    private static List<Table.DisabledReason> getDisabledReasons(TableElement tableElement, PersistenceGenerator persistenceGenerator) {
        String string;
        ArrayList<Table.DisabledReason> arrayList = new ArrayList<Table.DisabledReason>();
        if (tableElement.isTable() && DBSchemaTableProvider.hasNoPrimaryKey(tableElement)) {
            arrayList.add(new Table.NoPrimaryKeyDisabledReason());
        }
        if ((string = persistenceGenerator.getFQClassName(tableElement.getName().getName())) != null) {
            arrayList.add(new Table.ExistingDisabledReason(string));
        }
        return arrayList;
    }

    private static boolean hasNoPrimaryKey(TableElement tableElement) {
        return tableElement.getPrimaryKey() == null;
    }

    private static final class DBSchemaTable
    extends Table {
        private final PersistenceGenerator persistenceGen;
        private Set<Table> referencedTables;
        private Set<Table> referencedByTables;
        private Set<Table> joinTables;
        private Set<List<String>> uniqueConstraints;

        public DBSchemaTable(String string, String string2, String string3, boolean bl, Table.DisabledReason disabledReason, PersistenceGenerator persistenceGenerator) {
            super(string, string2, string3, bl, disabledReason);
            this.persistenceGen = persistenceGenerator;
        }

        public DBSchemaTable(String string, String string2, String string3, boolean bl, Table.DisabledReason disabledReason, PersistenceGenerator persistenceGenerator, boolean bl2) {
            super(string, string2, string3, bl, disabledReason, bl2);
            this.persistenceGen = persistenceGenerator;
        }

        @Override
        public Set<Table> getReferencedTables() {
            return this.referencedTables;
        }

        private void setReferencedTables(Set<Table> set) {
            this.referencedTables = set;
        }

        @Override
        public Set<Table> getReferencedByTables() {
            return this.referencedByTables;
        }

        private void setReferencedByTables(Set<Table> set) {
            this.referencedByTables = set;
        }

        @Override
        public Set<Table> getJoinTables() {
            return this.joinTables;
        }

        private void setJoinTables(Set<Table> set) {
            this.joinTables = set;
        }

        @Override
        public Set<List<String>> getUniqueConstraints() {
            return this.uniqueConstraints;
        }

        public void setUniqueConstraints(Set<List<String>> set) {
            this.uniqueConstraints = set;
        }
    }
}

