/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.debugger.registry;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DebuggerServiceRegistration;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DebuggerProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(ActionsProvider.Registration.class.getCanonicalName(), DebuggerEngineProvider.Registration.class.getCanonicalName(), SessionProvider.Registration.class.getCanonicalName(), LazyActionsManagerListener.Registration.class.getCanonicalName(), DebuggerServiceRegistration.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment env) throws LayerGenerationException {
        String path;
        Annotation reg;
        if (env.processingOver()) {
            return false;
        }
        int cnt = 0;
        for (Element element : env.getElementsAnnotatedWith(ActionsProvider.Registration.class)) {
            reg = element.getAnnotation(ActionsProvider.Registration.class);
            path = reg.path();
            String[] actions = reg.actions();
            String[] stringArray = reg.activateForMIMETypes();
            this.handleProviderRegistrationInner(element, ActionsProvider.class, path, actions, stringArray);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(LazyActionsManagerListener.Registration.class)) {
            reg = element.getAnnotation(LazyActionsManagerListener.Registration.class);
            path = reg.path();
            this.handleProviderRegistrationInner(element, LazyActionsManagerListener.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(DebuggerEngineProvider.Registration.class)) {
            reg = element.getAnnotation(DebuggerEngineProvider.Registration.class);
            path = reg.path();
            this.handleProviderRegistrationInner(element, DebuggerEngineProvider.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(SessionProvider.Registration.class)) {
            reg = element.getAnnotation(SessionProvider.Registration.class);
            path = reg.path();
            this.handleProviderRegistrationInner(element, SessionProvider.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(DebuggerServiceRegistration.class)) {
            reg = element.getAnnotation(DebuggerServiceRegistration.class);
            String classNames = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(DebuggerServiceRegistration.class.getName())) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                for (ExecutableElement executableElement : elementValues.keySet()) {
                    if (!executableElement.getSimpleName().contentEquals("types")) continue;
                    classNames = elementValues.get(executableElement).getValue().toString();
                }
            }
            if (!this.implementsInterfaces(element, classNames = this.translateClassNames(classNames))) {
                throw new IllegalArgumentException("Annotated element " + element + " does not implement all interfaces " + classNames);
            }
            String path2 = reg.path();
            path2 = path2 != null && path2.length() > 0 ? "Debugger/" + path2 : "Debugger";
            this.layer(new Element[]{element}).instanceFile(path2, null, null).stringvalue("serviceName", this.instantiableClassOrMethod(element)).stringvalue("instanceOf", classNames).methodvalue("instanceCreate", "org.netbeans.spi.debugger.ContextAwareSupport", "createService").write();
            ++cnt;
        }
        return cnt == annotations.size();
    }

    private void handleProviderRegistrationInner(Element e, Class providerClass, String path) throws IllegalArgumentException, LayerGenerationException {
        this.handleProviderRegistrationInner(e, providerClass, path, null, null);
    }

    private void handleProviderRegistrationInner(Element e, Class providerClass, String path, String[] actions, String[] enabledOnMIMETypes) throws IllegalArgumentException, LayerGenerationException {
        String className = this.instantiableClassOrMethod(e);
        if (!this.isClassOf(e, providerClass)) {
            throw new IllegalArgumentException("Annotated element " + e + " is not an instance of " + providerClass);
        }
        path = path != null && path.length() > 0 ? "Debugger/" + path : "Debugger";
        LayerBuilder.File f = this.layer(new Element[]{e}).instanceFile(path, null, providerClass).stringvalue("serviceName", className).stringvalue("serviceClass", providerClass.getName());
        if (actions != null && actions.length > 0) {
            f.stringvalue("debugger_actions", Arrays.toString(actions));
        }
        if (enabledOnMIMETypes != null && enabledOnMIMETypes.length > 0) {
            f.stringvalue("debugger_activateForMIMETypes", Arrays.toString(enabledOnMIMETypes));
        }
        f.stringvalue("instanceOf", providerClass.getName());
        f.methodvalue("instanceCreate", providerClass.getName() + "$ContextAware", "createService");
        f.write();
    }

    private boolean isClassOf(Element e, Class providerClass) {
        switch (e.getKind()) {
            case CLASS: {
                TypeElement te = (TypeElement)e;
                TypeMirror superType = te.getSuperclass();
                if (superType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)superType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
            case METHOD: {
                TypeMirror retType = ((ExecutableElement)e).getReturnType();
                if (retType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)retType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }

    private boolean implementsInterfaces(Element e, String classNames) {
        HashSet<String> interfaces = new HashSet<String>(Arrays.asList(classNames.split("[, ]+")));
        return this.implementsInterfaces(e, interfaces);
    }

    private boolean implementsInterfaces(Element e, Set<String> interfaces) {
        switch (e.getKind()) {
            case CLASS: 
            case INTERFACE: {
                TypeElement te = (TypeElement)e;
                List<? extends TypeMirror> interfs = te.getInterfaces();
                for (TypeMirror typeMirror : interfs) {
                    e = ((DeclaredType)typeMirror).asElement();
                    String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                    boolean contains = interfaces.remove(string);
                    if (contains) continue;
                    this.implementsInterfaces(e, interfaces);
                }
                break;
            }
            case METHOD: {
                TypeMirror retType = ((ExecutableElement)e).getReturnType();
                if (retType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                TypeElement te = (TypeElement)((DeclaredType)retType).asElement();
                List<? extends TypeMirror> interfs = te.getInterfaces();
                for (TypeMirror typeMirror : interfs) {
                    e = ((DeclaredType)typeMirror).asElement();
                    String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                    interfaces.remove(clazz);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
            }
        }
        return interfaces.isEmpty();
    }

    private String instantiableClassOrMethod(Element e) throws IllegalArgumentException, LayerGenerationException {
        switch (e.getKind()) {
            case CLASS: {
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(clazz + " must not be abstract", e);
                }
                boolean hasDefaultCtor = false;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(e.getEnclosedElements())) {
                    if (!constructor.getParameters().isEmpty()) continue;
                    hasDefaultCtor = true;
                    break;
                }
                if (!hasDefaultCtor) {
                    throw new LayerGenerationException(clazz + " must have a no-argument constructor", e);
                }
                return clazz;
            }
            case METHOD: {
                ExecutableElement ee = (ExecutableElement)e;
                String methodName = ee.getSimpleName().toString();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)ee.getEnclosingElement()).toString();
                if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(ee + " must be static", e);
                }
                if (ee.getParameters().size() > 0) {
                    throw new LayerGenerationException(ee + " must not have any parameters", e);
                }
                return clazz + "." + methodName + "()";
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }

    private String translateClassNames(String classNames) {
        int i2;
        StringBuilder builder = new StringBuilder();
        int i1 = 0;
        while ((i2 = classNames.indexOf(44, i1)) > 0) {
            if (i1 > 0) {
                builder.append(',');
            }
            builder.append(this.translateClass(classNames.substring(i1, i2).trim()));
            i1 = i2 + 1;
        }
        if (i1 > 0) {
            builder.append(',');
        }
        builder.append(this.translateClass(classNames.substring(i1).trim()));
        return builder.toString();
    }

    private String translateClass(String className) {
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - ".class".length());
        }
        TypeElement type = this.processingEnv.getElementUtils().getTypeElement(className);
        return this.processingEnv.getElementUtils().getBinaryName(type).toString();
    }
}

