/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpointEvent;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpointListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public abstract class CndBreakpoint
extends Breakpoint {
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_THREAD_ID = "threadID";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final String PROP_BREAKPOINT_STATE = "breakpointState";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_URL = "url";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_SKIP_COUNT = "skipCount";
    public static final int SUSPEND_NONE = 0;
    public static final int SUSPEND_THREAD = 1;
    public static final int SUSPEND_ALL = 2;
    private int lineNumber;
    private boolean enabled = true;
    private boolean hidden = false;
    private boolean temporary = false;
    private int suspend = 2;
    private String threadID = "1";
    private String printText;
    private final Set<CndBreakpointListener> breakpointListeners = new CopyOnWriteArraySet<CndBreakpointListener>();
    private String condition = "";
    private int skipCount = 0;
    private String url = "";
    private String path = "";

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int ln) {
        this.setLineNumber(ln, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLineNumber(int ln, boolean noOld) {
        int old;
        CndBreakpoint cndBreakpoint = this;
        synchronized (cndBreakpoint) {
            if (ln == this.lineNumber) {
                return;
            }
            old = this.lineNumber;
            this.lineNumber = ln;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, noOld ? null : Integer.valueOf(old), ln);
    }

    public void setLineNumberNoOld(int ln) {
        this.setLineNumber(ln, true);
    }

    public void validityChanged() {
        this.firePropertyChange("validity", 0, 1);
    }

    public void setValid() {
        this.setValidity(Breakpoint.VALIDITY.VALID, null);
    }

    public void setInvalid(String msg) {
        this.setValidity(Breakpoint.VALIDITY.INVALID, msg);
    }

    public String getPath() {
        return this.path;
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String url) {
        CndBreakpoint cndBreakpoint = this;
        synchronized (cndBreakpoint) {
            block12: {
                if (url != null && this.url != null && url.equals(this.url)) {
                    return;
                }
                if (!(url = url.replace(" ", "%20")).startsWith("file:/")) {
                    url = url.charAt(0) == '/' ? "file:" + url : "file:/" + Character.toUpperCase(url.charAt(0)) + url.substring(1);
                }
                url = url.replace("\\", "/");
                try {
                    assert (url != null || !Boolean.getBoolean("gdb.assertions.enabled"));
                    FileObject fo = URLMapper.findFileObject((URL)new URL(url));
                    if (fo != null) {
                        this.path = FileUtil.toFile((FileObject)fo).getAbsolutePath();
                        if (Utilities.isWindows()) {
                            this.path = this.path.replace("\\", "/");
                        }
                    }
                }
                catch (MalformedURLException mue) {
                    assert (!Boolean.getBoolean("gdb.assertions.enabled"));
                    return;
                }
                catch (Exception ex) {
                    if ($assertionsDisabled || !Boolean.getBoolean("gdb.assertions.enabled")) break block12;
                    throw new AssertionError();
                }
            }
            String old = this.url;
            this.url = url;
            this.firePropertyChange(PROP_URL, old, url);
        }
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String c) {
        String old;
        CndBreakpoint cndBreakpoint = this;
        synchronized (cndBreakpoint) {
            if (c == null) {
                c = "";
            }
            if ((c = c.trim()).equals(this.condition) || c != null && this.condition != null && this.condition.equals(c)) {
                return;
            }
            old = this.condition;
            this.condition = c;
        }
        this.firePropertyChange(PROP_CONDITION, old, c);
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(int skipCount) {
        int old = this.skipCount;
        if (skipCount != old) {
            this.skipCount = skipCount;
            this.firePropertyChange(PROP_SKIP_COUNT, old, skipCount);
        }
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int s) {
        this.setSuspend(s, "");
    }

    public void setSuspend(int s, String threadID) {
        if (s == this.suspend && this.threadID.equals(threadID)) {
            return;
        }
        if (threadID.length() == 0) {
            threadID = this.threadID;
        }
        String old = Integer.toString(this.suspend) + ':' + this.threadID;
        String nu = Integer.toString(s) + ':' + threadID;
        this.suspend = s;
        this.threadID = threadID;
        this.firePropertyChange(PROP_SUSPEND, old, nu);
    }

    public String getThreadID() {
        return this.threadID;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean h) {
        if (h == this.hidden) {
            return;
        }
        boolean old = this.hidden;
        this.hidden = h;
        this.firePropertyChange(PROP_HIDDEN, old, h);
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary() {
        this.temporary = true;
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String printText) {
        if (printText == null || printText.equals(this.printText)) {
            return;
        }
        String old = this.printText;
        this.printText = printText;
        this.firePropertyChange(PROP_PRINT_TEXT, old, printText);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public synchronized void addCndBreakpointListener(CndBreakpointListener listener) {
        this.breakpointListeners.add(listener);
    }

    public synchronized void removeCndBreakpointListener(CndBreakpointListener listener) {
        this.breakpointListeners.remove(listener);
    }

    public void fireCndBreakpointChange(CndBreakpointEvent event) {
        for (CndBreakpointListener listener : this.breakpointListeners) {
            listener.breakpointReached(event);
        }
    }
}

