/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints.customizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ActionsPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ConditionsPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ControllerProvider;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class FunctionBreakpointPanel
extends JPanel
implements Controller,
ControllerProvider {
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private FunctionBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JLabel lFunctionName;
    private JPanel pActions;
    private JPanel pConditions;
    private JPanel pSettings;
    private JTextField tfFunctionName;

    private static FunctionBreakpoint createBreakpoint() {
        return FunctionBreakpoint.create("main");
    }

    public FunctionBreakpointPanel() {
        this(FunctionBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public FunctionBreakpointPanel(FunctionBreakpoint b) {
        this.breakpoint = b;
        this.initComponents();
        this.tfFunctionName.setText(b.getFunctionName());
        this.conditionsPanel = new ConditionsPanel(b);
        this.pConditions.add(this.conditionsPanel);
        this.actionsPanel = new ActionsPanel(b);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.lFunctionName = new JLabel();
        this.tfFunctionName = new JTextField();
        this.pConditions = new JPanel();
        this.pActions = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(bundle.getString("L_Function_Breakpoint_BorderTitle")));
        this.pSettings.setMinimumSize(new Dimension(249, 80));
        this.pSettings.setLayout(new GridBagLayout());
        this.lFunctionName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle").getString("MN_L_Function_Breakpoint_Function_Name").charAt(0));
        this.lFunctionName.setLabelFor(this.tfFunctionName);
        this.lFunctionName.setText(bundle.getString("L_Function_Breakpoint_Function_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.lFunctionName, gridBagConstraints);
        this.lFunctionName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_L_Function_Breakpoint_Function_Name"));
        this.tfFunctionName.setToolTipText(bundle.getString("TTT_TF_Function_Breakpoint_Function_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFunctionName, gridBagConstraints);
        this.tfFunctionName.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_TF_Function_Breakpoint_Function_Name"));
        this.tfFunctionName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TF_Function_Breakpoint_Function_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pConditions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pConditions, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
    }

    public boolean ok() {
        String msg = this.valiadateMsg();
        if (msg != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            return false;
        }
        this.conditionsPanel.ok();
        this.actionsPanel.ok();
        String functionName = this.tfFunctionName.getText().trim();
        this.breakpoint.setFunctionName(functionName);
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        Breakpoint[] bs = dm.getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            String condition;
            FunctionBreakpoint fb;
            if (!(bs[i] instanceof FunctionBreakpoint) || !functionName.equals((fb = (FunctionBreakpoint)bs[i]).getFunctionName()) || ((condition = this.breakpoint.getCondition()) == null ? fb.getCondition() != null : !condition.equals(fb.getCondition()))) continue;
            if (!fb.isEnabled()) {
                bs[i].enable();
            }
            return true;
        }
        if (this.createBreakpoint) {
            dm.addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    private String valiadateMsg() {
        String function = this.tfFunctionName.getText().trim();
        if (function.length() == 0) {
            return NbBundle.getBundle(FunctionBreakpointPanel.class).getString("MSG_No_Function_Name_Spec");
        }
        return null;
    }

    @Override
    public Controller getController() {
        return this;
    }
}

