/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.mobility.antext.Base64;
import org.netbeans.mobility.antext.Bundle;

public class JadTask
extends Task {
    private static final String LIBLET_NAME = "LIBlet-Name";
    private static final String MIDLET_PREFIX = "MIDlet-";
    private static final String LIBLET_PREFIX = "LIBlet-";
    private static final String[] MIDLET_TEST_KEYS = new String[]{"MicroEdition-Configuration", "MicroEdition-Profile", "MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version"};
    private static final String[] LIBLET_TEST_KEYS = new String[]{"MicroEdition-Configuration", "MicroEdition-Profile", "LIBlet-Name", "LIBlet-Vendor", "LIBlet-Version"};
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String JAR_URL_KEY = "Jar-URL";
    private static final String JAR_SIZE_KEY = "Jar-Size";
    private static final String JAR_RSA_SHA1 = "MIDlet-Jar-RSA-SHA1";
    private static final String LIBLET_JAR_SHA1 = "LIBlet-Jar-SHA1";
    private static final String CERTIFICATE = "MIDlet-Certificate-{0}-{1}";
    private static final String SHA1withRSA = "SHA1withRSA";
    private static final String SHA1 = "SHA-1";
    private static final String MIDLET_1 = "MIDlet-1";
    private static final String PKCS12 = "PKCS12";
    private File jadFile;
    private File jarFile;
    private File output;
    private String url;
    private String encoding;
    private boolean sign = false;
    private File keyStore = null;
    private String keyStoreType = null;
    private String keyStorePassword = null;
    private String alias = null;
    private String aliasPassword = null;
    private static final String ERR_MissingAttr = "ERR_MissingAttr";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File jadTo;
        if (this.jadFile == null) {
            throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "jadFile"));
        }
        if (this.jarFile == null) {
            throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "jarFile"));
        }
        File jadFrom = this.jadFile;
        File file = jadTo = this.output != null ? this.output : this.jadFile;
        if (!jadFrom.isFile()) {
            throw new BuildException(Bundle.getMessage("ERR_SourceIsMissing", jadFrom.toString()));
        }
        if (!this.jarFile.isFile()) {
            throw new BuildException(Bundle.getMessage("ERR_JarFileIsMissing", this.jarFile.toString()));
        }
        try {
            String prefix;
            this.log(Bundle.getMessage("MSG_Updating", jadTo.getAbsolutePath()), 2);
            this.log(Bundle.getMessage("MSG_Loading", jadFrom.toString()), 3);
            HashMap<String, String> hash = new HashMap<String, String>();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jadFrom), this.encoding != null ? this.encoding : DEFAULT_ENCODING));
            try {
                String readLine;
                while ((readLine = br.readLine()) != null) {
                    if ("".equals(readLine) || readLine.startsWith("#")) continue;
                    int colon = readLine.indexOf(58);
                    if (colon < 0) {
                        this.log(Bundle.getMessage("WARN_InvalidLineFormat", readLine), 1);
                        continue;
                    }
                    hash.put(readLine.substring(0, colon), readLine.substring(colon + 1).trim());
                }
            }
            finally {
                br.close();
            }
            boolean isLiblet = hash.containsKey(LIBLET_NAME);
            String string = prefix = isLiblet ? LIBLET_PREFIX : MIDLET_PREFIX;
            if (!isLiblet && !hash.containsKey(MIDLET_1)) {
                this.log(Bundle.getMessage("WARN_MissingMIDlets"), 1);
            }
            String[] testKeys = isLiblet ? LIBLET_TEST_KEYS : MIDLET_TEST_KEYS;
            for (int i = 0; i < testKeys.length; ++i) {
                if (hash.containsKey(testKeys[i])) continue;
                this.log(Bundle.getMessage("WARN_MissingAttribute", testKeys[i]), 1);
            }
            if (this.url == null) {
                if (!hash.containsKey(prefix + JAR_URL_KEY)) {
                    String jarname = this.jarFile.getName();
                    this.log(Bundle.getMessage("WARN_MissingURL", prefix + JAR_URL_KEY, jarname), 1);
                    hash.put(prefix + JAR_URL_KEY, jarname);
                }
            } else {
                this.log(Bundle.getMessage("MSG_SettingAttribute", prefix + JAR_URL_KEY, this.url), 3);
                hash.put(prefix + JAR_URL_KEY, this.url);
            }
            String jarsize = String.valueOf(this.jarFile.length());
            this.log(Bundle.getMessage("MSG_JarSize", this.jarFile.getAbsolutePath(), jarsize), 2);
            this.log(Bundle.getMessage("MSG_SettingAttribute", prefix + JAR_SIZE_KEY, jarsize), 3);
            hash.put(prefix + JAR_SIZE_KEY, jarsize);
            if (this.sign && !isLiblet) {
                Signature signature;
                Key key;
                Certificate[] certs;
                KeyStore store;
                if (this.keyStore == null || !this.keyStore.exists() || !this.keyStore.isFile()) {
                    throw new BuildException(Bundle.getMessage(ERR_MissingAttr, this.keyStore == null ? "keystore" : this.keyStore.getAbsolutePath()));
                }
                if (this.keyStorePassword == null) {
                    throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "keyStorePassword"));
                }
                if (this.alias == null) {
                    throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "alias"));
                }
                if (this.aliasPassword == null) {
                    throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "aliasPassword"));
                }
                this.log(Bundle.getMessage("MSG_Signing"), 2);
                try {
                    String name;
                    if (this.keyStoreType == null && ((name = this.keyStore.getAbsolutePath().toLowerCase()).endsWith(".p12") || name.endsWith(".pkcs12"))) {
                        this.keyStoreType = PKCS12;
                    }
                    store = this.keyStoreType != null && PKCS12.equals(this.keyStoreType) ? KeyStore.getInstance("pkcs12", "SunJSSE") : KeyStore.getInstance("JKS", "SUN");
                }
                catch (NoSuchProviderException e) {
                    throw new BuildException(Bundle.getMessage("ERR_UnsupportedKeyStoreProvider", this.keyStoreType != null ? this.keyStoreType : "default"), (Throwable)e);
                }
                catch (KeyStoreException e) {
                    throw new BuildException(Bundle.getMessage("ERR_UnsupportedKeyStoreType", this.keyStoreType != null ? this.keyStoreType : "default"), (Throwable)e);
                }
                FileInputStream stream = new FileInputStream(this.keyStore);
                try {
                    store.load(stream, this.keyStorePassword.toCharArray());
                }
                catch (IOException e) {
                    throw new BuildException(Bundle.getMessage("ERR_ErrorLoadingKeyStore", this.keyStore.getAbsolutePath()), (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new BuildException(Bundle.getMessage("ERR_ErrorLoadingKeyStore", this.keyStore.getAbsolutePath()), (Throwable)e);
                }
                catch (CertificateException e) {
                    throw new BuildException(Bundle.getMessage("ERR_ErrorLoadingKeyStore", this.keyStore.getAbsolutePath()), (Throwable)e);
                }
                finally {
                    ((InputStream)stream).close();
                }
                hash.remove(JAR_RSA_SHA1);
                int a = 1;
                while (true) {
                    int b = 1;
                    while (hash.remove(MessageFormat.format(CERTIFICATE, Integer.toString(a), Integer.toString(b))) != null) {
                        ++b;
                    }
                    if (b <= 1) break;
                    ++a;
                }
                try {
                    certs = store.getCertificateChain(this.alias);
                    key = store.getKey(this.alias, this.aliasPassword.toCharArray());
                }
                catch (UnrecoverableKeyException e) {
                    e.printStackTrace();
                    certs = null;
                    key = null;
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    certs = null;
                    key = null;
                }
                catch (KeyStoreException e) {
                    e.printStackTrace();
                    certs = null;
                    key = null;
                }
                if (certs == null || key == null) {
                    throw new BuildException(Bundle.getMessage("ERR_NoCertificateOrAlgorithm", this.alias));
                }
                for (int a2 = 0; a2 < certs.length; ++a2) {
                    Certificate cert = certs[a2];
                    String certAttr = MessageFormat.format(CERTIFICATE, "1", Integer.toString(a2 + 1));
                    this.log(Bundle.getMessage("MSG_AddingCertificateAttr", certAttr), 3);
                    try {
                        hash.put(certAttr, Base64.encode(cert.getEncoded()));
                        continue;
                    }
                    catch (CertificateEncodingException e) {
                        throw new BuildException(Bundle.getMessage("ERR_CertificateEncoding"), (Throwable)e);
                    }
                }
                try {
                    signature = Signature.getInstance(SHA1withRSA);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new BuildException(Bundle.getMessage("ERR_NoSuchAlgorithmException", SHA1withRSA), (Throwable)e);
                }
                try {
                    if (!(key instanceof PrivateKey)) {
                        key = null;
                    }
                    signature.initSign((PrivateKey)key);
                }
                catch (InvalidKeyException e) {
                    key = null;
                }
                if (key == null) {
                    throw new BuildException(Bundle.getMessage("ERR_InvalidPrivateKey", this.alias));
                }
                byte[] mem = new byte[16384];
                FileInputStream fis = new FileInputStream(this.jarFile);
                try {
                    int i;
                    while ((i = fis.read(mem)) >= 0) {
                        if (i < 0) continue;
                        signature.update(mem, 0, i);
                    }
                    byte[] signed = signature.sign();
                    this.log(Bundle.getMessage("MSG_AddingSignAttr", JAR_RSA_SHA1), 2);
                    hash.put(JAR_RSA_SHA1, Base64.encode(signed));
                }
                catch (SignatureException e) {
                    throw new BuildException((Throwable)e);
                }
                finally {
                    fis.close();
                }
            }
            if (isLiblet) {
                MessageDigest md;
                try {
                    md = MessageDigest.getInstance(SHA1);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new BuildException(Bundle.getMessage("ERR_NoSuchAlgorithmException", SHA1), (Throwable)e);
                }
                byte[] mem = new byte[16384];
                FileInputStream fis = new FileInputStream(this.jarFile);
                try {
                    int i;
                    while ((i = fis.read(mem)) >= 0) {
                        if (i < 0) continue;
                        md.update(mem, 0, i);
                    }
                    byte[] signed = md.digest();
                    this.log(Bundle.getMessage("MSG_AddingSignAttr", LIBLET_JAR_SHA1), 2);
                    hash.put(LIBLET_JAR_SHA1, Base64.encode(signed));
                }
                finally {
                    fis.close();
                }
            }
            this.log(Bundle.getMessage("MSG_Saving", jadTo.toString()), 3);
            PrintStream out = new PrintStream((OutputStream)new FileOutputStream(jadTo), false, this.encoding == null ? DEFAULT_ENCODING : this.encoding);
            Object[] keys = hash.keySet().toArray();
            if (keys != null) {
                Arrays.sort(keys);
                for (int a = 0; a < keys.length; ++a) {
                    out.println(keys[a] + ": " + (String)hash.get(keys[a]));
                }
            }
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public void setJadFile(File jadFile) {
        this.jadFile = jadFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public void setKeyStore(File keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType.toUpperCase();
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setAliasPassword(String aliasPassword) {
        this.aliasPassword = aliasPassword;
    }
}

