/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.debugger.ui.models.BreakpointGroup;
import org.netbeans.spi.viewmodel.CheckNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements CheckNodeModel {
    public static final String BREAKPOINT_GROUP = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    private final Collection modelListeners = new ArrayList();

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(BreakpointsNodeModel.class).getString("CTL_BreakpointModel_Column_Name_Name");
        }
        if (o instanceof BreakpointGroup) {
            return ((BreakpointGroup)o).getName();
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return "Root";
        }
        if (o instanceof BreakpointGroup) {
            return NbBundle.getBundle(BreakpointsNodeModel.class).getString("CTL_BreakpointModel_Column_GroupName_Desc");
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return BREAKPOINT_GROUP;
        }
        if (o instanceof BreakpointGroup) {
            return BREAKPOINT_GROUP;
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelEvent(ModelEvent ev) {
        ArrayList listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = new ArrayList(this.modelListeners);
        }
        for (ModelListener l : listeners) {
            l.modelChanged(ev);
        }
    }

    public boolean isCheckable(Object node) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(Object node) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(Object node) throws UnknownTypeException {
        if (node instanceof Breakpoint) {
            return ((Breakpoint)node).isEnabled();
        }
        if (node instanceof BreakpointGroup) {
            BreakpointGroup group = (BreakpointGroup)node;
            Enabled enabled = BreakpointsNodeModel.isEnabled(group);
            if (enabled == Enabled.YES) {
                return Boolean.TRUE;
            }
            if (enabled == Enabled.NO) {
                return Boolean.FALSE;
            }
            return null;
        }
        throw new UnknownTypeException(node);
    }

    private static Enabled isEnabled(BreakpointGroup group) {
        Enabled enabled = null;
        for (BreakpointGroup g : group.getSubGroups()) {
            Enabled ge = BreakpointsNodeModel.isEnabled(g);
            if (enabled == null) {
                enabled = ge;
                continue;
            }
            if (ge == null || (enabled = BreakpointsNodeModel.and(enabled, ge)) != Enabled.NA) continue;
            return Enabled.NA;
        }
        for (Breakpoint b : group.getBreakpoints()) {
            boolean be = b.isEnabled();
            if (enabled == null) {
                enabled = be ? Enabled.YES : Enabled.NO;
                continue;
            }
            if ((enabled != Enabled.YES || be) && (enabled != Enabled.NO || !be)) continue;
            return Enabled.NA;
        }
        return enabled;
    }

    private static Enabled and(Enabled e1, Enabled e2) {
        if (e1 == e2) {
            return e1;
        }
        return Enabled.NA;
    }

    public void setSelected(Object node, Boolean selected) throws UnknownTypeException {
        if (selected != null) {
            if (node instanceof Breakpoint) {
                Breakpoint bp = (Breakpoint)node;
                if (selected.booleanValue()) {
                    bp.enable();
                } else {
                    bp.disable();
                }
                this.fireModelEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)bp));
                String groupName = bp.getGroupName();
                if (groupName != null) {
                    this.fireModelEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)groupName));
                }
            } else if (node instanceof BreakpointGroup) {
                BreakpointGroup group = (BreakpointGroup)node;
                this.setSelected(group, selected);
            }
        }
    }

    private void setSelected(BreakpointGroup group, Boolean selected) {
        for (BreakpointGroup g : group.getSubGroups()) {
            this.setSelected(g, selected);
        }
        for (Breakpoint b : group.getBreakpoints()) {
            if (selected.booleanValue()) {
                b.enable();
            } else {
                b.disable();
            }
            this.fireModelEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)b));
        }
        this.fireModelEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)group));
    }

    static enum Enabled {
        YES,
        NO,
        NA;

    }
}

